/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.xml.dsig.Canonicalizer;
import com.ibm.xml.dsig.SignatureMethod;
import com.ibm.xml.dsig.Transform;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class AlgorithmFactory {
    protected String provider;
    protected Hashtable signatureMethodTable;
    protected Hashtable digestMethodTable;
    protected Hashtable transformTable;
    protected Hashtable canonicalizerTable;
    protected static Stack sha1Pool;
    protected static Stack rsaPool;
    protected static Stack dsaPool;
    protected static Stack hmacPool;
    protected static DocumentBuilderFactory documentBuilderFactory;
    protected static Stack documentBuilderPool;

    public AlgorithmFactory(String provider) {
        this.provider = provider;
        this.signatureMethodTable = new Hashtable();
        this.signatureMethodTable.put("http://www.w3.org/2000/09/xmldsig#dsa-sha1", "SHA1withDSA");
        this.signatureMethodTable.put("http://www.w3.org/2000/09/xmldsig#dsa", "SHA1withDSA");
        this.signatureMethodTable.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA1withRSA");
        this.digestMethodTable = new Hashtable();
        this.digestMethodTable.put("http://www.w3.org/2000/09/xmldsig#sha1", "SHA");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmldsig-more#md5", "md5");
        this.transformTable = new Hashtable();
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.xml.dsig.transform.ExclusiveC11r");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.xml.dsig.transform.ExclusiveC11rWC");
        this.transformTable.put("http://www.w3.org/2000/09/xmldsig#base64", "com.ibm.xml.dsig.transform.Base64Transformer");
        this.transformTable.put("http://www.w3.org/2000/09/xmldsig#enveloped-signature", "com.ibm.xml.dsig.transform.Enveloped");
        this.transformTable.put("http://www.w3.org/TR/1999/REC-xslt-19991116", "com.ibm.xml.dsig.transform.XSLTTransformer");
        this.transformTable.put("http://www.w3.org/TR/1999/REC-xpath-19991116", "com.ibm.xml.dsig.transform.XPathTransformer");
        this.transformTable.put("http://www.w3.org/2002/06/xmldsig-filter2", "com.ibm.xml.dsig.transform.XPath2Transformer");
        this.canonicalizerTable = new Hashtable();
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.xml.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.xml.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.xml.dsig.transform.ExclusiveC11r");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.xml.dsig.transform.ExclusiveC11rWC");
    }

    public String getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureMethod getSignatureMethod(String uri, Object parameter) throws NoSuchAlgorithmException, NoSuchProviderException {
        Stack stack;
        if (uri == null) {
            throw new NoSuchAlgorithmException("No SignatureMethod for null.");
        }
        if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(uri)) {
            stack = rsaPool;
            synchronized (stack) {
                if (!rsaPool.empty()) {
                    return (SignatureMethod)rsaPool.pop();
                }
            }
        }
        if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(uri)) {
            stack = dsaPool;
            synchronized (stack) {
                if (!dsaPool.empty()) {
                    return (SignatureMethod)dsaPool.pop();
                }
            }
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri)) {
            stack = hmacPool;
            synchronized (stack) {
                if (!hmacPool.empty()) {
                    SignatureMethod.SignatureMethodHMAC hmac = (SignatureMethod.SignatureMethodHMAC)hmacPool.pop();
                    hmac.setParam(parameter);
                    return hmac;
                }
            }
        }
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            SignatureMethod.SignatureMethodHMAC hmac = new SignatureMethod.SignatureMethodHMAC();
            hmac.setParam(parameter);
            return hmac;
        }
        String name = (String)this.signatureMethodTable.get(uri);
        if (name == null) {
            throw new NoSuchAlgorithmException("No SignatureMethod for " + uri);
        }
        return new SignatureMethod.SignatureMethodImpl(name, uri, this.provider);
    }

    public void releaseSignatureMethod(SignatureMethod sm) {
        if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(sm.getURI())) {
            rsaPool.push(sm);
        } else if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(sm.getURI())) {
            dsaPool.push(sm);
        } else if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(sm.getURI())) {
            hmacPool.push(sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDigest getDigestMethod(String uri) throws NoSuchAlgorithmException, NoSuchProviderException {
        String algName;
        if (uri == null) {
            throw new NoSuchAlgorithmException("null parameter.");
        }
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            Stack stack = sha1Pool;
            synchronized (stack) {
                if (!sha1Pool.empty()) {
                    return (MessageDigest)sha1Pool.pop();
                }
            }
        }
        if ((algName = (String)this.digestMethodTable.get(uri)) == null) {
            throw new NoSuchAlgorithmException("No DigestMethod for " + uri);
        }
        return this.provider == null ? MessageDigest.getInstance(algName) : MessageDigest.getInstance(algName, this.provider);
    }

    public void releaseDigestMethod(MessageDigest md, String uri) {
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(uri)) {
            sha1Pool.push(md);
        }
    }

    public Transform getTransform(String uri) throws NoSuchAlgorithmException {
        Object obj;
        if (uri == null) {
            throw new NoSuchAlgorithmException("null parameter.");
        }
        String className = (String)this.transformTable.get(uri);
        if (className == null) {
            throw new NoSuchAlgorithmException("Unknown algorithm URI: " + uri);
        }
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae.getMessage());
        }
        return (Transform)obj;
    }

    public Canonicalizer getCanonicalizer(String uri) {
        Object obj;
        if (uri == null) {
            return null;
        }
        String className = (String)this.canonicalizerTable.get(uri);
        if (className == null) {
            return null;
        }
        try {
            obj = Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (InstantiationException ie) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        return (Canonicalizer)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        Object object = documentBuilderPool;
        synchronized (object) {
            if (!documentBuilderPool.empty()) {
                return (DocumentBuilder)documentBuilderPool.pop();
            }
        }
        object = documentBuilderFactory;
        synchronized (object) {
            return documentBuilderFactory.newDocumentBuilder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDocumentBuilder(DocumentBuilder builder) {
        Stack stack = documentBuilderPool;
        synchronized (stack) {
            documentBuilderPool.push(builder);
        }
    }

    static {
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.TRUE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        documentBuilderPool = new Stack();
        sha1Pool = new Stack();
        rsaPool = new Stack();
        dsaPool = new Stack();
        hmacPool = new Stack();
    }
}

