/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.asn1;

import com.ibm.util.Hex;
import com.ibm.xml.asn1.Base64;
import com.ibm.xml.asn1.SAX2ASN1;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class UnlabelSAX
extends DefaultHandler {
    private static final String EMPTY = "";
    private ContentHandler handler;
    private SAX2ASN1 encoder;
    private String encoding;
    private Stack typeNames;
    private String typeName;
    private Vector elems;
    private boolean isSimple;
    private StringBuffer charBuf;
    private String typeName_;
    private String encoding_;
    private int length;
    private String elemName;
    private AttributesImpl attList;

    public UnlabelSAX(ContentHandler handler) {
        this.handler = handler;
        this.encoder = null;
        this.encoding = null;
        this.init();
    }

    public void init() {
        this.typeNames = new Stack();
        this.typeName = null;
        this.elems = new Vector();
        this.isSimple = false;
        this.charBuf = null;
        this.typeName_ = null;
        this.encoding_ = null;
        this.length = -1;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void startDocument() throws SAXException {
        this.handler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        String ty = atts.getValue("type");
        if (ty == null) {
            this.startPlainElement(name, atts);
        } else {
            String tc = atts.getValue("tagClass");
            if (tc == null) {
                this.startElementWithNoTag(atts);
            } else {
                this.startElementWithTag(atts);
            }
        }
    }

    private void startPlainElement(String name, Attributes atts) throws SAXException {
        if (name.equals("_BOOLEAN") || name.equals("_INTEGER") || name.equals("_ENUMERATED") || name.equals("_REAL") || name.equals("_BIT_STRING") || name.equals("_OCTET_STRING") || name.equals("_OBJECT_IDENTIFIER") || name.equals("_NumericString") || name.equals("_PrintableString") || name.equals("_TeletexString") || name.equals("_T61String") || name.equals("_VideotexString") || name.equals("_VisibleString") || name.equals("_ISO646String") || name.equals("_IA5String") || name.equals("_GraphicString") || name.equals("_GeneralString") || name.equals("_GeneralizedTime") || name.equals("_UTCTime") || name.equals("_ObjectDescriptor")) {
            this.startBooleanGroup(name, atts);
        } else if (name.equals("_NULL") || name.equals("_SEQUENCE") || name.equals("_SEQUENCE_OF") || name.equals("_SET") || name.equals("_SET_OF") || name.equals("_EXTERNAL")) {
            this.startSequenceGroup(name, atts);
        } else if (name.equals("_UNIVERSAL") || name.equals("_APPLICATION") || name.equals("_CONTEXT") || name.equals("_PRIVATE")) {
            this.startUniversalGroup(name, atts);
        } else {
            throw new SAXException("Unknown element name: " + name);
        }
        Stack<String> tt = new Stack<String>();
        tt.push(name);
        this.typeNames.push(tt);
    }

    private void startBooleanGroup(String name, Attributes atts) throws SAXException {
        this.isSimple = true;
        this.charBuf = new StringBuffer();
        this.typeName_ = name.substring(1).replace('_', ' ');
        String en = atts.getValue("encoding");
        if (en != null) {
            this.encoding_ = en;
            if (name.equals("_BIT_STRING")) {
                this.length = Integer.parseInt(atts.getValue("length"));
            }
        }
        this.elemName = name;
        this.attList = new AttributesImpl();
    }

    private void startSequenceGroup(String name, Attributes atts) throws SAXException {
        AttributesImpl aa = new AttributesImpl();
        this.handler.startElement(EMPTY, EMPTY, name, aa);
    }

    private void startUniversalGroup(String name, Attributes atts) throws SAXException {
        String ve = atts.getValue("valueEncoding");
        if (ve.equals("PRIMITIVE")) {
            this.isSimple = true;
            this.charBuf = new StringBuffer();
            this.typeName_ = "OCTET STRING";
            this.encoding_ = atts.getValue("encoding");
            this.elemName = name;
            this.attList = new AttributesImpl();
            this.attList.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", atts.getValue("tagNum"));
            this.attList.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", ve);
        } else if (ve.equals("CONSTRUCTED")) {
            AttributesImpl aa = new AttributesImpl();
            aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", atts.getValue("tagNum"));
            aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", ve);
            this.handler.startElement(EMPTY, EMPTY, name, aa);
        } else {
            throw new SAXException("Unknown value encoding: " + ve);
        }
    }

    private void startElementWithNoTag(Attributes atts) throws SAXException {
        String ty = atts.getValue("type");
        if (ty.equals("BOOLEAN") || ty.equals("INTEGER") || ty.equals("ENUMERATED") || ty.equals("REAL") || ty.equals("BIT STRING") || ty.equals("OCTET STRING") || ty.equals("OBJECT IDENTIFIER") || ty.equals("NumericString") || ty.equals("PrintableString") || ty.equals("TeletexString") || ty.equals("T61String") || ty.equals("VideotexString") || ty.equals("VisibleString") || ty.equals("ISO646String") || ty.equals("IA5String") || ty.equals("GraphicString") || ty.equals("GeneralString") || ty.equals("GeneralizedTime") || ty.equals("UTCTime") || ty.equals("ObjectDescriptor")) {
            this.startBooleanGroupWithNoTag(atts);
        } else if (ty.equals("NULL")) {
            this.startNullGroupWithNoTag(atts);
        } else if (ty.equals("SEQUENCE") || ty.equals("SEQUENCE OF") || ty.equals("SET") || ty.equals("SET OF") || ty.equals("EXTERNAL")) {
            this.startSequenceGroupWithNoTag(atts);
        } else if (ty.equals("CHOICE") || ty.equals("ANY") || ty.equals("TAGGED") || ty.equals("DEFINED")) {
            this.startChoiceGroupWithNoTag(atts);
        } else {
            throw new SAXException("Unknown type: " + ty);
        }
    }

    private void startBooleanGroupWithNoTag(Attributes atts) throws SAXException {
        this.isSimple = true;
        this.charBuf = new StringBuffer();
        Stack<String> tt = new Stack<String>();
        if (this.elems.isEmpty()) {
            String ty;
            this.typeName_ = ty = atts.getValue("type");
            String en = atts.getValue("encoding");
            if (en != null) {
                this.encoding_ = en;
                if (ty.equals("BIT STRING")) {
                    this.length = Integer.parseInt(atts.getValue("length"));
                }
            }
            this.elemName = ty = "_" + ty.replace(' ', '_');
            this.attList = new AttributesImpl();
            tt.push(ty);
        } else {
            String ty;
            int i = this.elems.size() - 2;
            String tc = (String)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            AttributesImpl aa = (AttributesImpl)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            this.typeName = ty = atts.getValue("type");
            this.typeName_ = ty;
            String en = atts.getValue("encoding");
            if (en != null) {
                this.encoding_ = en;
                if (ty.equals("BIT STRING")) {
                    this.length = Integer.parseInt(atts.getValue("length"));
                }
            }
            this.elemName = tc;
            aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "PRIMITIVE");
            this.attList = aa;
            tt.push(tc);
        }
        this.typeNames.push(tt);
    }

    private void startNullGroupWithNoTag(Attributes atts) throws SAXException {
        this.startSequenceGroupWithNoTag(atts, "PRIMITIVE");
    }

    private void startSequenceGroupWithNoTag(Attributes atts) throws SAXException {
        this.startSequenceGroupWithNoTag(atts, "CONSTRUCTED");
    }

    private void startSequenceGroupWithNoTag(Attributes atts, String enc) throws SAXException {
        Stack<String> tt = new Stack<String>();
        if (this.elems.isEmpty()) {
            String ty = atts.getValue("type");
            ty = "_" + ty.replace(' ', '_');
            AttributesImpl aa = new AttributesImpl();
            this.handler.startElement(EMPTY, EMPTY, ty, aa);
            tt.push(ty);
        } else {
            int i = this.elems.size() - 2;
            String tc = (String)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            AttributesImpl aa = (AttributesImpl)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", enc);
            this.handler.startElement(EMPTY, EMPTY, tc, aa);
            tt.push(tc);
        }
        this.typeNames.push(tt);
    }

    private void startChoiceGroupWithNoTag(Attributes atts) {
        Stack tt = new Stack();
        this.typeNames.push(tt);
    }

    private void startElementWithTag(Attributes atts) throws SAXException {
        String ty = atts.getValue("type");
        if (ty.equals("BOOLEAN") || ty.equals("INTEGER") || ty.equals("ENUMERATED") || ty.equals("REAL") || ty.equals("BIT STRING") || ty.equals("OCTET STRING") || ty.equals("OBJECT IDENTIFIER") || ty.equals("NumericString") || ty.equals("PrintableString") || ty.equals("TeletexString") || ty.equals("T61String") || ty.equals("VideotexString") || ty.equals("VisibleString") || ty.equals("ISO646String") || ty.equals("IA5String") || ty.equals("GraphicString") || ty.equals("GeneralString") || ty.equals("GeneralizedTime") || ty.equals("UTCTime") || ty.equals("ObjectDescriptor")) {
            this.startBooleanGroupWithTag(atts);
        } else if (ty.equals("NULL")) {
            this.startNullGroupWithTag(atts);
        } else if (ty.equals("SEQUENCE") || ty.equals("SEQUENCE OF") || ty.equals("SET") || ty.equals("SET OF") || ty.equals("EXTERNAL")) {
            this.startSequenceGroupWithTag(atts);
        } else if (ty.equals("CHOICE") || ty.equals("ANY") || ty.equals("TAGGED") || ty.equals("DEFINED")) {
            this.startChoiceGroupWithTag(atts);
        } else {
            throw new SAXException("Unknown type: " + ty);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startBooleanGroupWithTag(Attributes atts) throws SAXException {
        this.isSimple = true;
        this.charBuf = new StringBuffer();
        Stack<String> tt = new Stack<String>();
        if (this.elems.isEmpty()) {
            String tc = atts.getValue("tagClass");
            tc = "_" + tc;
            String ta = atts.getValue("tagging");
            if (ta.equals("EXPLICIT")) {
                String ty;
                AttributesImpl aa = new AttributesImpl();
                aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", atts.getValue("tagNum"));
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "CONSTRUCTED");
                this.handler.startElement(EMPTY, EMPTY, tc, aa);
                tt.push(tc);
                this.typeName_ = ty = atts.getValue("type");
                String en = atts.getValue("encoding");
                if (en != null) {
                    this.encoding_ = en;
                    if (ty.equals("BIT STRING")) {
                        this.length = Integer.parseInt(atts.getValue("length"));
                    }
                }
                this.elemName = ty = "_" + ty.replace(' ', '_');
                aa.clear();
                this.attList = aa;
                tt.push(ty);
            } else {
                String ty;
                if (!ta.equals("IMPLICIT")) throw new SAXException("Unknown tagging: " + ta);
                this.typeName = ty = atts.getValue("type");
                this.typeName_ = ty;
                String en = atts.getValue("encoding");
                if (en != null) {
                    this.encoding_ = en;
                    if (ty.equals("BIT STRING")) {
                        this.length = Integer.parseInt(atts.getValue("length"));
                    }
                }
                this.elemName = tc;
                AttributesImpl aa = new AttributesImpl();
                aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", atts.getValue("tagNum"));
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "PRIMITIVE");
                this.attList = aa;
                tt.push(tc);
            }
        } else {
            int i = this.elems.size() - 2;
            String tc = (String)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            AttributesImpl aa = (AttributesImpl)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            String ta = atts.getValue("tagging");
            if (ta.equals("EXPLICIT")) {
                String ty;
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "CONSTRUCTED");
                this.handler.startElement(EMPTY, EMPTY, tc, aa);
                tt.push(tc);
                this.typeName_ = ty = atts.getValue("type");
                String en = atts.getValue("encoding");
                if (en != null) {
                    this.encoding_ = en;
                    if (ty.equals("BIT STRING")) {
                        this.length = Integer.parseInt(atts.getValue("length"));
                    }
                }
                this.elemName = ty = "_" + ty.replace(' ', '_');
                aa.clear();
                this.attList = aa;
                tt.push(ty);
            } else {
                String ty;
                if (!ta.equals("IMPLICIT")) throw new SAXException("Unknown tagging: " + ta);
                this.typeName = ty = atts.getValue("type");
                this.typeName_ = ty;
                String en = atts.getValue("encoding");
                if (en != null) {
                    this.encoding_ = en;
                    if (ty.equals("BIT STRING")) {
                        this.length = Integer.parseInt(atts.getValue("length"));
                    }
                }
                this.elemName = tc;
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "PRIMITIVE");
                this.attList = aa;
                tt.push(tc);
            }
        }
        this.typeNames.push(tt);
    }

    private void startNullGroupWithTag(Attributes atts) throws SAXException {
        this.startSequenceGroupWithTag(atts, "PRIMITIVE");
    }

    private void startSequenceGroupWithTag(Attributes atts) throws SAXException {
        this.startSequenceGroupWithTag(atts, "CONSTRUCTED");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startSequenceGroupWithTag(Attributes atts, String enc) throws SAXException {
        Stack<String> tt = new Stack<String>();
        if (this.elems.isEmpty()) {
            String tc = atts.getValue("tagClass");
            tc = "_" + tc;
            String ta = atts.getValue("tagging");
            if (ta.equals("EXPLICIT")) {
                AttributesImpl aa = new AttributesImpl();
                aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", atts.getValue("tagNum"));
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "CONSTRUCTED");
                this.handler.startElement(EMPTY, EMPTY, tc, aa);
                tt.push(tc);
                String ty = atts.getValue("type");
                ty = "_" + ty.replace(' ', '_');
                aa.clear();
                this.handler.startElement(EMPTY, EMPTY, ty, aa);
                tt.push(ty);
            } else {
                if (!ta.equals("IMPLICIT")) throw new SAXException("Unknown tagging: " + ta);
                AttributesImpl aa = new AttributesImpl();
                aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", atts.getValue("tagNum"));
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", enc);
                this.handler.startElement(EMPTY, EMPTY, tc, aa);
                tt.push(tc);
            }
        } else {
            int i = this.elems.size() - 2;
            String tc = (String)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            AttributesImpl aa = (AttributesImpl)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            String ta = atts.getValue("tagging");
            if (ta.equals("EXPLICIT")) {
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "CONSTRUCTED");
                this.handler.startElement(EMPTY, EMPTY, tc, aa);
                tt.push(tc);
                String ty = atts.getValue("type");
                ty = "_" + ty.replace(' ', '_');
                aa.clear();
                this.handler.startElement(EMPTY, EMPTY, ty, aa);
                tt.push(ty);
            } else {
                if (!ta.equals("IMPLICIT")) throw new SAXException("Unknown tagging: " + ta);
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", enc);
                this.handler.startElement(EMPTY, EMPTY, tc, aa);
                tt.push(tc);
            }
        }
        this.typeNames.push(tt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startChoiceGroupWithTag(Attributes atts) throws SAXException {
        Stack<String> tt = new Stack<String>();
        if (this.elems.isEmpty()) {
            String tc = atts.getValue("tagClass");
            tc = "_" + tc;
            String ta = atts.getValue("tagging");
            if (ta.equals("EXPLICIT")) {
                AttributesImpl aa = new AttributesImpl();
                aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", atts.getValue("tagNum"));
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "CONSTRUCTED");
                this.handler.startElement(EMPTY, EMPTY, tc, aa);
                tt.push(tc);
            } else {
                if (!ta.equals("IMPLICIT")) throw new SAXException("Unknown tagging: " + ta);
                this.elems.addElement(tc);
                AttributesImpl aa = new AttributesImpl();
                aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", atts.getValue("tagNum"));
                this.elems.addElement(aa);
            }
        } else {
            int i = this.elems.size() - 2;
            String tc = (String)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            AttributesImpl aa = (AttributesImpl)this.elems.elementAt(i);
            this.elems.removeElementAt(i);
            String ta = atts.getValue("tagging");
            if (ta.equals("EXPLICIT")) {
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "CONSTRUCTED");
                this.handler.startElement(EMPTY, EMPTY, tc, aa);
                tt.push(tc);
            } else {
                if (!ta.equals("IMPLICIT")) throw new SAXException("Unknown tagging: " + ta);
                this.elems.addElement(tc);
                this.elems.addElement(aa);
            }
        }
        this.typeNames.push(tt);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.isSimple) {
            String st = this.charBuf.toString();
            if (this.typeName == null) {
                this.endElementWithNoTagOrExplicitTag(st);
            } else {
                this.endElementWithImplicitTag(st);
                this.typeName = null;
            }
            this.charBuf = null;
            this.isSimple = false;
        }
        Stack tt = (Stack)this.typeNames.pop();
        while (!tt.empty()) {
            this.handler.endElement(EMPTY, EMPTY, (String)tt.pop());
        }
    }

    private void endElementWithNoTagOrExplicitTag(String str) throws SAXException {
        if (this.typeName_.equals("BIT STRING") || this.typeName_.equals("OCTET STRING")) {
            if (this.encoding_ != null) {
                str = this.decodeString(str, this.typeName_, this.encoding_, this.length);
            }
            if (this.encoding != null) {
                this.attList.addAttribute(EMPTY, EMPTY, "encoding", "CDATA", this.encoding);
                if (this.typeName_.equals("BIT STRING")) {
                    this.attList.addAttribute(EMPTY, EMPTY, "length", "CDATA", String.valueOf(str.length()));
                }
                str = this.encodeString(str, this.typeName_, this.encoding);
            }
            this.typeName_ = null;
            this.encoding_ = null;
            this.length = -1;
        }
        this.handler.startElement(EMPTY, EMPTY, this.elemName, this.attList);
        this.elemName = null;
        this.attList = null;
        char[] cc = str.toCharArray();
        this.handler.characters(cc, 0, cc.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String decodeString(String str, String name, String enc, int len) throws SAXException {
        String str_ = null;
        if (name.equals("BIT STRING")) {
            if (!enc.equals("base64")) throw new SAXException("Unknown encoding: " + enc);
            return Base64.decodeBitString(str, len);
        }
        if (!name.equals("OCTET STRING")) throw new SAXException("Unknown type name: " + name);
        if (!enc.equals("base64")) throw new SAXException("Unknown encoding: " + enc);
        return Base64.decodeOctetString(str);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String encodeString(String str, String name, String enc) throws SAXException {
        String str_ = null;
        if (name.equals("BIT STRING")) {
            if (!enc.equals("base64")) throw new SAXException("Unknown encoding: " + enc);
            return Base64.encodeBitString(str);
        }
        if (!name.equals("OCTET STRING")) throw new SAXException("Unknown type name: " + name);
        if (!enc.equals("base64")) throw new SAXException("Unknown encoding: " + enc);
        return Base64.encodeOctetString(str);
    }

    private void endElementWithImplicitTag(String str) throws SAXException {
        if (this.typeName_.equals("BIT STRING") || this.typeName_.equals("OCTET STRING")) {
            if (this.encoding_ != null) {
                str = this.decodeString(str, this.typeName_, this.encoding_, this.length);
            }
            this.typeName_ = null;
            this.encoding_ = null;
            this.length = -1;
        }
        str = this.encodeValue(str, this.typeName);
        if (this.encoding != null) {
            this.attList.addAttribute(EMPTY, EMPTY, "encoding", "CDATA", this.encoding);
            str = this.encodeString(str, "OCTET STRING", this.encoding);
        }
        this.handler.startElement(EMPTY, EMPTY, this.elemName, this.attList);
        this.elemName = null;
        this.attList = null;
        char[] cc = str.toCharArray();
        this.handler.characters(cc, 0, cc.length);
    }

    private String encodeValue(String str, String name) throws SAXException {
        if (this.encoder == null) {
            this.encoder = new SAX2ASN1();
        } else {
            this.encoder.init();
        }
        String ty = "_" + name.replace(' ', '_');
        AttributesImpl aa = new AttributesImpl();
        this.encoder.startElement(EMPTY, EMPTY, ty, aa);
        char[] cc = str.toCharArray();
        this.encoder.characters(cc, 0, cc.length);
        this.encoder.endElement(EMPTY, EMPTY, ty);
        byte[] bb = this.encoder.toByteArray();
        bb = this.getValue(bb);
        return Hex.toString((byte[])bb);
    }

    private byte[] getValue(byte[] tlv) {
        byte[] value = null;
        if ((0x80 & tlv[1]) == 0) {
            value = this.getByteArray(tlv, 2, tlv.length - 2);
        } else {
            int l = 0x7F & tlv[1];
            value = this.getByteArray(tlv, l + 2, tlv.length - l - 2);
        }
        return value;
    }

    private byte[] getByteArray(byte[] byts, int off, int len) {
        byte[] _byts = new byte[len];
        int i = 0;
        int j = off;
        while (i < len) {
            _byts[i] = byts[j];
            ++i;
            ++j;
        }
        return _byts;
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.isSimple) {
            this.charBuf.append(chars, start, length);
        }
    }
}

