/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.asn1;

import java.io.PrintWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXEventDumper
extends DefaultHandler {
    private static final String SEP = System.getProperty("line.separator");
    private static final int UNKNOWN = -1;
    private static final int START_DOCUMENT = 0;
    private static final int START_ELEMENT = 1;
    private static final int CHARACTERS = 2;
    private static final int END_X = 3;
    private Writer out = new PrintWriter(System.out);
    private String xmlVersion = null;
    private String xmlEncoding = null;
    private String dtdName = null;
    private String dtdFileName = null;
    private boolean format = true;
    private boolean isHead;
    private int tab;
    private int event;

    public SAXEventDumper() {
        this.init();
    }

    public void init() {
        this.isHead = true;
        this.tab = 0;
        this.event = -1;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setWriter(Writer out) {
        this.out = out;
    }

    public void setXMLDeclaration(String version, String encoding) {
        this.xmlVersion = version;
        this.xmlEncoding = encoding;
    }

    public void setDoctypeDeclaration(String name, String fileName) {
        this.dtdName = name;
        this.dtdFileName = fileName;
    }

    public void startDocument() throws SAXException {
        try {
            if (this.xmlVersion != null) {
                this.out.write(this.sep() + this.tab() + "<?xml version=\"" + this.xmlVersion + "\"");
                if (this.xmlEncoding != null) {
                    this.out.write(" encoding=\"" + this.xmlEncoding + "\"");
                }
                this.out.write("?>");
                this.out.flush();
                this.isHead = false;
            }
            if (this.dtdName != null) {
                this.out.write(this.sep() + this.tab() + "<!DOCTYPE " + this.dtdName + " SYSTEM \"" + this.dtdFileName + "\">");
                this.out.flush();
                this.isHead = false;
            }
            this.event = 0;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private String sep() {
        if (!this.format) {
            return "";
        }
        String sep = SEP;
        if (this.isHead) {
            sep = "";
        }
        return sep;
    }

    private String tab() {
        if (!this.format) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.tab; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public void endDocument() throws SAXException {
        try {
            this.out.write(this.sep());
            this.out.flush();
            this.event = 3;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        try {
            this.out.write(this.sep() + this.tab() + "<" + name);
            int l = atts.getLength();
            for (int i = 0; i < l; ++i) {
                this.out.write(" " + atts.getQName(i) + "=\"" + atts.getValue(i) + "\"");
            }
            this.out.write(">");
            this.out.flush();
            this.isHead = false;
            this.tab += 2;
            this.event = 1;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            this.tab -= 2;
            switch (this.event) {
                case 1: 
                case 2: {
                    this.out.write("</" + name + ">");
                    this.out.flush();
                    break;
                }
                default: {
                    this.out.write(this.sep() + this.tab());
                    this.out.write("</" + name + ">");
                    this.out.flush();
                }
            }
            this.event = 3;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            this.out.write(this.replaceChars(chars, start, length));
            this.out.flush();
            this.event = 2;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private String replaceChars(char[] chars, int start, int length) {
        StringBuffer buf = new StringBuffer();
        block4: for (int i = start; i < start + length; ++i) {
            char c = chars[i];
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block4;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

