/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.asn1;

import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.ASN1OID;
import com.ibm.asn1.ASN1Tag;
import com.ibm.asn1.BEREncoder;
import com.ibm.util.BitString;
import com.ibm.util.Hex;
import com.ibm.xml.asn1.Base64;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAX2ASN1
extends DefaultHandler {
    private OutputStream out = null;
    private BEREncoder encoder;
    private byte[] data;
    private String elemName;
    private Stack ids;
    private String encoding;
    private int length;

    public SAX2ASN1() {
        this.init();
    }

    public void init() {
        this.encoder = new BEREncoder();
        this.data = null;
        this.elemName = null;
        this.ids = new Stack();
        this.encoding = null;
        this.length = -1;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        try {
            if (this.out != null) {
                this.out.write(this.data);
                this.out.flush();
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        block11: {
            try {
                if (name.equals("_BOOLEAN") || name.equals("_INTEGER") || name.equals("_ENUMERATED") || name.equals("_REAL") || name.equals("_BIT_STRING") || name.equals("_OCTET_STRING") || name.equals("_OBJECT_IDENTIFIER") || name.equals("_NumericString") || name.equals("_PrintableString") || name.equals("_TeletexString") || name.equals("_T61String") || name.equals("_VideotexString") || name.equals("_VisibleString") || name.equals("_ISO646String") || name.equals("_IA5String") || name.equals("_GraphicString") || name.equals("_GeneralString") || name.equals("_GeneralizedTime") || name.equals("_UTCTime") || name.equals("_ObjectDescriptor")) {
                    this.elemName = name;
                    String en = atts.getValue("encoding");
                    if (en != null) {
                        this.encoding = en;
                        if (name.equals("_BIT_STRING")) {
                            this.length = Integer.parseInt(atts.getValue("length"));
                        }
                    }
                    break block11;
                }
                if (name.equals("_NULL")) {
                    this.encoder.encodeNull();
                    break block11;
                }
                if (name.equals("_SEQUENCE") || name.equals("_SEQUENCE_OF")) {
                    int i = this.encoder.encodeSequence();
                    this.ids.push(new Integer(i));
                    break block11;
                }
                if (name.equals("_SET") || name.equals("_SET_OF")) {
                    int i = this.encoder.encodeSet();
                    this.ids.push(new Integer(i));
                    break block11;
                }
                if (name.equals("_UNIVERSAL") || name.equals("_APPLICATION") || name.equals("_CONTEXT") || name.equals("_PRIVATE")) {
                    this.startUniversalGroup(name, atts);
                    break block11;
                }
                if (name.equals("_EXTERNAL")) {
                    this.encoder.nextIsImplicit(8);
                    int i = this.encoder.encodeSequence();
                    this.ids.push(new Integer(i));
                    break block11;
                }
                throw new SAXException("Unknown element name: " + name);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private void startUniversalGroup(String name, Attributes atts) throws ASN1Exception {
        int tc = this.toTagClass(name);
        int tn = Integer.parseInt(atts.getValue("tagNum"));
        int ta = ASN1Tag.makeTag((int)tc, (int)tn);
        this.encoder.nextIsImplicit(ta);
        String ve = atts.getValue("valueEncoding");
        if (ve.equals("CONSTRUCTED")) {
            int i = this.encoder.encodeSequence();
            this.ids.push(new Integer(i));
        } else if (ve.equals("PRIMITIVE")) {
            this.ids.push(new String("%dummy%"));
            this.elemName = "_OCTET_STRING";
            this.encoding = atts.getValue("encoding");
        } else {
            throw new ASN1Exception("Unknown value encoding: " + ve);
        }
    }

    private int toTagClass(String str) throws ASN1Exception {
        int tagCl = -1;
        if (str.equals("_UNIVERSAL")) {
            tagCl = 0;
        } else if (str.equals("_APPLICATION")) {
            tagCl = 1;
        } else if (str.equals("_CONTEXT")) {
            tagCl = 2;
        } else if (str.equals("_PRIVATE")) {
            tagCl = 3;
        } else {
            throw new ASN1Exception("Unknown class name: " + str);
        }
        return tagCl;
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (name.equals("_BOOLEAN") || name.equals("_INTEGER") || name.equals("_ENUMERATED") || name.equals("_REAL") || name.equals("_BIT_STRING") || name.equals("_OCTET_STRING") || name.equals("_OBJECT_IDENTIFIER") || name.equals("_NumericString") || name.equals("_PrintableString") || name.equals("_TeletexString") || name.equals("_T61String") || name.equals("_VideotexString") || name.equals("_VisibleString") || name.equals("_ISO646String") || name.equals("_IA5String") || name.equals("_GraphicString") || name.equals("_GeneralString") || name.equals("_GeneralizedTime") || name.equals("_UTCTime") || name.equals("_ObjectDescriptor")) {
                this.elemName = null;
            } else if (!name.equals("_NULL")) {
                if (name.equals("_SEQUENCE") || name.equals("_SEQUENCE_OF") || name.equals("_SET") || name.equals("_SET_OF") || name.equals("_EXTERNAL")) {
                    int i = (Integer)this.ids.pop();
                    this.encoder.endOf(i);
                } else if (name.equals("_UNIVERSAL") || name.equals("_APPLICATION") || name.equals("_CONTEXT") || name.equals("_PRIVATE")) {
                    this.endUniversalGroup(name);
                } else {
                    throw new SAXException("Unknown element name: " + name);
                }
            }
            if (this.ids.empty()) {
                this.data = this.encoder.toByteArray();
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void endUniversalGroup(String name) throws ASN1Exception {
        Object o = this.ids.pop();
        if (o instanceof Integer) {
            int i = (Integer)o;
            this.encoder.endOf(i);
        } else if (o instanceof String) {
            this.elemName = null;
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        block24: {
            try {
                if (this.elemName == null) break block24;
                String st = new String(chars, start, length);
                if (this.elemName.equals("_BOOLEAN")) {
                    boolean b = false;
                    if (st.equals("TRUE")) {
                        b = true;
                    }
                    this.encoder.encodeBoolean(b);
                    break block24;
                }
                if (this.elemName.equals("_INTEGER")) {
                    BigInteger bi = new BigInteger(st);
                    this.encoder.encodeInteger(bi);
                    break block24;
                }
                if (this.elemName.equals("_ENUMERATED")) {
                    int i = Integer.parseInt(st);
                    this.encoder.encodeEnumeration(i);
                    break block24;
                }
                if (this.elemName.equals("_REAL")) {
                    double d = Double.valueOf(st);
                    this.encoder.encodeReal(d);
                    break block24;
                }
                if (this.elemName.equals("_BIT_STRING")) {
                    if (this.encoding != null) {
                        st = this.decodeBitString(st, this.encoding, this.length);
                        this.encoding = null;
                        this.length = -1;
                    }
                    BitString bs = this.toBitString(st);
                    this.encoder.encodeBitString(bs);
                    break block24;
                }
                if (this.elemName.equals("_OCTET_STRING")) {
                    if (this.encoding != null) {
                        st = this.decodeOctetString(st, this.encoding);
                        this.encoding = null;
                    }
                    byte[] bb = Hex.toByteArray((String)st);
                    this.encoder.encodeOctetString(bb, 0, bb.length);
                    break block24;
                }
                if (this.elemName.equals("_OBJECT_IDENTIFIER")) {
                    ASN1OID id = new ASN1OID(null, st);
                    this.encoder.encodeObjectIdentifier(id);
                    break block24;
                }
                if (this.elemName.equals("_NumericString")) {
                    this.encoder.encodeNumericString(st);
                    break block24;
                }
                if (this.elemName.equals("_PrintableString")) {
                    this.encoder.encodePrintableString(st);
                    break block24;
                }
                if (this.elemName.equals("_TeletexString") || this.elemName.equals("_T61String")) {
                    this.encoder.encodeT61String(st);
                    break block24;
                }
                if (this.elemName.equals("_VideotexString")) {
                    this.encoder.encodeVisibleString(st);
                    break block24;
                }
                if (this.elemName.equals("_VisibleString") || this.elemName.equals("_ISO646String")) {
                    this.encoder.encodeVisibleString(st);
                    break block24;
                }
                if (this.elemName.equals("_IA5String")) {
                    this.encoder.encodeIA5String(st);
                    break block24;
                }
                if (this.elemName.equals("_GraphicString")) {
                    this.encoder.encodeGraphicString(st);
                    break block24;
                }
                if (this.elemName.equals("_GeneralString")) {
                    this.encoder.encodeGeneralString(st);
                    break block24;
                }
                if (this.elemName.equals("_GeneralizedTime")) {
                    this.encoder.encodeGeneralizedTime(st);
                    break block24;
                }
                if (this.elemName.equals("_UTCTime")) {
                    this.encoder.encodeUTCTime(st);
                    break block24;
                }
                if (this.elemName.equals("_ObjectDescriptor")) {
                    this.encoder.nextIsImplicit(7);
                    this.encoder.encodeGraphicString(st);
                    break block24;
                }
                throw new SAXException("Unknown element name: " + this.elemName);
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private String decodeBitString(String str, String enc, int len) throws SAXException {
        String str_ = null;
        if (!enc.equals("base64")) {
            throw new SAXException("Unknown encoding: " + enc);
        }
        str_ = Base64.decodeBitString(str, len);
        return str_;
    }

    private String decodeOctetString(String str, String enc) throws SAXException {
        String str_ = null;
        if (!enc.equals("base64")) {
            throw new SAXException("Unknown encoding: " + enc);
        }
        str_ = Base64.decodeOctetString(str);
        return str_;
    }

    private BitString toBitString(String str) {
        BitString bStr = null;
        Vector<Byte> byts = new Vector<Byte>();
        int p = 0;
        int l = str.length();
        for (int i = 0; i < l; i += 8) {
            StringBuffer b = new StringBuffer();
            b.append(str.substring(i, i + 8 > l ? l : i + 8));
            int j = b.length();
            if (j < 8) {
                for (int k = 8 - j; k > 0; --k) {
                    b.append("0");
                }
                p = 8 - j;
            }
            byts.addElement(this.toByte(b.toString()));
        }
        int s = byts.size();
        if (s > 0) {
            byte[] bb = new byte[s];
            for (int i = 0; i < s; ++i) {
                bb[i] = (Byte)byts.elementAt(i);
            }
            bStr = new BitString(bb, 0, s * 8 - p, true);
        } else {
            bStr = BitString.EMPTY;
        }
        return bStr;
    }

    private Byte toByte(String str) {
        Byte byt = null;
        byte b = 0;
        byte[] bb = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        for (int i = 0; i < 8; ++i) {
            if (str.charAt(i) != '1') continue;
            b = (byte)(b | bb[i]);
        }
        byt = new Byte(b);
        return byt;
    }

    public byte[] toByteArray() {
        return this.data;
    }
}

