/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.asn1;

import com.ibm.util.Hex;
import com.ibm.xml.asn1.ASN12SAX;
import com.ibm.xml.asn1.Base64;
import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.InsertableElement;
import com.ibm.xml.parser.TXDocument;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class LabelSAX
extends DefaultHandler {
    private static final String EMPTY = "";
    private ContentHandler handler;
    private DTD dtd;
    private String dtdName;
    private Document factory;
    private Element dummy;
    private ASN12SAX decoder;
    private String encoding;
    private Element elem;
    private Stack elemNames;
    private Element subelem;
    private String typeName;
    private Stack subeNames;
    private String typeName_;
    private String tagClass;
    private String tagNum;
    private String tagging;
    private boolean isSimple;
    private String typeName__;
    private String encoding_;
    private int length;

    public LabelSAX(ContentHandler handler) {
        this.handler = handler;
        this.dtd = null;
        this.dtdName = null;
        this.factory = new TXDocument();
        this.dummy = this.factory.createElement("dummy");
        this.decoder = null;
        this.encoding = null;
        this.init();
    }

    public void init() {
        this.elem = null;
        this.elemNames = new Stack();
        this.subelem = null;
        this.typeName = null;
        this.subeNames = null;
        this.typeName_ = null;
        this.tagClass = null;
        this.tagNum = null;
        this.tagging = null;
        this.isSimple = false;
        this.typeName__ = null;
        this.encoding_ = null;
        this.length = -1;
    }

    public void setDTD(DTD dtd, String name) {
        this.dtd = dtd;
        this.dtdName = name;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void startDocument() throws SAXException {
        this.handler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.subeNames == null) {
            Element el = this.findElement(this.elem, name, atts);
            if (el == null) {
                throw new SAXException("Unknown element name: " + name);
            }
            if (this.isDummy(el)) {
                Stack nn = new Stack();
                this.elemNames.push(nn);
            } else {
                if (this.elem == null) {
                    this.elem = el;
                } else {
                    this.elem.appendChild(el);
                }
                this.fireStartEvents(el);
            }
        } else {
            String na = name.substring(1).replace('_', ' ');
            if (na.equals(this.typeName_)) {
                this.subeNames.push(name);
                this.typeName__ = na;
                this.encoding_ = atts.getValue("encoding");
                if (this.encoding_ != null && na.equals("BIT STRING")) {
                    this.length = Integer.parseInt(atts.getValue("length"));
                }
                this.isSimple = true;
            } else {
                throw new SAXException("Unknown element name: " + name);
            }
        }
    }

    private boolean isDummy(Element elem) {
        return elem == this.dummy;
    }

    private void fireStartEvents(Element elem) throws SAXException {
        Stack<String> nn = new Stack<String>();
        while (true) {
            nn.push(elem.getTagName());
            if ((this.isSimple && this.subelem == null || this.subeNames != null) && !elem.hasChildNodes()) break;
            this.fireStartEvent(elem);
            if (!elem.hasChildNodes()) break;
            elem = (Element)elem.getFirstChild();
        }
        this.elem = elem;
        this.elemNames.push(nn);
    }

    private void fireStartEvent(Element elem) throws SAXException {
        String na = elem.getTagName();
        AttributesImpl aa = new AttributesImpl();
        NamedNodeMap nnm = elem.getAttributes();
        if (nnm != null) {
            int l = nnm.getLength();
            for (int i = 0; i < l; ++i) {
                Attr at = (Attr)nnm.item(i);
                aa.addAttribute(EMPTY, EMPTY, at.getName(), "CDATA", at.getValue());
            }
        }
        this.handler.startElement(EMPTY, EMPTY, na, aa);
    }

    private Element findElement(Element elem, String name, Attributes atts) throws SAXException {
        Element elem_ = null;
        if (this.subelem == null) {
            if (elem == null) {
                Element el = this.findElement(this.dtdName, name, atts);
                if (el != null) {
                    elem_ = el;
                }
            } else {
                Hashtable ht = this.dtd.prepareTable(elem.getTagName());
                this.dtd.getAppendableElements(elem, ht);
                Enumeration en = ht.elements();
                while (en.hasMoreElements()) {
                    Element el;
                    InsertableElement ie = (InsertableElement)en.nextElement();
                    if (ie.name.equals(" *ERROR* ") || ie.name.equals(" *EOC* ") || ie.name.equals("#PCDATA") || !ie.status || (el = this.findElement(ie.name, name, atts)) == null) continue;
                    elem_ = el;
                    break;
                }
            }
        } else {
            Element el = this.findElement(this.subelem.getTagName(), name, atts);
            if (el != null) {
                elem_ = el;
            }
        }
        return elem_;
    }

    private Element findElement(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        elem = this.tagClass == null && this.dtd.getAttributeDeclaration(ieName, "tagClass") == null ? this._findElement(ieName, name, atts) : this.findTaggedElement(ieName, name, atts);
        return elem;
    }

    private Element _findElement(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        elem = this.dtd.getAttributeDeclaration(ieName, "type") == null ? this.findPlainElement(ieName, name, atts) : this.findLabeledElement(ieName, name, atts);
        return elem;
    }

    private Element findPlainElement(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        if (ieName.equals("_BOOLEAN") || ieName.equals("_INTEGER") || ieName.equals("_ENUMERATED") || ieName.equals("_REAL") || ieName.equals("_BIT_STRING") || ieName.equals("_OCTET_STRING") || ieName.equals("_OBJECT_IDENTIFIER") || ieName.equals("_NumericString") || ieName.equals("_PrintableString") || ieName.equals("_TeletexString") || ieName.equals("_T61String") || ieName.equals("_VideotexString") || ieName.equals("_VisibleString") || ieName.equals("_ISO646String") || ieName.equals("_IA5String") || ieName.equals("_GraphicString") || ieName.equals("_GeneralString") || ieName.equals("_GeneralizedTime") || ieName.equals("_UTCTime") || ieName.equals("_ObjectDescriptor")) {
            if (ieName.equals(name)) {
                elem = this.factory.createElement(ieName);
                this.typeName__ = ieName.substring(1).replace('_', ' ');
                this.encoding_ = atts.getValue("encoding");
                if (this.encoding_ != null && ieName.equals("_BIT_STRING")) {
                    this.length = Integer.parseInt(atts.getValue("length"));
                }
                this.isSimple = true;
            }
        } else if (ieName.equals("_NULL") || ieName.equals("_SEQUENCE") || ieName.equals("_SEQUENCE_OF") || ieName.equals("_SET") || ieName.equals("_SET_OF") || ieName.equals("_EXTERNAL")) {
            if (ieName.equals(name)) {
                elem = this.factory.createElement(ieName);
            }
        } else if (ieName.equals("_UNIVERSAL") || ieName.equals("_APPLICATION") || ieName.equals("_CONTEXT") || ieName.equals("_PRIVATE")) {
            if (ieName.equals(name)) {
                elem = this.factory.createElement(ieName);
                elem.setAttribute("tagNum", atts.getValue("tagNum"));
                String ve = atts.getValue("valueEncoding");
                elem.setAttribute("valueEncoding", ve);
                if (ve.equals("PRIMITIVE")) {
                    this.typeName__ = "OCTET STRING";
                    this.encoding_ = atts.getValue("encoding");
                    this.isSimple = true;
                }
            }
        } else {
            throw new SAXException("Unknown element name: " + ieName);
        }
        return elem;
    }

    private Element findLabeledElement(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        String na = name.substring(1).replace('_', ' ');
        String ty = this.dtd.getAttributeDeclaration(ieName, "type").getDefaultStringValue();
        if ((ty = this.simplifyTypeName(ty)).equals("BOOLEAN") || ty.equals("INTEGER") || ty.equals("ENUMERATED") || ty.equals("REAL") || ty.equals("BIT STRING") || ty.equals("OCTET STRING") || ty.equals("OBJECT IDENTIFIER") || ty.equals("NumericString") || ty.equals("PrintableString") || ty.equals("T61String") || ty.equals("VideotexString") || ty.equals("VisibleString") || ty.equals("IA5String") || ty.equals("GraphicString") || ty.equals("GeneralString") || ty.equals("GeneralizedTime") || ty.equals("UTCTime") || ty.equals("ObjectDescriptor")) {
            if (ty.equals(na)) {
                elem = this.factory.createElement(ieName);
                this.typeName__ = ty;
                this.encoding_ = atts.getValue("encoding");
                if (this.encoding_ != null && ty.equals("BIT STRING")) {
                    this.length = Integer.parseInt(atts.getValue("length"));
                }
                this.isSimple = true;
            }
        } else if (ty.equals("NULL") || ty.equals("SEQUENCE") || ty.equals("SET") || ty.equals("EXTERNAL")) {
            if (ty.equals(na)) {
                elem = this.factory.createElement(ieName);
            }
        } else if (ty.equals("CHOICE") || ty.equals("TAGGED") || ty.equals("DEFINED")) {
            Element el = this.factory.createElement(ieName);
            Element el_ = this.findElement(el, name, atts);
            if (el_ != null) {
                if (!this.isDummy(el_)) {
                    el.appendChild(el_);
                }
                elem = el;
            }
        } else if (ty.equals("ANY")) {
            elem = this.factory.createElement(ieName);
            Element el = this.findPlainElement(name, name, atts);
            elem.appendChild(el);
        } else {
            throw new SAXException("Unknown type name: " + ty);
        }
        return elem;
    }

    private String simplifyTypeName(String name) {
        if (name.equals("SEQUENCE OF")) {
            name = "SEQUENCE";
        } else if (name.equals("SET OF")) {
            name = "SET";
        } else if (name.equals("TeletexString")) {
            name = "T61String";
        } else if (name.equals("ISO646String")) {
            name = "VisibleString";
        }
        return name;
    }

    private Element findTaggedElement(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        String ty = this.dtd.getAttributeDeclaration(ieName, "type").getDefaultStringValue();
        if ((ty = this.simplifyTypeName(ty)).equals("BOOLEAN") || ty.equals("INTEGER") || ty.equals("ENUMERATED") || ty.equals("REAL") || ty.equals("OBJECT IDENTIFIER")) {
            elem = this.findTaggedElementInBooleanGroup(ieName, name, atts);
        } else if (ty.equals("BIT STRING") || ty.equals("OCTET STRING") || ty.equals("NumericString") || ty.equals("PrintableString") || ty.equals("T61String") || ty.equals("VideotexString") || ty.equals("VisibleString") || ty.equals("IA5String") || ty.equals("GraphicString") || ty.equals("GeneralString") || ty.equals("GeneralizedTime") || ty.equals("UTCTime") || ty.equals("ObjectDescriptor")) {
            elem = this.findTaggedElementInBitStringGroup(ieName, name, atts);
        } else if (ty.equals("NULL") || ty.equals("SEQUENCE") || ty.equals("SET") || ty.equals("EXTERNAL")) {
            elem = this.findTaggedElementInSequenceGroup(ieName, name, atts);
        } else if (ty.equals("CHOICE") || ty.equals("ANY")) {
            elem = this.findTaggedElementInChoiceGroup(ieName, name, atts);
        } else if (ty.equals("TAGGED")) {
            elem = this.findTaggedElementInTaggedGroup(ieName, name, atts);
        } else if (ty.equals("DEFINED")) {
            elem = this.findTaggedElementInDefinedGroup(ieName, name, atts);
        } else {
            throw new SAXException("Unknown type name: " + ty);
        }
        return elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element findTaggedElementInBooleanGroup(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        String na = name.substring(1).replace('_', ' ');
        if (this.subelem == null) {
            if (!na.equals("UNIVERSAL") && !na.equals("APPLICATION") && !na.equals("CONTEXT") && !na.equals("PRIVATE") || !this.areSameTags(ieName, name, atts)) return elem;
            String ty = this.dtd.getAttributeDeclaration(ieName, "type").getDefaultStringValue();
            ty = this.simplifyTypeName(ty);
            String ta = this.tagging;
            if (ta == null) {
                ta = this.dtd.getAttributeDeclaration(ieName, "tagging").getDefaultStringValue();
            }
            if (ta.equals("EXPLICIT")) {
                elem = this.dummy;
                this.subelem = this.factory.createElement(ieName);
                this.typeName = ty;
                return elem;
            } else {
                if (!ta.equals("IMPLICIT")) throw new SAXException("Unknown tagging: " + ta);
                elem = this.dummy;
                this.subelem = this.factory.createElement(ieName);
                this.typeName = ty;
                this.typeName__ = "OCTET STRING";
                this.encoding_ = atts.getValue("encoding");
                this.isSimple = true;
            }
            return elem;
        } else {
            if (!na.equals(this.typeName)) return elem;
            elem = this.subelem;
            this.subelem = null;
            this.typeName = null;
            this.typeName__ = na;
            this.encoding_ = null;
            this.isSimple = true;
        }
        return elem;
    }

    private boolean areSameTags(String ieName, String name, Attributes atts) {
        String tc_;
        boolean flag = false;
        String tc = this.tagClass;
        if (tc == null) {
            tc = this.dtd.getAttributeDeclaration(ieName, "tagClass").getDefaultStringValue();
        }
        if (tc.equals(tc_ = name.substring(1).replace('_', ' '))) {
            String tn_;
            String tn = this.tagNum;
            if (tn == null) {
                tn = this.dtd.getAttributeDeclaration(ieName, "tagNum").getDefaultStringValue();
            }
            if (tn.equals(tn_ = atts.getValue("tagNum"))) {
                flag = true;
            }
        }
        return flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element findTaggedElementInBitStringGroup(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        String na = name.substring(1).replace('_', ' ');
        if (this.subelem == null) {
            if (!na.equals("UNIVERSAL") && !na.equals("APPLICATION") && !na.equals("CONTEXT") && !na.equals("PRIVATE") || !this.areSameTags(ieName, name, atts)) return elem;
            String ty = this.dtd.getAttributeDeclaration(ieName, "type").getDefaultStringValue();
            ty = this.simplifyTypeName(ty);
            String ta = this.tagging;
            if (ta == null) {
                ta = this.dtd.getAttributeDeclaration(ieName, "tagging").getDefaultStringValue();
            }
            if (ta.equals("EXPLICIT")) {
                elem = this.dummy;
                this.subelem = this.factory.createElement(ieName);
                this.typeName = ty;
                return elem;
            } else {
                if (!ta.equals("IMPLICIT")) throw new SAXException("Unknown tagging: " + ta);
                String ve = atts.getValue("valueEncoding");
                if (ve.equals("PRIMITIVE")) {
                    elem = this.dummy;
                    this.subelem = this.factory.createElement(ieName);
                    this.typeName = ty;
                    this.typeName__ = "OCTET STRING";
                    this.encoding_ = atts.getValue("encoding");
                    this.isSimple = true;
                    return elem;
                } else {
                    if (!ve.equals("CONSTRUCTED")) throw new SAXException("Unknown value encoding: " + ve);
                    elem = this.factory.createElement(ieName);
                    this.subeNames = new Stack();
                    this.subeNames.push(name);
                    this.typeName_ = ty;
                }
            }
            return elem;
        } else {
            if (!na.equals(this.typeName)) return elem;
            elem = this.subelem;
            this.subelem = null;
            this.typeName = null;
            this.typeName__ = na;
            this.encoding_ = atts.getValue("encoding");
            if (this.encoding_ != null && na.equals("BIT STRING")) {
                this.length = Integer.parseInt(atts.getValue("length"));
            }
            this.isSimple = true;
        }
        return elem;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Element findTaggedElementInSequenceGroup(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        String na = name.substring(1).replace('_', ' ');
        if (this.subelem != null) {
            if (!na.equals(this.typeName)) return elem;
            elem = this.subelem;
            this.subelem = null;
            this.typeName = null;
            return elem;
        }
        if (!(na.equals("UNIVERSAL") || na.equals("APPLICATION") || na.equals("CONTEXT"))) {
            if (!na.equals("PRIVATE")) return elem;
        }
        if (!this.areSameTags(ieName, name, atts)) return elem;
        String ta = this.tagging;
        if (ta == null) {
            ta = this.dtd.getAttributeDeclaration(ieName, "tagging").getDefaultStringValue();
        }
        if (ta.equals("EXPLICIT")) {
            elem = this.dummy;
            this.subelem = this.factory.createElement(ieName);
            ta = this.dtd.getAttributeDeclaration(ieName, "type").getDefaultStringValue();
            this.typeName = ta = this.simplifyTypeName(ta);
            return elem;
        }
        if (!ta.equals("IMPLICIT")) throw new SAXException("Unknown tagging: " + ta);
        return this.factory.createElement(ieName);
    }

    private Element findTaggedElementInChoiceGroup(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        String na = name.substring(1).replace('_', ' ');
        if ((na.equals("UNIVERSAL") || na.equals("APPLICATION") || na.equals("CONTEXT") || na.equals("PRIVATE")) && this.areSameTags(ieName, name, atts)) {
            String ta = this.tagging;
            if (ta == null) {
                ta = this.dtd.getAttributeDeclaration(ieName, "tagging").getDefaultStringValue();
            }
            if (ta.equals("EXPLICIT")) {
                elem = this.factory.createElement(ieName);
            } else {
                if (ta.equals("IMPLICIT")) {
                    throw new SAXException("Incorrect tagging: IMPLICIT");
                }
                throw new SAXException("Unknown tagging: " + ta);
            }
        }
        return elem;
    }

    private Element findTaggedElementInTaggedGroup(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        String na = name.substring(1).replace('_', ' ');
        if ((na.equals("UNIVERSAL") || na.equals("APPLICATION") || na.equals("CONTEXT") || na.equals("PRIVATE")) && this.areSameTags(ieName, name, atts)) {
            String ta = this.tagging;
            if (ta == null) {
                ta = this.dtd.getAttributeDeclaration(ieName, "tagging").getDefaultStringValue();
            }
            if (ta.equals("EXPLICIT")) {
                elem = this.factory.createElement(ieName);
            } else if (ta.equals("IMPLICIT")) {
                Element el_;
                Element el = this.factory.createElement(ieName);
                Hashtable ht = new Hashtable();
                this.findAttributeValues(ieName, ht);
                String ien = (String)ht.get("name");
                String tc = (String)ht.get("tagClass");
                tc = "_" + tc;
                AttributesImpl aa = new AttributesImpl();
                String av = (String)ht.get("tagNum");
                aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", av);
                av = atts.getValue("valueEncoding");
                aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", av);
                av = atts.getValue("encoding");
                if (av != null) {
                    aa.addAttribute(EMPTY, EMPTY, "encoding", "CDATA", av);
                }
                if ((el_ = this.findTaggedElement(ien, tc, aa)) != null) {
                    if (!this.isDummy(el_)) {
                        el.appendChild(el_);
                    }
                    elem = el;
                }
            } else {
                throw new SAXException("Unknown tagging: " + ta);
            }
        }
        return elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findAttributeValues(String name, Hashtable vals) throws SAXException {
        String na = this.findNameOfInsertableElement(name);
        AttDef ad = this.dtd.getAttributeDeclaration(na, "tagClass");
        if (ad == null) {
            String ty = this.dtd.getAttributeDeclaration(na, "type").getDefaultStringValue();
            if ((ty = this.simplifyTypeName(ty)).equals("BOOLEAN") || ty.equals("INTEGER") || ty.equals("ENUMERATED") || ty.equals("REAL") || ty.equals("BIT STRING") || ty.equals("OCTET STRING") || ty.equals("NULL") || ty.equals("SEQUENCE") || ty.equals("SET") || ty.equals("CHOICE") || ty.equals("ANY") || ty.equals("OBJECT IDENTIFIER") || ty.equals("NumericString") || ty.equals("PrintableString") || ty.equals("T61String") || ty.equals("VideotexString") || ty.equals("VisibleString") || ty.equals("IA5String") || ty.equals("GraphicString") || ty.equals("GeneralString") || ty.equals("GeneralizedTime") || ty.equals("UTCTime") || ty.equals("EXTERNAL") || ty.equals("ObjectDescriptor")) return;
            if (!ty.equals("TAGGED") && !ty.equals("DEFINED")) throw new SAXException("Unknown type name: " + ty);
            this.findAttributeValues(na, vals);
            return;
        } else {
            vals.put("name", na);
            String tc = ad.getDefaultStringValue();
            vals.put("tagClass", tc);
            String tn = this.dtd.getAttributeDeclaration(na, "tagNum").getDefaultStringValue();
            vals.put("tagNum", tn);
        }
    }

    private String findNameOfInsertableElement(String name) {
        String name_ = null;
        Element el = this.factory.createElement(name);
        Hashtable ht = this.dtd.prepareTable(name);
        this.dtd.getAppendableElements(el, ht);
        Enumeration en = ht.elements();
        while (en.hasMoreElements()) {
            InsertableElement ie = (InsertableElement)en.nextElement();
            if (ie.name.equals(" *ERROR* ") || ie.name.equals(" *EOC* ") || ie.name.equals("#PCDATA") || !ie.status) continue;
            name_ = ie.name;
            break;
        }
        return name_;
    }

    private Element findTaggedElementInDefinedGroup(String ieName, String name, Attributes atts) throws SAXException {
        Element elem = null;
        String na = name.substring(1).replace('_', ' ');
        if ((na.equals("UNIVERSAL") || na.equals("APPLICATION") || na.equals("CONTEXT") || na.equals("PRIVATE")) && this.areSameTags(ieName, name, atts)) {
            String ta = this.tagging;
            if (ta == null) {
                ta = this.dtd.getAttributeDeclaration(ieName, "tagging").getDefaultStringValue();
            }
            if (ta.equals("EXPLICIT")) {
                elem = this.factory.createElement(ieName);
            } else if (ta.equals("IMPLICIT")) {
                Element el = this.factory.createElement(ieName);
                Hashtable ht = new Hashtable();
                this.findAttributeValues(ieName, ht);
                Element el_ = null;
                String tc = (String)ht.get("tagClass");
                if (tc == null) {
                    this.tagClass = na;
                    this.tagNum = atts.getValue("tagNum");
                    this.tagging = "IMPLICIT";
                    el_ = this.findElement(el, name, atts);
                    this.tagClass = null;
                    this.tagNum = null;
                    this.tagging = null;
                } else {
                    tc = "_" + tc;
                    AttributesImpl aa = new AttributesImpl();
                    String av = (String)ht.get("tagNum");
                    aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", av);
                    av = atts.getValue("valueEncoding");
                    aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", av);
                    av = atts.getValue("encoding");
                    if (av != null) {
                        aa.addAttribute(EMPTY, EMPTY, "encoding", "CDATA", av);
                    }
                    el_ = this.findElement(el, tc, (Attributes)aa);
                }
                if (el_ != null) {
                    if (!this.isDummy(el_)) {
                        el.appendChild(el_);
                    }
                    elem = el;
                }
            } else {
                throw new SAXException("Unknown tagging: " + ta);
            }
        }
        return elem;
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.subeNames == null) {
            this.fireEndEvents();
        } else {
            this.subeNames.pop();
            if (this.subeNames.empty()) {
                String st = this.elem.getFirstChild().getNodeValue();
                if ((this.typeName_.equals("BIT STRING") || this.typeName_.equals("OCTET STRING")) && this.encoding != null) {
                    this.elem.setAttribute("encoding", this.encoding);
                    if (this.typeName_.equals("BIT STRING")) {
                        this.elem.setAttribute("length", String.valueOf(st.length()));
                    }
                    st = this.encodeString(st, this.typeName_, this.encoding);
                }
                this.fireStartEvent(this.elem);
                char[] cc = st.toCharArray();
                this.handler.characters(cc, 0, cc.length);
                this.fireEndEvents();
                this.subeNames = null;
                this.typeName_ = null;
            }
        }
    }

    private void fireEndEvents() throws SAXException {
        Stack nn = (Stack)this.elemNames.pop();
        while (!nn.empty()) {
            if (!this.isComplete(this.elem)) {
                throw new SAXException("Incomplete node: " + this.elem.getTagName());
            }
            this.removeChildren(this.elem);
            this.elem = (Element)this.elem.getParentNode();
            this.handler.endElement(EMPTY, EMPTY, (String)nn.pop());
        }
    }

    private boolean isComplete(Element elem) {
        Hashtable ht = this.dtd.prepareTable(elem.getTagName());
        this.dtd.getAppendableElements(elem, ht);
        InsertableElement ie = (InsertableElement)ht.get(" *EOC* ");
        return ie.status;
    }

    private void removeChildren(Node node) {
        Node nd0 = node.getFirstChild();
        Node nd1 = null;
        while (nd0 != null) {
            nd1 = nd0.getNextSibling();
            node.removeChild(nd0);
            nd0 = nd1;
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.isSimple) {
            this.isSimple = false;
            String st = new String(chars, start, length);
            if (this.subeNames == null) {
                if (this.subelem == null) {
                    if (this.typeName__.equals("BIT STRING") || this.typeName__.equals("OCTET STRING")) {
                        if (this.encoding_ != null) {
                            st = this.decodeString(st, this.typeName__, this.encoding_, this.length);
                        }
                        if (this.encoding != null) {
                            this.elem.setAttribute("encoding", this.encoding);
                            if (this.typeName__.equals("BIT STRING")) {
                                this.elem.setAttribute("length", String.valueOf(st.length()));
                            }
                            st = this.encodeString(st, this.typeName__, this.encoding);
                        }
                        this.typeName__ = null;
                        this.encoding_ = null;
                        this.length = -1;
                    }
                    Text tx = this.factory.createTextNode(st);
                    this.elem.appendChild(tx);
                    this.fireStartEvent(this.elem);
                    char[] cc = st.toCharArray();
                    this.handler.characters(cc, 0, cc.length);
                } else {
                    if (this.decoder == null) {
                        this.decoder = new ASN12SAX(this);
                        this.decoder.setPartialDecoding(true);
                    } else {
                        this.decoder.init();
                    }
                    if (this.typeName__.equals("OCTET STRING")) {
                        if (this.encoding_ != null) {
                            st = this.decodeString(st, this.typeName__, this.encoding_, -1);
                        }
                        this.typeName__ = null;
                        this.encoding_ = null;
                    }
                    byte[] bb = Hex.toByteArray((String)st);
                    bb = this.addTagAndLengthFields(bb, this.typeName);
                    this.decoder.setByteArray(bb);
                    this.decoder.start();
                }
            } else {
                Text tx;
                if (this.typeName__.equals("BIT STRING") || this.typeName__.equals("OCTET STRING")) {
                    if (this.encoding_ != null) {
                        st = this.decodeString(st, this.typeName__, this.encoding_, this.length);
                    }
                    this.typeName__ = null;
                    this.encoding_ = null;
                    this.length = -1;
                }
                if ((tx = (Text)this.elem.getFirstChild()) == null) {
                    tx = this.factory.createTextNode(st);
                    this.elem.appendChild(tx);
                } else {
                    tx.appendData(st);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String decodeString(String str, String name, String enc, int len) throws SAXException {
        String str_ = null;
        if (name.equals("BIT STRING")) {
            if (!enc.equals("base64")) throw new SAXException("Unknown encoding: " + enc);
            return Base64.decodeBitString(str, len);
        }
        if (!name.equals("OCTET STRING")) throw new SAXException("Unknown type name: " + name);
        if (!enc.equals("base64")) throw new SAXException("Unknown encoding: " + enc);
        return Base64.decodeOctetString(str);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String encodeString(String str, String name, String enc) throws SAXException {
        String str_ = null;
        if (name.equals("BIT STRING")) {
            if (!enc.equals("base64")) throw new SAXException("Unknown encoding: " + enc);
            return Base64.encodeBitString(str);
        }
        if (!name.equals("OCTET STRING")) throw new SAXException("Unknown type name: " + name);
        if (!enc.equals("base64")) throw new SAXException("Unknown encoding: " + enc);
        return Base64.encodeOctetString(str);
    }

    private byte[] addTagAndLengthFields(byte[] value, String name) {
        byte[] tlv = null;
        byte[] tt = new byte[]{this.toTag(name)};
        if (tt[0] == 0) {
            tt = null;
        }
        byte[] ll = null;
        if (value.length < 128) {
            ll = new byte[]{(byte)value.length};
        } else {
            BigInteger bi = new BigInteger(String.valueOf(value.length));
            byte[] ll_ = bi.toByteArray();
            byte l_ = (byte)(0x80 | ll_.length);
            ll = this.insertByte(l_, ll_);
        }
        if (tt != null && ll != null) {
            tlv = this.concatByteArrays(tt, this.concatByteArrays(ll, value));
        }
        return tlv;
    }

    private byte toTag(String name) {
        int tag = 0;
        if (name.equals("BOOLEAN")) {
            tag = 1;
        } else if (name.equals("INTEGER")) {
            tag = 2;
        } else if (name.equals("BIT STRING")) {
            tag = 3;
        } else if (name.equals("OCTET STRING")) {
            tag = 4;
        } else if (name.equals("NULL")) {
            tag = 5;
        } else if (name.equals("OBJECT IDENTIFIER")) {
            tag = 6;
        } else if (name.equals("ObjectDescriptor")) {
            tag = 7;
        } else if (name.equals("EXTERNAL")) {
            tag = 8;
        } else if (name.equals("REAL")) {
            tag = 9;
        } else if (name.equals("ENUMERATED")) {
            tag = 10;
        } else if (name.equals("SEQUENCE")) {
            tag = 16;
        } else if (name.equals("SET")) {
            tag = 17;
        } else if (name.equals("NumericString")) {
            tag = 18;
        } else if (name.equals("PrintableString")) {
            tag = 19;
        } else if (name.equals("T61String")) {
            tag = 20;
        } else if (name.equals("VideotexString")) {
            tag = 21;
        } else if (name.equals("IA5String")) {
            tag = 22;
        } else if (name.equals("UTCTime")) {
            tag = 23;
        } else if (name.equals("GeneralizedTime")) {
            tag = 24;
        } else if (name.equals("GraphicString")) {
            tag = 25;
        } else if (name.equals("VisibleString")) {
            tag = 26;
        } else if (name.equals("GeneralString")) {
            tag = 27;
        }
        return (byte)tag;
    }

    private byte[] insertByte(byte aByt, byte[] byts) {
        byte[] byts_ = new byte[byts.length + 1];
        byts_[0] = aByt;
        int l = byts.length;
        for (int i = 0; i < l; ++i) {
            byts_[i + 1] = byts[i];
        }
        return byts_;
    }

    private byte[] concatByteArrays(byte[] byts0, byte[] byts1) {
        byte[] byts_ = new byte[byts0.length + byts1.length];
        int j = 0;
        int i = 0;
        int l = byts0.length;
        while (i < l) {
            byts_[j] = byts0[i];
            ++i;
            ++j;
        }
        i = 0;
        l = byts1.length;
        while (i < l) {
            byts_[j] = byts1[i];
            ++i;
            ++j;
        }
        return byts_;
    }
}

