/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.asn1;

import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.ASN1OID;
import com.ibm.asn1.ASN1Tag;
import com.ibm.asn1.BERDecoder;
import com.ibm.util.BitString;
import com.ibm.util.Hex;
import com.ibm.xml.asn1.Base64;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Calendar;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ASN12SAX {
    private static final String EMPTY = "";
    private ContentHandler handler;
    private boolean isPartial;
    private String encoding;
    private BERDecoder decoder;
    private InputStream in;
    private byte[] data;

    public ASN12SAX(ContentHandler handler) {
        this.handler = handler;
        this.isPartial = false;
        this.encoding = null;
        this.init();
    }

    public void init() {
        this.decoder = null;
        this.in = null;
        this.data = null;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setByteArray(byte[] data) {
        this.data = data;
    }

    public void setPartialDecoding(boolean isPartial) {
        this.isPartial = isPartial;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void start() throws SAXException {
        try {
            if (this.in != null) {
                this.decoder = new BERDecoder(this.in);
            }
            if (this.data != null) {
                this.decoder = new BERDecoder(this.data);
            }
            if (this.decoder != null) {
                if (!this.isPartial) {
                    this.handler.startDocument();
                }
                this.decode();
                if (!this.isPartial) {
                    this.handler.endDocument();
                }
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void decode() throws ASN1Exception, SAXException {
        int cl = ASN1Tag.getTagClass((int)this.decoder.peekNextTag());
        switch (cl) {
            case 0: {
                this.decodeUniversal();
                break;
            }
            default: {
                this.decodeOther();
            }
        }
    }

    private void decodeUniversal() throws ASN1Exception, SAXException {
        int ta = this.decoder.peekNextTag();
        switch (ta) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                this.decodeBooleanGroup(ta);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                this.decodeBitStringGroup(ta);
                break;
            }
            case 8: 
            case 16: 
            case 17: {
                this.decodeSequenceGroup(ta);
                break;
            }
            default: {
                throw new ASN1Exception("Unknown tag: " + ta);
            }
        }
    }

    private void decodeBooleanGroup(int tag) throws ASN1Exception, SAXException {
        String na = this.toTypeName(tag);
        AttributesImpl aa = new AttributesImpl();
        this.handler.startElement(EMPTY, EMPTY, na, aa);
        char[] cc = this.decodeSimpleType(tag);
        if (cc != null) {
            this.handler.characters(cc, 0, cc.length);
        }
        this.handler.endElement(EMPTY, EMPTY, na);
    }

    private String toTypeName(int tag) throws ASN1Exception {
        String name = null;
        switch (tag) {
            case 1: {
                name = "_BOOLEAN";
                break;
            }
            case 2: {
                name = "_INTEGER";
                break;
            }
            case 3: {
                name = "_BIT_STRING";
                break;
            }
            case 4: {
                name = "_OCTET_STRING";
                break;
            }
            case 5: {
                name = "_NULL";
                break;
            }
            case 6: {
                name = "_OBJECT_IDENTIFIER";
                break;
            }
            case 7: {
                name = "_ObjectDescriptor";
                break;
            }
            case 8: {
                name = "_EXTERNAL";
                break;
            }
            case 9: {
                name = "_REAL";
                break;
            }
            case 10: {
                name = "_ENUMERATED";
                break;
            }
            case 16: {
                name = "_SEQUENCE";
                break;
            }
            case 17: {
                name = "_SET";
                break;
            }
            case 18: {
                name = "_NumericString";
                break;
            }
            case 19: {
                name = "_PrintableString";
                break;
            }
            case 20: {
                name = "_T61String";
                break;
            }
            case 21: {
                name = "_VideotexString";
                break;
            }
            case 22: {
                name = "_IA5String";
                break;
            }
            case 23: {
                name = "_UTCTime";
                break;
            }
            case 24: {
                name = "_GeneralizedTime";
                break;
            }
            case 25: {
                name = "_GraphicString";
                break;
            }
            case 26: {
                name = "_VisibleString";
                break;
            }
            case 27: {
                name = "_GeneralString";
                break;
            }
            default: {
                throw new ASN1Exception("Unknown tag: " + tag);
            }
        }
        return name;
    }

    private char[] decodeSimpleType(int tag) throws ASN1Exception {
        char[] value = null;
        switch (tag) {
            case 1: {
                boolean b = this.decoder.decodeBoolean();
                value = String.valueOf(b).toUpperCase().toCharArray();
                break;
            }
            case 2: {
                BigInteger bi = this.decoder.decodeInteger();
                value = bi.toString().toCharArray();
                break;
            }
            case 10: {
                int i = this.decoder.decodeEnumeration();
                value = String.valueOf(i).toCharArray();
                break;
            }
            case 9: {
                double d = this.decoder.decodeReal();
                value = String.valueOf(d).toCharArray();
                break;
            }
            case 3: {
                BitString bs = this.decoder.decodeBitString();
                value = bs.toString().toCharArray();
                break;
            }
            case 4: {
                byte[] bb = this.decoder.decodeOctetString();
                value = Hex.toString((byte[])bb).toCharArray();
                break;
            }
            case 5: {
                this.decoder.decodeNull();
                break;
            }
            case 6: {
                ASN1OID id = this.decoder.decodeObjectIdentifier();
                value = id.toString().toCharArray();
                break;
            }
            case 18: {
                String s = this.decoder.decodeNumericString();
                value = s.toCharArray();
                break;
            }
            case 19: {
                String s = this.decoder.decodePrintableString();
                value = s.toCharArray();
                break;
            }
            case 20: {
                String s = this.decoder.decodeT61String();
                value = s.toCharArray();
                break;
            }
            case 21: {
                String s = this.decoder.decodeVideotexString();
                value = s.toCharArray();
                break;
            }
            case 26: {
                String s = this.decoder.decodeVisibleString();
                value = s.toCharArray();
                break;
            }
            case 22: {
                String s = this.decoder.decodeIA5String();
                value = s.toCharArray();
                break;
            }
            case 25: {
                String s = this.decoder.decodeGraphicString();
                value = s.toCharArray();
                break;
            }
            case 27: {
                String s = this.decoder.decodeGeneralString();
                value = s.toCharArray();
                break;
            }
            case 24: {
                Calendar c = this.decoder.decodeGeneralizedTime();
                value = this.toGeneralizedTime(c).toCharArray();
                break;
            }
            case 23: {
                Calendar c = this.decoder.decodeUTCTime();
                value = this.toUTCTime(c).toCharArray();
                break;
            }
            case 7: {
                this.decoder.nextIsImplicit(7);
                String s = this.decoder.decodeGraphicString();
                value = s.toCharArray();
                break;
            }
            default: {
                throw new ASN1Exception("Unknown tag: " + tag);
            }
        }
        return value;
    }

    private String toGeneralizedTime(Calendar date) {
        return this.toTime(date, true);
    }

    private String toUTCTime(Calendar date) {
        return this.toTime(date, false);
    }

    private String toTime(Calendar date, boolean isGT) {
        int i;
        StringBuffer buf = new StringBuffer();
        String s = String.valueOf(date.get(1));
        int o = isGT ? 4 : 2;
        buf.append(s.substring(s.length() - o));
        s = String.valueOf(date.get(2) + 1);
        buf.append(this.formatString(s, 2));
        s = String.valueOf(date.get(5));
        buf.append(this.formatString(s, 2));
        s = String.valueOf(date.get(11));
        buf.append(this.formatString(s, 2));
        s = String.valueOf(date.get(12));
        buf.append(this.formatString(s, 2));
        s = String.valueOf(date.get(13));
        buf.append(this.formatString(s, 2));
        if (isGT) {
            String s_ = String.valueOf(date.get(14));
            while (s_.endsWith("0")) {
                s_ = s_.substring(0, s_.length() - 1);
            }
            if (!s_.equals(EMPTY)) {
                buf.append("." + s_);
            }
        }
        if ((i = date.get(15)) == 0) {
            buf.append("Z");
        } else {
            buf.append(i > 0 ? "+" : "-");
            i = Math.abs(i);
            s = String.valueOf(i / 3600000);
            buf.append(this.formatString(s, 2));
            s = String.valueOf(i % 3600000 / 60000);
            buf.append(this.formatString(s, 2));
        }
        return buf.toString();
    }

    private String formatString(String str, int len) {
        StringBuffer buf = new StringBuffer();
        int j = len - str.length();
        for (int i = 0; i < j; ++i) {
            buf.append("0");
        }
        buf.append(str);
        return buf.toString();
    }

    private void decodeBitStringGroup(int tag) throws ASN1Exception, SAXException {
        String na = this.toTypeName(tag);
        AttributesImpl aa = new AttributesImpl();
        char[] cc = null;
        if (this.decoder.nextTagConstructed()) {
            StringBuffer s = new StringBuffer();
            this.decoder.nextIsImplicit(tag);
            int i = this.decoder.decodeSequence();
            while (!this.decoder.endOf(i)) {
                cc = this.decodeSimpleType(tag);
                s.append(cc);
            }
            cc = s.toString().toCharArray();
        } else {
            cc = this.decodeSimpleType(tag);
        }
        if (this.encoding != null) {
            switch (tag) {
                case 3: {
                    aa.addAttribute(EMPTY, EMPTY, "encoding", "CDATA", this.encoding);
                    aa.addAttribute(EMPTY, EMPTY, "length", "CDATA", String.valueOf(cc.length));
                    cc = this.encodeBitString(cc, this.encoding);
                    break;
                }
                case 4: {
                    aa.addAttribute(EMPTY, EMPTY, "encoding", "CDATA", this.encoding);
                    cc = this.encodeOctetString(cc, this.encoding);
                }
            }
        }
        this.handler.startElement(EMPTY, EMPTY, na, aa);
        this.handler.characters(cc, 0, cc.length);
        this.handler.endElement(EMPTY, EMPTY, na);
    }

    private char[] encodeBitString(char[] chars, String enc) throws SAXException {
        char[] chars_ = null;
        if (!enc.equals("base64")) {
            throw new SAXException("Unknown encoding: " + enc);
        }
        chars_ = Base64.encodeBitString(String.valueOf(chars)).toCharArray();
        return chars_;
    }

    private char[] encodeOctetString(char[] chars, String enc) throws SAXException {
        char[] chars_ = null;
        if (!enc.equals("base64")) {
            throw new SAXException("Unknown encoding: " + enc);
        }
        chars_ = Base64.encodeOctetString(String.valueOf(chars)).toCharArray();
        return chars_;
    }

    private void decodeSequenceGroup(int tag) throws ASN1Exception, SAXException {
        String na = this.toTypeName(tag);
        AttributesImpl aa = new AttributesImpl();
        this.handler.startElement(EMPTY, EMPTY, na, aa);
        int i = this.decodeStructuredType(tag);
        while (!this.decoder.endOf(i)) {
            this.decode();
        }
        this.handler.endElement(EMPTY, EMPTY, na);
    }

    private int decodeStructuredType(int tag) throws ASN1Exception {
        int id = -1;
        switch (tag) {
            case 16: {
                id = this.decoder.decodeSequence();
                break;
            }
            case 17: {
                id = this.decoder.decodeSet();
                break;
            }
            case 8: {
                this.decoder.nextIsImplicit(8);
                id = this.decoder.decodeSequence();
                break;
            }
            default: {
                throw new ASN1Exception("Unknown tag: " + tag);
            }
        }
        return id;
    }

    private void decodeOther() throws ASN1Exception, SAXException {
        int ta = this.decoder.peekNextTag();
        String na = this.toClassName(ASN1Tag.getTagClass((int)ta));
        AttributesImpl aa = new AttributesImpl();
        aa.addAttribute(EMPTY, EMPTY, "tagNum", "CDATA", String.valueOf(ASN1Tag.getTagNumber((int)ta)));
        if (this.decoder.nextTagConstructed()) {
            aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "CONSTRUCTED");
            this.handler.startElement(EMPTY, EMPTY, na, aa);
            this.decoder.nextIsImplicit(ta);
            int i = this.decoder.decodeSequence();
            while (!this.decoder.endOf(i)) {
                this.decode();
            }
        } else {
            aa.addAttribute(EMPTY, EMPTY, "valueEncoding", "CDATA", "PRIMITIVE");
            if (this.encoding != null) {
                aa.addAttribute(EMPTY, EMPTY, "encoding", "CDATA", this.encoding);
            }
            this.handler.startElement(EMPTY, EMPTY, na, aa);
            this.decoder.nextIsImplicit(ta);
            byte[] bb = this.decoder.decodeOctetString();
            char[] cc = Hex.toString((byte[])bb).toCharArray();
            if (this.encoding != null) {
                cc = this.encodeOctetString(cc, this.encoding);
            }
            this.handler.characters(cc, 0, cc.length);
        }
        this.handler.endElement(EMPTY, EMPTY, na);
    }

    private String toClassName(int tagCl) throws ASN1Exception {
        String name = null;
        switch (tagCl) {
            case 0: {
                name = "_UNIVERSAL";
                break;
            }
            case 1: {
                name = "_APPLICATION";
                break;
            }
            case 2: {
                name = "_CONTEXT";
                break;
            }
            case 3: {
                name = "_PRIVATE";
                break;
            }
            default: {
                throw new ASN1Exception("Unknown tag class: " + tagCl);
            }
        }
        return name;
    }
}

