/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.C14nUtil;
import com.ibm.dom.util.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XPathCanonicalizer {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";

    public static byte[] serializeAll(Document doc, boolean withComments) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            XPathCanonicalizer.serializeNode(null, doc, null, withComments, false, wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static void serializeAll(Document doc, boolean withComments, Writer wr) throws IOException {
        XPathCanonicalizer.serializeNode(null, doc, null, withComments, false, wr);
    }

    public static byte[] serializeSubset(Node node, boolean withComments) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            XPathCanonicalizer.serializeNode(node, node, null, withComments, true, wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static void serializeSubset(Node node, boolean withComments, Writer wr) throws IOException {
        XPathCanonicalizer.serializeNode(node, node, null, withComments, true, wr);
    }

    public static NodeList toNodeset(Node node, Node exceptedNode, boolean withComments) {
        NodeListImpl nodeList = new NodeListImpl();
        XPathCanonicalizer.toNodeset_addNode(nodeList, node, exceptedNode, withComments);
        return nodeList;
    }

    private static void toNodeset_addNode(NodeListImpl nodeList, Node node, Node exceptedNode, boolean withComments) {
        if (node == exceptedNode) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                nodeList.add(node);
                Hashtable namespaces = XPathCanonicalizer.collectNamespaceNodesInAncestors(node, true);
                Enumeration enumeration = namespaces.elements();
                while (enumeration.hasMoreElements()) {
                    Attr attr = (Attr)enumeration.nextElement();
                    if (attr.getNodeName().equals("xmlns") && attr.getNodeValue().length() == 0) continue;
                    nodeList.add(attr);
                }
                NamedNodeMap map = node.getAttributes();
                for (int i = 0; i < map.getLength(); ++i) {
                    Node attr = map.item(i);
                    if (attr.getNodeName().equals("xmlns") || attr.getNodeName().startsWith("xmlns:")) continue;
                    nodeList.add(attr);
                }
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(nodeList, child, exceptedNode, withComments);
                }
                break;
            }
            case 5: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(nodeList, child, exceptedNode, withComments);
                }
                break;
            }
            case 8: {
                if (!withComments) break;
                nodeList.add(node);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                nodeList.add(node);
                break;
            }
            case 9: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(nodeList, child, exceptedNode, withComments);
                }
                break;
            }
            case 10: {
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid node type: " + node.getNodeType());
            }
        }
    }

    public static byte[] serializeSubset(NodeIterator iter, boolean withComments) {
        Node n;
        NodeListImpl list = new NodeListImpl();
        while ((n = iter.nextNode()) != null) {
            list.add(n);
        }
        return XPathCanonicalizer.serializeSubset(list, withComments);
    }

    public static void serializeSubset(NodeIterator iter, boolean withComments, Writer wr) throws IOException {
        Node n;
        NodeListImpl list = new NodeListImpl();
        while ((n = iter.nextNode()) != null) {
            list.add(n);
        }
        XPathCanonicalizer.serializeSubset(list, withComments, wr);
    }

    public static byte[] serializeSubset(NodeList nodeList, boolean withComments) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            XPathCanonicalizer.serializeSubset(nodeList, withComments, (Writer)wr);
            ((Writer)wr).close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    private static boolean inNodeList(Node node, NodeList list) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i) != node) continue;
            return true;
        }
        return false;
    }

    public static void serializeSubset(NodeList nodeList, boolean withComments, Writer wr) throws IOException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 2) {
                Node attr;
                nodeVector.addElement(node);
                if (node.getNodeType() != 1) continue;
                Hashtable<String, Node> attributes = null;
                if (!XPathCanonicalizer.inNodeList(node.getParentNode(), nodeList)) {
                    attributes = XPathCanonicalizer.collectXMLPrefixAttributesInAncestors(node);
                }
                if (i + 1 < nodeList.getLength() && (attr = nodeList.item(i + 1)).getNodeType() == 2 && ((Attr)attr).getOwnerElement() == node) {
                    if (attributes == null) {
                        attributes = new Hashtable<String, Node>();
                    }
                    ++i;
                    while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && node == ((Attr)node2).getOwnerElement()) {
                        attributes.put(node2.getNodeName(), node2);
                        ++i;
                    }
                    if (attributes.containsKey("xmlns") && ((Attr)attributes.get("xmlns")).getNodeValue().length() == 0) {
                        attributes.remove("xmlns");
                    }
                    --i;
                    nodeVector.addElement(new Attributes(node, attributes));
                    continue;
                }
                if (attributes == null) continue;
                nodeVector.addElement(new Attributes(node, attributes));
                continue;
            }
            Element owner = ((Attr)node).getOwnerElement();
            Hashtable<String, Node> attributes = new Hashtable<String, Node>();
            while (i < nodeList.getLength() && (node2 = nodeList.item(i)).getNodeType() == 2 && owner == ((Attr)node2).getOwnerElement()) {
                attributes.put(node2.getNodeName(), node2);
                ++i;
            }
            nodeVector.addElement(new Attributes(owner, attributes));
            --i;
        }
        Stack stack = new Stack();
        for (int i = 0; i < nodeVector.size(); ++i) {
            XPathCanonicalizer.serializeSubset(stack, nodeVector, i, withComments, wr);
        }
    }

    private static void serializeSubset(Stack stack, Vector nodeVector, int i, boolean withComments, Writer wr) throws IOException {
        Node parent;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof Attributes) {
            Attributes ancestorAttrs = stack.empty() ? null : (Attributes)stack.peek();
            ((Attributes)obj).serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, i);
            return;
        }
        Node node = (Node)obj;
        short type = node.getNodeType();
        if (type == 9) {
            return;
        }
        if (type != 1) {
            XPathCanonicalizer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        wr.write(node.getNodeName());
        Attributes ancestorAttrs = stack.empty() ? null : (Attributes)stack.peek();
        Attributes attrs = null;
        int next = i + 1;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof Node) {
            parent = node.getParentNode();
            if (parent.getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                wr.write(" xmlns=\"\"");
            }
        } else {
            attrs = (Attributes)nodeVector.elementAt(next);
            if (!attrs.contains("xmlns") && (parent = node.getParentNode()).getNodeType() != 9 && ancestorAttrs != null && ancestorAttrs.contains("xmlns")) {
                wr.write(" xmlns=\"\"");
            }
            attrs.serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        stack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!XPathCanonicalizer.isAncestor(nodeVector.elementAt(next), node)) break;
            XPathCanonicalizer.serializeSubset(stack, nodeVector, next, withComments, wr);
            nodeVector.setElementAt(null, next++);
        }
        stack.pop();
        wr.write("</");
        wr.write(node.getNodeName());
        wr.write(">");
    }

    static boolean isAncestor(Object me, Node anc) {
        Node parent = me instanceof Attributes ? ((Attributes)me).parent : (Node)me;
        while (parent != anc) {
            if ((parent = parent.getNodeType() == 2 ? ((Attr)parent).getOwnerElement() : parent.getParentNode()) != null) continue;
            return false;
        }
        return true;
    }

    static void serializeNode(Node topNode, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        XPathCanonicalizer.serializeNode(topNode, null, node, exceptedNode, withComments, xmlAttributes, wr);
    }

    private static void serializeNode(Node topNode, Stack stack, Node node, Node exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        if (exceptedNode == node) {
            return;
        }
        boolean lesser = false;
        boolean greater = false;
        switch (node.getNodeType()) {
            case 1: {
                if (stack == null) {
                    stack = new Stack();
                }
                wr.write("<");
                wr.write(node.getNodeName());
                XPathCanonicalizer.serializeAttributes(topNode, stack, (Element)node, xmlAttributes, wr);
                wr.write(">");
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    XPathCanonicalizer.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                stack.pop();
                wr.write("</");
                wr.write(node.getNodeName());
                wr.write(">");
                break;
            }
            case 3: 
            case 4: {
                C14nUtil.serializeText(node.getNodeValue(), wr);
                break;
            }
            case 5: 
            case 9: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    XPathCanonicalizer.serializeNode(topNode, stack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                break;
            }
            case 7: {
                C14nUtil.serializePI(node, wr);
                break;
            }
            case 8: {
                if (!withComments) break;
                C14nUtil.serializeComment(node, wr);
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                String an = node.getNodeName();
                C14nUtil.serializeAttribute(node, wr, an.equals("xmlns") || an.startsWith("xmlns:"));
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid Node Type: " + node.getNodeType());
            }
        }
    }

    private static boolean isTopElement(Node topNode, Element element) {
        if (topNode == element) {
            return true;
        }
        Node parent = element.getParentNode();
        if (parent != null) {
            switch (parent.getNodeType()) {
                case 9: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    parent = parent.getParentNode();
                }
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + parent.getNodeType());
        }
        return true;
    }

    private static void serializeAttributes(Node topNode, Stack stack, Element element, boolean xmlAttributes, Writer wr) throws IOException {
        Hashtable xmlattrs;
        Hashtable nsattrs = XPathCanonicalizer.collectNamespaceNodesInAncestors(element, false);
        NamedNodeMap nnm = element.getAttributes();
        int atlen = nnm.getLength();
        for (int i = 0; i < atlen; ++i) {
            nsattrs.put(nnm.item(i).getNodeName(), nnm.item(i));
        }
        if (xmlAttributes && (xmlattrs = XPathCanonicalizer.collectXMLPrefixAttributesInAncestors(element)) != null) {
            Enumeration enumeration = xmlattrs.elements();
            while (enumeration.hasMoreElements()) {
                Attr attr = (Attr)enumeration.nextElement();
                nsattrs.put(attr.getNodeName(), attr);
            }
        }
        Hashtable parentAttrs = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(nsattrs);
        atlen = nsattrs.size();
        String[] as = new String[atlen];
        int[] indexMap = new int[atlen];
        Attr[] attrs = new Attr[atlen];
        int i = 0;
        Enumeration en = nsattrs.elements();
        while (en.hasMoreElements()) {
            Attr attr = (Attr)en.nextElement();
            indexMap[i] = i;
            attrs[i] = attr;
            as[i] = XPathCanonicalizer.createSortedString(attr, element);
            ++i;
        }
        C14nUtil.heapSort(indexMap, as, atlen);
        for (int j = 0; j < atlen; ++j) {
            Attr xa;
            Attr a = attrs[indexMap[j]];
            String attrName = a.getNodeName();
            boolean checkURI = false;
            if (attrName.equals("xmlns:xml")) continue;
            if (attrName.equals("xmlns") && a.getNodeValue().length() == 0) {
                if (XPathCanonicalizer.isTopElement(topNode, element)) continue;
                boolean found = false;
                for (int depth = stack.size() - 1; depth >= 0; --depth) {
                    Hashtable attrs2 = (Hashtable)stack.elementAt(depth);
                    Attr attr = (Attr)attrs2.get("xmlns");
                    if (attr == null || attr.getNodeValue().length() <= 0) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                Attr nsa;
                checkURI = true;
                if (parentAttrs != null && (nsa = (Attr)parentAttrs.get(attrName)) != null && nsa.getNodeValue().equals(a.getNodeValue())) {
                    continue;
                }
            } else if (attrName.startsWith("xml:") && parentAttrs != null && (xa = (Attr)parentAttrs.get(attrName)) != null && xa.getNodeValue().equals(a.getNodeValue())) continue;
            C14nUtil.serializeAttribute(a, wr, checkURI);
        }
    }

    public static Hashtable collectNamespaceNodesInAncestors(Node startNode, boolean useProxy) {
        Node node = startNode;
        Hashtable<String, Attr> nsnodes = new Hashtable<String, Attr>();
        Document factory = startNode.getOwnerDocument();
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNode("xmlns:xml") == null) {
            if (useProxy) {
                nsnodes.put("xmlns:xml", new AttrProxy(startNode, factory, XMLNS_NS, "xmlns:xml", XML_NAMESPACE));
            } else {
                Attr xa = factory.createAttributeNS(XMLNS_NS, "xmlns:xml");
                xa.setNodeValue(XML_NAMESPACE);
                nsnodes.put("xmlns:xml", xa);
            }
        }
        do {
            NamedNodeMap attributeList;
            if ((attributeList = node.getAttributes()) == null) continue;
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr newAttr;
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:") || nsnodes.containsKey(attrName)) continue;
                if (node == startNode) {
                    nsnodes.put(attrName, attr);
                    continue;
                }
                if (useProxy) {
                    newAttr = new AttrProxy(startNode, factory, XMLNS_NS, attrName, attr.getNodeValue());
                    nsnodes.put(attrName, newAttr);
                    continue;
                }
                newAttr = factory.createAttributeNS(XMLNS_NS, attrName);
                newAttr.setNodeValue(attr.getNodeValue());
                nsnodes.put(attrName, newAttr);
            }
        } while ((node = node.getParentNode()) != null);
        return nsnodes;
    }

    public static void copyNamespaceNodesInAncestors(Element startNode) {
        Node node = startNode;
        while ((node = node.getParentNode()) != null) {
            NamedNodeMap attributeList = node.getAttributes();
            if (attributeList == null) continue;
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.equals("xmlns") && !attrName.startsWith("xmlns:") || startNode.hasAttribute(attrName)) continue;
                startNode.setAttributeNS(XMLNS_NS, attrName, attr.getNodeValue());
            }
        }
    }

    public static void copyNamespaceNodesInAncestorsRecursively(Node startNode) {
        if (startNode.getNodeType() == 1) {
            XPathCanonicalizer.copyNamespaceNodesInAncestors((Element)startNode);
        }
        for (Node child = startNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: 
                case 5: {
                    XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(child);
                }
            }
        }
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(Node startNode) {
        NamedNodeMap attributeList;
        Hashtable<String, Attr> attrs = null;
        for (Node node = startNode.getParentNode(); node != null; node = node.getParentNode()) {
            NamedNodeMap attributeList2 = node.getAttributes();
            if (attributeList2 == null) continue;
            int nAttrs = attributeList2.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList2.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || attrs != null && attrs.containsKey(attrName)) continue;
                if (attrs == null) {
                    attrs = new Hashtable<String, Attr>();
                }
                attrs.put(attrName, attr);
            }
        }
        if (attrs != null && (attributeList = startNode.getAttributes()) != null) {
            int nAttrs = attributeList.getLength();
            for (int j = 0; j < nAttrs; ++j) {
                Attr attr = (Attr)attributeList.item(j);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:") || !attrs.containsKey(attrName)) continue;
                attrs.remove(attrName);
            }
        }
        return attrs;
    }

    private static String createSortedString(Attr node, Node element) {
        String ret;
        if (node.getNodeType() == 2) {
            String name = node.getNodeName();
            if (name.equals("xmlns")) {
                return "\u0000";
            }
            int index = name.indexOf(58);
            if (index <= 0) {
                return "\u0001" + name;
            }
            String prefix = name.substring(0, index).intern();
            if (prefix.equals("xmlns")) {
                return "\u0000" + name.substring(index + 1);
            }
            String uri = DOMUtil.getNamespaceForPrefix(prefix, element);
            ret = uri == null || uri.length() == 0 ? "\u0001" + name : uri + "\u0001" + name.substring(index + 1);
        } else {
            throw new IllegalArgumentException("Requires an Attr node.");
        }
        return ret;
    }

    public static class NodeListImpl
    implements NodeList {
        Vector vector = null;

        public NodeListImpl() {
        }

        public NodeListImpl(int size) {
            this.vector = new Vector(size);
        }

        public void add(Node node) {
            if (this.vector == null) {
                this.vector = new Vector();
            }
            this.vector.addElement(node);
        }

        public Node item(int index) {
            return this.vector == null || index < 0 || this.vector.size() <= index ? null : (Node)this.vector.elementAt(index);
        }

        public int getLength() {
            return this.vector == null ? 0 : this.vector.size();
        }
    }

    private static class AttrProxy
    implements Attr {
        Attr real;
        Element owner;

        AttrProxy(Node owner, Document factory, String ns, String qname, String value) {
            this.real = factory.createAttributeNS(ns, qname);
            this.real.setValue(value);
            this.owner = (Element)owner;
        }

        public Element getOwnerElement() {
            return this.owner;
        }

        public String getName() {
            return this.real.getName();
        }

        public boolean getSpecified() {
            return false;
        }

        public String getValue() {
            return this.real.getValue();
        }

        public void setValue(String value) {
            this.real.setValue(value);
        }

        public Node appendChild(Node newChild) {
            return this.real.appendChild(newChild);
        }

        public Node cloneNode(boolean deep) {
            return this.real.cloneNode(deep);
        }

        public NamedNodeMap getAttributes() {
            return this.real.getAttributes();
        }

        public NodeList getChildNodes() {
            return this.real.getChildNodes();
        }

        public Node getFirstChild() {
            return this.real.getFirstChild();
        }

        public Node getLastChild() {
            return this.real.getLastChild();
        }

        public String getLocalName() {
            return this.real.getLocalName();
        }

        public String getNamespaceURI() {
            return this.real.getNamespaceURI();
        }

        public Node getNextSibling() {
            return this.real.getNextSibling();
        }

        public String getNodeName() {
            return this.real.getNodeName();
        }

        public short getNodeType() {
            return this.real.getNodeType();
        }

        public String getNodeValue() {
            return this.real.getNodeValue();
        }

        public Document getOwnerDocument() {
            return this.real.getOwnerDocument();
        }

        public Node getParentNode() {
            return this.real.getParentNode();
        }

        public String getPrefix() {
            return this.real.getPrefix();
        }

        public Node getPreviousSibling() {
            return this.real.getPreviousSibling();
        }

        public boolean hasAttributes() {
            return false;
        }

        public boolean hasChildNodes() {
            return this.real.hasChildNodes();
        }

        public Node insertBefore(Node newChild, Node refChild) {
            return this.real.insertBefore(newChild, refChild);
        }

        public void normalize() {
            this.real.normalize();
        }

        public Node removeChild(Node oldChild) {
            return this.real.removeChild(oldChild);
        }

        public Node replaceChild(Node newChild, Node oldChild) {
            return this.real.replaceChild(newChild, oldChild);
        }

        public void setNodeValue(String nodeValue) {
            this.real.setNodeValue(nodeValue);
        }

        public void setPrefix(String prefix) {
            this.real.setPrefix(prefix);
        }

        public boolean isSupported(String feature, String version) {
            return this.real.isSupported(feature, version);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Attributes {
        Node parent;
        Hashtable attributes;
        Hashtable rendered;

        Attributes(Node node, Hashtable attrs) {
            this.parent = node;
            this.attributes = attrs;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
            this.rendered = null;
        }

        boolean contains(String attrname) {
            return this.attributes.containsKey(attrname);
        }

        private boolean rendered(String attrname) {
            if (this.rendered == null) {
                return false;
            }
            return this.rendered.containsKey(attrname);
        }

        private void setRendered(String attrname, Attr a) {
            if (this.rendered == null) {
                this.rendered = new Hashtable();
            }
            this.rendered.put(attrname, a);
        }

        void serialize(Attributes parent, Writer wr) throws IOException {
            Attr attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            Attr[] attrArray = new Attr[attrLength];
            Enumeration enumeration = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (Attr)enumeration.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = XPathCanonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(indexMap, as, attrLength);
            for (j = 0; j < attrLength; ++j) {
                attr = attrArray[indexMap[j]];
                String attrName = attr.getNodeName();
                boolean checkURI = false;
                if (attrName.equals("xmlns:xml")) continue;
                if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                    checkURI = true;
                    if (parent != null && parent.contains(attrName) && parent.get(attrName).getNodeValue().equals(attr.getNodeValue())) {
                        continue;
                    }
                } else if (attrName.startsWith("xml:")) {
                    // empty if block
                }
                C14nUtil.serializeAttribute(attr, wr, checkURI);
            }
        }

        Enumeration enum() {
            return this.attributes.elements();
        }

        Attr get(String name) {
            return (Attr)this.attributes.get(name);
        }

        private void remove(String name) {
            Object attr = this.attributes.remove(name);
            if (attr == null) {
                System.err.println("Internal logic error: No attribute named " + name);
            }
        }

        private boolean usePrefix(String prefix) {
            if (prefix.length() == 0) {
                return false;
            }
            Enumeration en = this.enum();
            while (en.hasMoreElements()) {
                Attr attr = (Attr)en.nextElement();
                String p = attr.getPrefix();
                if (p == null || !p.equals(prefix)) continue;
                return true;
            }
            return false;
        }

        private static boolean renderedInAncestors(Stack ancestors, String name, String ns) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                Attributes attrs = (Attributes)ancestors.elementAt(i);
                if (!attrs.rendered(name) || !attrs.get(name).getNodeValue().equals(ns)) continue;
                return true;
            }
            return false;
        }

        private boolean utilizedInNearest(Stack ancestors, Attr attr) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            String prefix = attr.getName().equals("xmlns") ? "" : attr.getLocalName();
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                Attributes attrs = (Attributes)ancestors.elementAt(i);
                if (attrs.parent == null) continue;
                String eprefix = attrs.parent.getPrefix();
                if (eprefix == null) {
                    eprefix = "";
                }
                if (!prefix.equals(eprefix) && !attrs.usePrefix(prefix)) continue;
                return attrs.contains(attr.getNodeName()) && attrs.get(attr.getNodeName()).getNodeValue().equals(attr.getNodeValue());
            }
            return false;
        }

        void serialize(Stack ancestors, Hashtable prefixList, String elprefix, Writer wr) throws IOException {
            Attr attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            Attr[] attrArray = new Attr[attrLength];
            Enumeration enumeration = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (Attr)enumeration.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = XPathCanonicalizer.createSortedString(attr, this.parent);
            }
            C14nUtil.heapSort(indexMap, as, attrLength);
            for (j = 0; j < attrLength; ++j) {
                attr = attrArray[indexMap[j]];
                String attrName = attr.getNodeName();
                boolean checkURI = false;
                if (attrName.equals("xmlns:xml")) continue;
                if (attrName.equals("xmlns") || attrName.startsWith("xmlns:")) {
                    String prefix = attrName.equals("xmlns") ? "" : attrName.substring(6);
                    checkURI = true;
                    if (prefixList != null && prefixList.get(prefix) != null) {
                        Attributes par = null;
                        if (ancestors != null && !ancestors.isEmpty()) {
                            par = (Attributes)ancestors.elementAt(ancestors.size() - 1);
                        }
                        if (par != null && par.contains(attrName) && par.get(attrName).getNodeValue().equals(attr.getNodeValue())) {
                            continue;
                        }
                    } else {
                        if (elprefix == null) continue;
                        if (Attributes.renderedInAncestors(ancestors, attrName, attr.getNodeValue()) && this.utilizedInNearest(ancestors, attr) || elprefix != null && !elprefix.equals(prefix) && !this.usePrefix(prefix)) continue;
                    }
                    this.setRendered(attrName, attr);
                }
                C14nUtil.serializeAttribute(attr, wr, checkURI);
            }
        }

        public String toString() {
            return "Attributes[#=" + this.attributes.size() + "]";
        }
    }
}

