/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.Visitor;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class TreeTraversal {
    Visitor visitor;

    public TreeTraversal(Visitor visitor) {
        this.visitor = visitor;
    }

    public void traverse(Node startNode) throws Exception {
        block20: {
            Node tempNode1 = startNode;
            Node tempNode2 = null;
            try {
                while (tempNode1 != null) {
                    try {
                        this.visitPre(tempNode1);
                        tempNode2 = tempNode1.getFirstChild();
                    }
                    catch (ToNextSiblingTraversalException exception) {
                        tempNode2 = null;
                    }
                    if (tempNode2 == null) {
                        if (tempNode1 == startNode) {
                            try {
                                this.visitPost(tempNode1);
                            }
                            catch (ToNextSiblingTraversalException exception) {}
                            break;
                        }
                        tempNode2 = tempNode1.getNextSibling();
                        if (tempNode2 != null) {
                            try {
                                this.visitPost(tempNode1);
                            }
                            catch (ToNextSiblingTraversalException exception) {}
                        }
                    }
                    while (tempNode2 == null && tempNode1 != null) {
                        tempNode2 = tempNode1.getParentNode();
                        try {
                            this.visitPost(tempNode1);
                        }
                        catch (ToNextSiblingTraversalException exception) {
                            // empty catch block
                        }
                        if ((tempNode1 = tempNode2) == null) continue;
                        if (tempNode1 != startNode) {
                            tempNode2 = tempNode1.getNextSibling();
                            if (tempNode2 == null) continue;
                            try {
                                this.visitPost(tempNode1);
                            }
                            catch (ToNextSiblingTraversalException exception) {}
                            continue;
                        }
                        try {
                            this.visitPost(tempNode1);
                        }
                        catch (ToNextSiblingTraversalException exception) {}
                        break block20;
                    }
                    tempNode1 = tempNode2;
                }
            }
            catch (EndTraversalException exception) {
                // empty catch block
            }
        }
    }

    private void visitPre(Node node) throws Exception {
        switch (node.getNodeType()) {
            case 1: {
                this.visitor.visitElementPre((Element)node);
                break;
            }
            case 2: {
                this.visitor.visitAttributePre((Attr)node);
                break;
            }
            case 3: {
                this.visitor.visitTextPre((Text)node);
                break;
            }
            case 4: {
                this.visitor.visitCDATASectionPre((CDATASection)node);
                break;
            }
            case 5: {
                this.visitor.visitEntityReferencePre((EntityReference)node);
                break;
            }
            case 6: {
                this.visitor.visitEntityPre((Entity)node);
                break;
            }
            case 7: {
                this.visitor.visitProcessingInstructionPre((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.visitor.visitCommentPre((Comment)node);
                break;
            }
            case 9: {
                this.visitor.visitDocumentPre((Document)node);
                break;
            }
            case 10: {
                this.visitor.visitDocumentTypePre((DocumentType)node);
                throw new ToNextSiblingTraversalException();
            }
            case 11: {
                this.visitor.visitDocumentFragmentPre((DocumentFragment)node);
                break;
            }
            case 12: {
                this.visitor.visitNotationPre((Notation)node);
                break;
            }
            default: {
                this.visitor.visitUnknownPre(node);
            }
        }
    }

    private void visitPost(Node node) throws Exception {
        switch (node.getNodeType()) {
            case 1: {
                this.visitor.visitElementPost((Element)node);
                break;
            }
            case 2: {
                this.visitor.visitAttributePost((Attr)node);
                break;
            }
            case 3: {
                this.visitor.visitTextPost((Text)node);
                break;
            }
            case 4: {
                this.visitor.visitCDATASectionPost((CDATASection)node);
                break;
            }
            case 5: {
                this.visitor.visitEntityReferencePost((EntityReference)node);
                break;
            }
            case 6: {
                this.visitor.visitEntityPost((Entity)node);
                break;
            }
            case 7: {
                this.visitor.visitProcessingInstructionPost((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.visitor.visitCommentPost((Comment)node);
                break;
            }
            case 9: {
                this.visitor.visitDocumentPost((Document)node);
                break;
            }
            case 10: {
                this.visitor.visitDocumentTypePost((DocumentType)node);
                break;
            }
            case 11: {
                this.visitor.visitDocumentFragmentPost((DocumentFragment)node);
                break;
            }
            case 12: {
                this.visitor.visitNotationPost((Notation)node);
                break;
            }
            default: {
                this.visitor.visitUnknownPost(node);
            }
        }
    }

    public static class EndTraversalException
    extends Exception {
        public EndTraversalException() {
        }

        public EndTraversalException(String msg) {
            super(msg);
        }
    }

    public static class ToNextSiblingTraversalException
    extends Exception {
        public ToNextSiblingTraversalException() {
        }

        public ToNextSiblingTraversalException(String msg) {
            super(msg);
        }
    }
}

