/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.C14nUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Serializer {
    private static final int ATTR_TAB_SIZE = 64;
    private static final String[] attrTab = new String[]{null, null, null, null, null, null, null, null, null, "&#x9;", "&#xA;", null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, null, null};

    static final void serializeAttribute(Node attr, Writer wr) throws IOException {
        Serializer.serializeAttribute(attr.getNodeName(), attr.getNodeValue(), wr);
    }

    static final void serializeAttribute(String name, String value, Writer wr) throws IOException {
        int len = value.length();
        int start = -1;
        boolean hasColon = false;
        wr.write(" ");
        wr.write(name);
        wr.write("=\"");
        for (int j = 0; j < len; ++j) {
            String escaped;
            char ch = value.charAt(j);
            String string = escaped = ch < '@' ? attrTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(value, start, j - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start >= 0) continue;
            start = j;
        }
        if (start >= 0) {
            wr.write(value, start, len - start);
        }
        wr.write("\"");
    }

    public static void serializeNode(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                String nodeName = node.getNodeName();
                writer.write("<");
                writer.write(nodeName);
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    int numAttrs = attrs.getLength();
                    for (int i = 0; i < numAttrs; ++i) {
                        Serializer.serializeAttribute(attrs.item(i), writer);
                    }
                }
                writer.write(">");
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    Serializer.serializeNode(child, writer);
                }
                writer.write("</");
                writer.write(nodeName);
                writer.write(">");
                break;
            }
            case 5: 
            case 9: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    Serializer.serializeNode(child, writer);
                }
                break;
            }
            case 3: 
            case 4: {
                C14nUtil.serializeText(node.getNodeValue(), writer);
                break;
            }
            case 8: {
                C14nUtil.serializeComment(node, writer);
                break;
            }
            case 2: {
                Serializer.serializeAttribute(node, writer);
                break;
            }
        }
    }

    public static byte[] serialize(Document doc) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        Serializer.serializeNode(doc, writer);
        ((Writer)writer).close();
        return out.toByteArray();
    }

    public static void serialize(Document doc, Writer writer) throws IOException {
        Serializer.serializeNode(doc, writer);
    }
}

