/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Normalizer {
    public static Node normalize(Node node) {
        Node last = null;
        Node current = node.getFirstChild();
        block5: while (current != null) {
            short type = current.getNodeType();
            switch (type) {
                case 1: {
                    Normalizer.normalize(current);
                    last = current;
                    current = current.getNextSibling();
                    continue block5;
                }
                case 5: {
                    Node child;
                    Node next = current.getNextSibling();
                    node.removeChild(current);
                    while ((child = current.getFirstChild()) != null) {
                        node.insertBefore(child, next);
                    }
                    current = last == null ? node.getFirstChild() : last.getNextSibling();
                    continue block5;
                }
                case 3: 
                case 4: {
                    Node next;
                    Text text = (Text)current;
                    if (text.getLength() == 0) {
                        next = current.getNextSibling();
                        node.removeChild(current);
                        current = next;
                        continue block5;
                    }
                    if (last != null && last.getNodeType() == 3) {
                        ((Text)last).appendData(text.getData());
                        next = current.getNextSibling();
                        node.removeChild(current);
                        current = next;
                        continue block5;
                    }
                    if (type == 4) {
                        Document factory = node.getOwnerDocument();
                        if (factory == null) {
                            factory = (Document)node;
                        }
                        last = factory.createTextNode(text.getData());
                        node.replaceChild(last, current);
                        current = last.getNextSibling();
                        continue block5;
                    }
                    last = current;
                    current = current.getNextSibling();
                    continue block5;
                }
            }
            last = current;
            current = current.getNextSibling();
        }
        return node;
    }
}

