/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import com.ibm.dom.util.C14nUtil;
import com.ibm.dom.util.DOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Digest {
    static final String tab = "0123456789ABCDEF";

    private Digest() {
    }

    public static byte[] getDigest(MessageDigest md, Node node) {
        if (node == null) {
            throw new IllegalArgumentException("The parameter is null.");
        }
        md.reset();
        byte[] result = null;
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                Node child;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                Digest.writeInt(os, type);
                int effectiveLen = 0;
                for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() == 1) {
                        ++effectiveLen;
                        continue;
                    }
                    if (child.getNodeType() != 7 || child.getNodeName().equals("xml")) continue;
                    ++effectiveLen;
                }
                Digest.writeInt(os, effectiveLen);
                try {
                    for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() == 1) {
                            os.write(Digest.getDigest(md, child));
                            continue;
                        }
                        if (child.getNodeType() != 7 || child.getNodeName().equals("xml")) continue;
                        os.write(Digest.getDigest(md, child));
                    }
                }
                catch (IOException ioe) {
                    System.err.print("Internal Error.");
                    ioe.printStackTrace();
                }
                md.reset();
                md.update(os.toByteArray());
                result = md.digest();
                break;
            }
            case 1: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Digest.writeInt(baos, 1);
                String str = Digest.createExpandedName(node, node);
                for (int i = 0; i < str.length(); ++i) {
                    char ch = str.charAt(i);
                    baos.write(ch >> 8);
                    baos.write(ch & 0xFF);
                }
                baos.write(0);
                baos.write(0);
                NamedNodeMap nnm = node.getAttributes();
                int atlen = nnm.getLength();
                if (atlen == 0) {
                    Digest.writeInt(baos, 0);
                } else {
                    int i;
                    int lenWithoutXmlns = 0;
                    Hashtable<String, String> hash = new Hashtable<String, String>(atlen);
                    String[] as = new String[atlen];
                    for (i = 0; i < atlen; ++i) {
                        Node attr = nnm.item(i);
                        String qname = attr.getNodeName();
                        if (qname.equals("xmlns") || qname.startsWith("xmlns:")) continue;
                        String expandedName = Digest.createExpandedName(attr, node);
                        hash.put(expandedName, qname);
                        as[lenWithoutXmlns++] = expandedName;
                    }
                    Digest.writeInt(baos, lenWithoutXmlns);
                    Digest.heapSort(as, lenWithoutXmlns);
                    try {
                        for (i = 0; i < lenWithoutXmlns; ++i) {
                            Attr a = ((Element)node).getAttributeNode((String)hash.get(as[i]));
                            baos.write(Digest.getDigest(md, a, (Element)node));
                        }
                    }
                    catch (IOException ioe) {
                        System.err.print("Internal Error.");
                        ioe.printStackTrace();
                    }
                }
                Vector<byte[]> v = new Vector<byte[]>();
                StringBuffer sb = new StringBuffer();
                Node n = DOMUtil.getFirstChild2(node);
                while (n != null) {
                    byte[] digest0 = null;
                    if (n instanceof Text) {
                        Node m;
                        sb.append(n.getNodeValue());
                        while ((m = DOMUtil.getNextSibling2(n)) != null && (m instanceof Text || m.getNodeType() == 8)) {
                            n = m;
                            if (m.getNodeType() == 8) continue;
                            sb.append(n.getNodeValue());
                        }
                        if (0 < sb.length()) {
                            digest0 = Digest.getTextDigest(md, sb);
                            sb.setLength(0);
                        }
                    } else if (n.getNodeType() != 8) {
                        digest0 = Digest.getDigest(md, n);
                    }
                    if (digest0 != null) {
                        v.addElement(digest0);
                    }
                    n = DOMUtil.getNextSibling2(n);
                }
                Digest.writeInt(baos, v.size());
                try {
                    for (int i = 0; i < v.size(); ++i) {
                        baos.write((byte[])v.elementAt(i));
                    }
                    baos.close();
                }
                catch (IOException io) {
                    // empty catch block
                }
                md.reset();
                md.update(baos.toByteArray());
                result = md.digest();
                break;
            }
            case 7: {
                Digest.digestInt(md, type);
                Digest.digestString(md, node.getNodeName());
                md.update((byte)0);
                md.update((byte)0);
                Digest.digestString(md, node.getNodeValue());
                result = md.digest();
                break;
            }
            case 3: 
            case 4: {
                Digest.digestInt(md, 3);
                Digest.digestString(md, node.getNodeValue());
                result = md.digest();
            }
        }
        return result;
    }

    public static byte[] getDigest(MessageDigest md, Attr attr, Element owner) {
        String qname = attr.getNodeName();
        if (qname.equals("xmlns") || qname.startsWith("xmlns:")) {
            return null;
        }
        md.reset();
        Digest.digestInt(md, 2);
        Digest.digestString(md, Digest.createExpandedName(attr, owner));
        md.update((byte)0);
        md.update((byte)0);
        Digest.digestString(md, attr.getValue());
        return md.digest();
    }

    private static byte[] getTextDigest(MessageDigest md, String str) {
        md.reset();
        Digest.digestInt(md, 3);
        Digest.digestString(md, str);
        return md.digest();
    }

    private static byte[] getTextDigest(MessageDigest md, StringBuffer str) {
        md.reset();
        Digest.digestInt(md, 3);
        Digest.digestString(md, str);
        return md.digest();
    }

    private static void writeInt(ByteArrayOutputStream baos, int i) {
        baos.write(i >> 24 & 0xFF);
        baos.write(i >> 16 & 0xFF);
        baos.write(i >> 8 & 0xFF);
        baos.write(i & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    public static String createExpandedName(Node node, Node element) {
        void var2_8;
        String ret;
        if (node.getNodeType() == 1) {
            String name = node.getNodeName();
            int index = name.indexOf(58);
            String prefix = index <= 0 ? "" : name.substring(0, index);
            String uri = DOMUtil.getNamespaceForPrefix(prefix, element);
            ret = uri == null || uri.length() == 0 ? name : uri + ":" + name.substring(index + 1);
        } else if (node.getNodeType() == 2) {
            String name = node.getNodeName();
            int index = name.indexOf(58);
            ret = index <= 0 ? name : DOMUtil.getNamespaceForPrefix(name.substring(0, index), element) + ":" + name.substring(index + 1);
        } else {
            throw new IllegalArgumentException("Requires Element or Attr node.");
        }
        return var2_8;
    }

    private static void digestInt(MessageDigest md, int i) {
        md.update((byte)(i >> 24 & 0xFF));
        md.update((byte)(i >> 16 & 0xFF));
        md.update((byte)(i >> 8 & 0xFF));
        md.update((byte)(i & 0xFF));
    }

    private static void digestString(MessageDigest md, String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            md.update((byte)(ch >> 8));
            md.update((byte)(ch & 0xFF));
        }
    }

    private static void digestString(MessageDigest md, StringBuffer str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            md.update((byte)(ch >> 8));
            md.update((byte)(ch & 0xFF));
        }
    }

    private static void heapSort(String[] pd, int length) {
        int i;
        for (i = length / 2; i >= 0; --i) {
            Digest.fall(pd, length, i);
        }
        for (i = length - 1; i > 0; --i) {
            String t = pd[0];
            pd[0] = pd[i];
            pd[i] = t;
            Digest.fall(pd, i, 0);
        }
    }

    private static void fall(String[] pd, int n, int i) {
        int j = 2 * i + 1;
        if (j < n) {
            if (j + 1 < n && 0 > C14nUtil.compareInUCS(pd[j], pd[j + 1])) {
                j = 2 * i + 2;
            }
            if (0 > C14nUtil.compareInUCS(pd[i], pd[j])) {
                String t = pd[i];
                pd[i] = pd[j];
                pd[j] = t;
                Digest.fall(pd, n, j);
            }
        }
    }

    public static void printByteArray(byte[] ab) throws IOException {
        if (null == ab) {
            System.err.print("NULL");
        } else {
            for (int i = 0; i < ab.length; ++i) {
                System.err.print(tab.charAt(ab[i] >> 4 & 0xF));
                System.err.print(tab.charAt(ab[i] & 0xF));
            }
        }
        System.err.print("\n");
    }

    public static void printByteArray(Writer wr, byte[] ab) throws IOException {
        if (null == ab) {
            wr.write("NULL");
        } else {
            for (int i = 0; i < ab.length; ++i) {
                Digest.printByte(wr, ab[i]);
            }
        }
        wr.write("\n");
    }

    private static void printByte(Writer wr, byte b) throws IOException {
        wr.write(tab.charAt(b >> 4 & 0xF));
        wr.write(tab.charAt(b & 0xF));
    }
}

