/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dom.util;

import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public final class C14nUtil {
    private static final int TEXT_TAB_SIZE = 64;
    private static final String[] textTab = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};
    private static final int ATTR_TAB_SIZE = 64;
    private static final String[] attrTab = new String[]{null, null, null, null, null, null, null, null, null, "&#x9;", "&#xA;", null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, null, null};
    private static final int[] fixTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, -2048, -2048, -2048, -2048};

    static final void serializeText(String text, Writer wr) throws IOException {
        int len = text.length();
        int start = -1;
        for (int i = 0; i < len; ++i) {
            String escaped;
            char ch = text.charAt(i);
            String string = escaped = ch < '@' ? textTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(text, start, i - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            wr.write(text, start, len - start);
        }
    }

    static final void serializePI(Node node, Writer wr) throws IOException {
        boolean lesser = false;
        boolean greater = false;
        if (node.getParentNode().getNodeType() == 9) {
            Node prev = node;
            while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
            }
            if (prev == null) {
                lesser = true;
            } else {
                greater = true;
            }
        }
        ProcessingInstruction pi = (ProcessingInstruction)node;
        if (greater) {
            wr.write("\n");
        }
        wr.write("<?");
        wr.write(pi.getTarget());
        if (pi.getData() != null && pi.getData().length() > 0) {
            wr.write(" ");
            String data = pi.getData();
            int start = 0;
            for (int index = 0; index < data.length(); ++index) {
                if (data.charAt(index) != '\r') continue;
                if (index > start) {
                    wr.write(data, start, index - start);
                }
                wr.write("&#xD;");
                start = index + 1;
            }
            if (start < data.length()) {
                wr.write(data, start, data.length() - start);
            }
        }
        wr.write("?>");
        if (lesser) {
            wr.write("\n");
        }
    }

    static final void serializeComment(Node node, Writer wr) throws IOException {
        boolean lesser = false;
        boolean greater = false;
        if (node.getParentNode().getNodeType() == 9) {
            Node prev = node;
            while ((prev = prev.getPreviousSibling()) != null && prev.getNodeType() != 1) {
            }
            if (prev == null) {
                lesser = true;
            } else {
                greater = true;
            }
        }
        if (greater) {
            wr.write("\n");
        }
        wr.write("<!--");
        wr.write(node.getNodeValue());
        wr.write("-->");
        if (lesser) {
            wr.write("\n");
        }
    }

    static final void serializeAttribute(Node attr, Writer wr, boolean checkURI) throws IOException {
        C14nUtil.serializeAttribute(attr.getNodeName(), attr.getNodeValue(), wr, checkURI);
    }

    static final void serializeAttribute(String name, String value, Writer wr, boolean checkURI) throws IOException {
        int len = value.length();
        int start = -1;
        boolean hasColon = false;
        wr.write(" ");
        wr.write(name);
        wr.write("=\"");
        for (int j = 0; j < len; ++j) {
            String escaped;
            char ch = value.charAt(j);
            String string = escaped = ch < '@' ? attrTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(value, start, j - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start < 0) {
                start = j;
            }
            if (!checkURI) continue;
            if (ch == ':') {
                hasColon = true;
                continue;
            }
            if (ch != '/' || hasColon) continue;
            throw new RuntimeException("Found a relative URI: " + name + "='" + value + "'");
        }
        if (start >= 0) {
            wr.write(value, start, len - start);
        }
        if (value.length() > 0 && checkURI && !hasColon) {
            throw new RuntimeException("Found a relative URI: " + name + "='" + value + "'");
        }
        wr.write("\"");
    }

    public static void heapSort(int[] indexMap, String[] pd, int length) {
        int i;
        for (i = length / 2; i >= 0; --i) {
            C14nUtil.fall(indexMap, pd, length, i);
        }
        for (i = length - 1; i > 0; --i) {
            int t = indexMap[0];
            indexMap[0] = indexMap[i];
            indexMap[i] = t;
            C14nUtil.fall(indexMap, pd, i, 0);
        }
    }

    private static void fall(int[] indexMap, String[] pd, int n, int i) {
        int j = 2 * i + 1;
        if (j < n) {
            if (j + 1 < n && 0 > pd[indexMap[j]].compareTo(pd[indexMap[j + 1]])) {
                j = 2 * i + 2;
            }
            if (0 > C14nUtil.compareInUCS(pd[indexMap[i]], pd[indexMap[j]])) {
                int t = indexMap[i];
                indexMap[i] = indexMap[j];
                indexMap[j] = t;
                C14nUtil.fall(indexMap, pd, n, j);
            }
        }
    }

    public static final int lengthInUCS(String str) {
        int length = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ('\ud800' <= ch && ch < '\udc00') {
                ++i;
            }
            ++length;
        }
        return length;
    }

    public static final int compareInUCS(String s1, String s2) {
        int len2;
        int len1 = s1.length();
        int minlen = len1 < (len2 = s2.length()) ? len1 : len2;
        int i1 = 0;
        int i2 = 0;
        while (minlen-- != 0) {
            int c1 = s1.charAt(i1++);
            c1 += fixTable[c1 >> 11];
            int c2 = s2.charAt(i2++);
            if (c1 == (c2 += fixTable[c2 >> 11])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }
}

