/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.util;

import java.util.ArrayList;
import java.util.Iterator;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.extensions.AttributeExtensible;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.Constants;

public class AddressingUtils {
    public static void removeHeader(SOAPHeader soapHeader, String actorURI, String headerName) {
        if (soapHeader == null) {
            return;
        }
        Iterator headers = soapHeader.examineHeaderElements(actorURI);
        ArrayList<SOAPHeaderElement> existingElements = new ArrayList<SOAPHeaderElement>();
        while (headers.hasNext()) {
            SOAPHeaderElement hElement = (SOAPHeaderElement)headers.next();
            Name hName = hElement.getElementName();
            if (!AddressingUtils.isAddressingNamespaceURI(hName.getURI()) || !hName.getLocalName().equals(headerName)) continue;
            existingElements.add(hElement);
        }
        for (int i = 0; i < existingElements.size(); ++i) {
            SOAPHeaderElement el = (SOAPHeaderElement)existingElements.get(i);
            el.detachNode();
        }
    }

    public static boolean isAddressingNamespaceURI(String nsURI) {
        return Constants.ADDRESSING_NS_URI_SET.contains(nsURI);
    }

    public static void removeHeaders(SOAPHeader soapHeader, String actorURI) {
        if (soapHeader == null) {
            return;
        }
        Iterator headers = soapHeader.examineHeaderElements(actorURI);
        ArrayList<SOAPHeaderElement> existingElements = new ArrayList<SOAPHeaderElement>();
        while (headers.hasNext()) {
            SOAPHeaderElement hElement = (SOAPHeaderElement)headers.next();
            Name hName = hElement.getElementName();
            if (!AddressingUtils.isAddressingNamespaceURI(hName.getURI())) continue;
            existingElements.add(hElement);
        }
        for (int i = 0; i < existingElements.size(); ++i) {
            SOAPHeaderElement el = (SOAPHeaderElement)existingElements.get(i);
            el.detachNode();
        }
    }

    public static AddressingHeaders getResponseHeaders(MessageContext msgCtx) {
        return AddressingUtils.getHeaders(msgCtx, "org.apache.axis.message.addressing.RESPONSE.HEADERS");
    }

    public static AddressingHeaders getRequestHeaders(MessageContext msgCtx) {
        return AddressingUtils.getHeaders(msgCtx, "org.apache.axis.message.addressing.REQUEST.HEADERS");
    }

    private static AddressingHeaders getHeaders(MessageContext msgCtx, String type) {
        AddressingHeaders headers = (AddressingHeaders)msgCtx.getProperty(type);
        if (headers == null) {
            headers = new AddressingHeaders();
            msgCtx.setProperty(type, (Object)headers);
        }
        return headers;
    }

    public static String getInputAction(QName portTypeQName, Operation operation) {
        if (portTypeQName == null || operation == null) {
            throw new IllegalArgumentException("Null parameters are not allowed.");
        }
        Input input = operation.getInput();
        if (input == null) {
            return null;
        }
        return AddressingUtils.getAction((AttributeExtensible)input, input.getName(), portTypeQName, operation, "Request");
    }

    public static String getOutputAction(QName portTypeQName, Operation operation) {
        if (portTypeQName == null || operation == null) {
            throw new IllegalArgumentException("Null parameters are not allowed.");
        }
        Output output = operation.getOutput();
        if (output == null) {
            return null;
        }
        return AddressingUtils.getAction((AttributeExtensible)output, output.getName(), portTypeQName, operation, "Response");
    }

    private static String getAction(AttributeExtensible inputOutput, String inputOutputName, QName portTypeQName, Operation operation, String defaultName) {
        Object value = inputOutput.getExtensionAttribute(Constants.QNAME_ACTION);
        if (value != null) {
            if (value instanceof QName) {
                return ((QName)value).getLocalPart();
            }
            return value.toString();
        }
        String name = inputOutputName;
        if (name == null) {
            name = operation.getName() + defaultName;
        }
        StringBuffer buf = new StringBuffer(50);
        buf.append(portTypeQName.getNamespaceURI());
        if (!portTypeQName.getNamespaceURI().endsWith("/")) {
            buf.append("/");
        }
        buf.append(portTypeQName.getLocalPart()).append("/").append(name);
        return buf.toString();
    }

    public static String getNamespacePrefix(SOAPElement element, String namespace) throws SOAPException {
        if (element == null || namespace == null) {
            throw new IllegalArgumentException("Null parameters are not allowed.");
        }
        Iterator iter = element.getVisibleNamespacePrefixes();
        String prefix = null;
        String ns = null;
        while (iter.hasNext()) {
            prefix = (String)iter.next();
            ns = element.getNamespaceURI(prefix);
            if (!namespace.equals(ns)) continue;
            return prefix;
        }
        int i = 0;
        prefix = "ns" + i;
        while (element.getNamespaceURI(prefix) != null) {
            prefix = "ns" + i++;
        }
        element.addNamespaceDeclaration(prefix, namespace);
        return prefix;
    }
}

