/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Arrays;
import org.systinet.security.perm.WSInvokePermissionCollection;

public final class WSInvokePermission
extends Permission {
    private String[] methods;
    private String actions;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" name='");
        sb.append(this.getName());
        sb.append("' action='");
        if (this.methods == null) {
            sb.append("<all>");
        } else {
            int i = 0;
            while (i < this.methods.length - 1) {
                sb.append(this.methods[i]);
                sb.append(',');
                ++i;
            }
            sb.append(this.methods[this.methods.length - 1]);
        }
        sb.append('\'');
        return sb.toString();
    }

    public String[] getMethods() {
        return this.methods;
    }

    private void setMethods(String[] methods) {
        if (methods == null || methods.length == 0 || methods[0] == null) {
            return;
        }
        this.methods = methods;
        if (methods.length > 1) {
            Arrays.sort(methods);
        }
    }

    private void setMethods(String actions) {
        if (actions == null || actions.length() == 0) {
            return;
        }
        String[] ar = new String[2];
        int cnt = 0;
        int i = 0;
        while (i < actions.length()) {
            if (actions.charAt(i) != ',') {
                int endToken = actions.indexOf(44, i);
                if (endToken < 0) {
                    endToken = actions.length();
                }
                String newStr = actions.substring(i, endToken);
                i = endToken;
                if (ar.length == cnt) {
                    String[] newAr = new String[cnt * 2];
                    System.arraycopy(ar, 0, newAr, 0, cnt);
                    ar = newAr;
                }
                ar[cnt] = newStr.trim();
                ++cnt;
            }
            ++i;
        }
        if (cnt != ar.length) {
            String[] newAr = new String[cnt];
            System.arraycopy(ar, 0, newAr, 0, cnt);
            ar = newAr;
        }
        this.setMethods(ar);
    }

    public WSInvokePermission() {
        super("*");
    }

    public WSInvokePermission(String serviceName) {
        super(serviceName != null && serviceName.length() > 0 ? serviceName : "*");
    }

    public WSInvokePermission(String serviceName, String[] methods) {
        super(serviceName != null && serviceName.length() > 0 ? serviceName : "*");
        if (methods != null && methods.length != 0 && methods[0] != null) {
            this.methods = methods;
        }
    }

    public WSInvokePermission(String serviceName, String actions) {
        super(serviceName);
        this.setMethods(actions);
    }

    public boolean implies(Permission p) {
        if (!(p instanceof WSInvokePermission)) {
            return false;
        }
        WSInvokePermission that = (WSInvokePermission)p;
        if (!this.getName().equals("*") && !this.getName().equals(that.getName())) {
            return false;
        }
        if (this.methods == null) {
            return true;
        }
        String[] thatMethods = that.getMethods();
        if (thatMethods == null) {
            return false;
        }
        int toMatch = thatMethods.length;
        int thisIndex = 0;
        int thatIndex = 0;
        while (thisIndex < this.methods.length && thatIndex < thatMethods.length) {
            int compRes = this.methods[thisIndex].compareTo(thatMethods[thatIndex]);
            if (compRes == 0) {
                ++thatIndex;
                ++thisIndex;
                --toMatch;
                continue;
            }
            if (compRes < 0) {
                ++thisIndex;
                continue;
            }
            return false;
        }
        return toMatch == 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WSInvokePermission)) {
            return false;
        }
        WSInvokePermission that = (WSInvokePermission)obj;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (this.getMethods() == null) {
            if (that.getMethods() != null) {
                return false;
            }
        } else {
            if (that.getMethods() == null) {
                return false;
            }
            String[] thatMethods = that.getMethods();
            if (this.methods.length != thatMethods.length) {
                return false;
            }
            int i = 0;
            while (i < this.methods.length) {
                if (!this.methods[i].equals(thatMethods[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = this.getMethodsAsString();
        }
        return this.actions;
    }

    private String getMethodsAsString() {
        if (this.methods == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.methods.length - 1) {
            sb.append(this.methods[i]);
            sb.append(',');
            ++i;
        }
        sb.append(this.methods[this.methods.length - 1]);
        return sb.toString();
    }

    public PermissionCollection newPermissionCollection() {
        return new WSInvokePermissionCollection();
    }
}

