/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import org.systinet.security.perm.WSBManagePermissionCollection;

public class WSBManagePermission
extends Permission {
    public static final String ALL_NAMES = "*";
    public static final int GET = 1;
    public static final int SET = 2;
    public static final int ALL = 3;
    private static final int NONE = 0;
    private static final int[] ACTION_FLAGS = new int[]{1, 2};
    private static final String[] ACTION_STRINGS = new String[]{"get", "set"};
    private transient int mask;
    private String actions;

    protected WSBManagePermission() {
        super(ALL_NAMES);
    }

    public WSBManagePermission(String name) {
        super(name);
        this.init(3);
    }

    public WSBManagePermission(String name, String actions) {
        super(name);
        if (actions == null || actions.length() == 0) {
            this.mask = 3;
        } else {
            this.init(WSBManagePermission.getMask(actions));
        }
    }

    public WSBManagePermission(String name, int actionMask) {
        super(name);
        this.init(actionMask);
    }

    private void init(int mask) {
        if ((mask & 3) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = mask;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof WSBManagePermission)) {
            return false;
        }
        WSBManagePermission that = (WSBManagePermission)p;
        if ((this.mask & that.mask) == that.mask) {
            if (this.getName().equals(ALL_NAMES)) {
                return true;
            }
            return this.getName().equals(that.getName());
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WSBManagePermission)) {
            return false;
        }
        WSBManagePermission that = (WSBManagePermission)obj;
        return this.mask == that.mask && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String actions) {
        mask = 0;
        if (actions == null) {
            return mask;
        }
        a = actions.toCharArray();
        i = a.length - 1;
        if (i >= 0) ** GOTO lbl32
        return mask;
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (!(i < 2 || a[i - 2] != 'g' && a[i - 2] != 'G' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 3;
                    mask |= 1;
                } else if (!(i < 2 || a[i - 2] != 's' && a[i - 2] != 'S' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 3;
                    mask |= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + actions);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + actions);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl32:
                // 2 sources

            } while (i != -1);
        }
        return mask;
    }

    static String getActions(int mask) {
        StringBuffer sb = new StringBuffer();
        boolean nc = false;
        int i = 0;
        while (i < ACTION_FLAGS.length) {
            if ((mask & ACTION_FLAGS[i]) > 0) {
                if (nc) {
                    sb.append(',');
                }
                sb.append(ACTION_STRINGS[i]);
                nc = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = WSBManagePermission.getActions(this.mask);
        }
        return this.actions;
    }

    int getMask() {
        return this.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new WSBManagePermissionCollection();
    }
}

