/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.systinet.security.perm.WASPRole;

final class WASPRolePermissionCollection
extends PermissionCollection {
    private Hashtable permissions = new Hashtable();

    public void add(Permission permission) {
        if (!(permission instanceof WASPRole)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        WASPRole that = (WASPRole)permission;
        this.permissions.put(permission.getName(), permission);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof WASPRole)) {
            return false;
        }
        WASPRole that = (WASPRole)permission;
        return this.permissions.get(permission.getName()) != null;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

