/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.systinet.security.perm.DelegatePermission;

class DelegatePermissionCollection
extends PermissionCollection {
    private boolean isAll;
    private Hashtable permissions = new Hashtable();

    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        DelegatePermission that = (DelegatePermission)permission;
        this.permissions.put(permission.getName(), permission);
        if (that.isAll()) {
            this.isAll = true;
        }
    }

    public boolean implies(Permission permission) {
        DelegatePermission that = (DelegatePermission)permission;
        if (this.isAll) {
            return true;
        }
        return this.permissions.get(that.getName()) != null;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

