/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import org.systinet.security.perm.DelegatePermissionCollection;

public abstract class DelegatePermission
extends Permission {
    public static final String ALL_NAMES = "*";
    private boolean isAll = this.getName().equals("*");

    protected DelegatePermission(String name) {
        super(name == null ? ALL_NAMES : name);
    }

    boolean isAll() {
        return this.isAll;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" name='");
        sb.append(this.getName());
        sb.append('\'');
        return sb.toString();
    }

    public boolean implies(Permission p) {
        DelegatePermission that = (DelegatePermission)p;
        if (this.isAll) {
            return true;
        }
        return this.getName().equals(that.getName());
    }

    public boolean equals(Object obj) {
        DelegatePermission that = (DelegatePermission)obj;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return null;
    }

    public PermissionCollection newPermissionCollection() {
        return new DelegatePermissionCollection();
    }
}

