/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.security.perm;

import java.security.Permission;
import java.security.PermissionCollection;
import org.systinet.security.perm.ACLPermissionCollection;

public final class ACLPermission
extends Permission {
    private static final int PERM = 8;
    private static final int ROLE = 16;
    private static final int ALL_NAMES = 24;
    private static final int[] NAME_FLAGS = new int[]{8, 16};
    public static final int GET = 1;
    public static final int MODIFY = 2;
    public static final int ALL = 3;
    private static final int NONE = 0;
    private static final int[] ACTION_FLAGS = new int[]{1, 2};
    private static final String[] ACTION_STRINGS = new String[]{"get", "modify"};
    private static final String[] NAME_STRINGS = new String[]{"perm", "role"};
    private transient int mask;
    private transient int nameMask = ACLPermission.getNameFlags(this.getName());
    private String actions;

    private void init(int mask) {
        if ((mask & 3) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (this.getName() == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = mask | this.nameMask;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" parts='");
        sb.append(this.getName());
        sb.append("' action='");
        sb.append(this.getActions());
        sb.append('\'');
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static int getNameFlags(String name) {
        mask = 0;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("invalid permission name: " + name);
        }
        a = name.toCharArray();
        i = a.length - 1;
        ** GOTO lbl35
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (i >= 3 && a[i - 3] == 'r' && a[i - 2] == 'o' && a[i - 1] == 'l' && a[i] == 'e') {
                    matchlen = 4;
                    mask |= 16;
                } else if (i >= 3 && a[i - 3] == 'p' && a[i - 2] == 'e' && a[i - 1] == 'r' && a[i] == 'm') {
                    matchlen = 4;
                    mask |= 8;
                } else if (i >= 2 && a[i - 2] == 'a' && a[i - 1] == 'l' && a[i] == 'l') {
                    matchlen = 3;
                    mask |= 24;
                } else {
                    throw new IllegalArgumentException("invalid permission name: " + name);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission name: " + name);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl35:
                // 2 sources

            } while (i != -1);
        }
        return mask;
    }

    private static final String convertName(String name) {
        return name.toLowerCase();
    }

    public ACLPermission(String name, String actions) {
        super(ACLPermission.convertName(name));
        if (actions == null || actions.length() == 0) {
            this.mask = 3 | this.nameMask;
        } else {
            this.init(ACLPermission.getMask(actions));
        }
    }

    public ACLPermission(String name, int actionMask) {
        super(ACLPermission.convertName(name));
        this.init(actionMask);
    }

    public boolean implies(Permission p) {
        if (!(p instanceof ACLPermission)) {
            return false;
        }
        ACLPermission that = (ACLPermission)p;
        return (this.mask & that.mask) == that.mask;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ACLPermission)) {
            return false;
        }
        ACLPermission that = (ACLPermission)obj;
        return this.mask == that.mask;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String actions) {
        mask = 0;
        if (actions == null) {
            return mask;
        }
        a = actions.toCharArray();
        i = a.length - 1;
        if (i >= 0) ** GOTO lbl36
        return mask;
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (!(i < 2 || a[i - 2] != 'g' && a[i - 2] != 'G' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 3;
                    mask |= 1;
                } else if (!(i < 5 || a[i - 5] != 'm' && a[i - 5] != 'M' || a[i - 4] != 'o' && a[i - 4] != 'O' || a[i - 3] != 'd' && a[i - 3] != 'D' || a[i - 2] != 'i' && a[i - 2] != 'i' || a[i - 1] != 'f' && a[i - 1] != 'F' || a[i] != 'y' && a[i] != 'Y')) {
                    matchlen = 6;
                    mask |= 2;
                } else if (!(i < 2 || a[i - 2] != 'a' && a[i - 2] != 'A' || a[i - 1] != 'l' && a[i - 1] != 'L' || a[i] != 'l' && a[i] != 'L')) {
                    matchlen = 3;
                    mask |= 3;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + actions);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + actions);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl36:
                // 2 sources

            } while (i != -1);
        }
        return mask;
    }

    static String getActions(int mask) {
        StringBuffer sb = new StringBuffer(10);
        boolean nc = false;
        int i = 0;
        while (i < ACTION_FLAGS.length) {
            if ((mask & ACTION_FLAGS[i]) > 0) {
                if (nc) {
                    sb.append(',');
                }
                sb.append(ACTION_STRINGS[i]);
                nc = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = ACLPermission.getActions(this.mask);
        }
        return this.actions;
    }

    int getMask() {
        return this.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new ACLPermissionCollection();
    }
}

