/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.soap.util;

import com.idoox.xml.XmlWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.XMLWriterReader;
import org.systinet.wasp.soap.FirstElementSkippingTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LazyFillingTokenizer
implements Tokenizer {
    XMLWriterReader wr;
    Tokenizer contentTokenizer;
    TokenWriter tokenWriter;
    Filler filler;
    boolean filled;
    boolean bodyEnd;
    SOAPElement element;

    public LazyFillingTokenizer(Filler filler) {
        this.filler = filler;
        this.filled = false;
    }

    public LazyFillingTokenizer(Filler filler, SOAPElement element) {
        this.filler = filler;
        this.filled = false;
        this.element = element;
    }

    public String getLocalName() throws TokenizerException {
        return this.contentTokenizer.getLocalName();
    }

    public String getNamespace() throws TokenizerException {
        return this.contentTokenizer.getNamespace();
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.contentTokenizer.getNamespaceForPrefix(prefix);
    }

    public Element getDOMRepresentation(Document doc) throws TokenizerException {
        return this.contentTokenizer.getDOMRepresentation(doc);
    }

    public QName parseQName(String qName) {
        return this.contentTokenizer.parseQName(qName);
    }

    public byte next() throws TokenizerException, IOException {
        if (this.init()) {
            return 3;
        }
        if (this.bodyEnd) {
            return 1;
        }
        return this.contentTokenizer.next();
    }

    protected boolean init() throws TokenizerException, IOException {
        if (!this.filled) {
            this.filled = true;
            if (this.tokenWriter == null) {
                this.wr = new XMLWriterReader();
                this.wr.enter("paddingNamespace1234", "PADDING");
                if (this.element != null) {
                    Iterator prefixes = this.element.getNamespacePrefixes();
                    while (prefixes.hasNext()) {
                        String pref = (String)prefixes.next();
                        this.wr.setPrefixForNamespace(pref, this.element.getNamespaceURI(pref));
                    }
                }
                this.filler.fillTokenWriter(this.wr);
                this.wr.leave();
                this.wr.next();
                this.contentTokenizer = new FirstElementSkippingTokenizer(this.wr, false, true);
            } else {
                this.filler.fillTokenWriter(this.tokenWriter);
                this.bodyEnd = true;
                return true;
            }
        }
        return false;
    }

    public byte currentState() {
        try {
            if (this.init()) {
                return 3;
            }
            if (this.bodyEnd) {
                return 3;
            }
            return this.contentTokenizer.currentState();
        }
        catch (TokenizerException e) {
            throw new RuntimeWrappedException("Unable to initialize!", e);
        }
        catch (IOException e) {
            throw new RuntimeWrappedException("Unable to initialize!", e);
        }
    }

    public String readContent() throws TokenizerException {
        return this.contentTokenizer.readContent();
    }

    public void readToken(Token stoken) throws TokenizerException, IOException {
        this.contentTokenizer.readToken(stoken);
    }

    public boolean whitespaceContent() throws TokenizerException {
        return this.contentTokenizer.whitespaceContent();
    }

    public Map getCurrentPrefixMap() {
        return this.contentTokenizer.getCurrentPrefixMap();
    }

    public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
        try {
            if (this.init()) {
                throw new IllegalStateException("pushNewlyDeclaredPrefixes cannot be called when optimizations are used!");
            }
            return this.contentTokenizer.pushNewlyDeclaredPrefixes(prefixes);
        }
        catch (TokenizerException e) {
            throw new RuntimeWrappedException("Unable to initialize!", e);
        }
        catch (IOException e) {
            throw new RuntimeWrappedException("Unable to initialize!", e);
        }
    }

    public void setWriter(TokenWriter tokenWriter) {
        if (this.wr == null && this.tokenWriter == null) {
            this.tokenWriter = tokenWriter;
        }
    }

    public void writeTo(XmlWriter writer) throws TokenizerException, IOException {
        this.filler.fillTokenWriter(writer);
    }

    public static interface Filler {
        public void fillTokenWriter(TokenWriter var1) throws IOException, TokenizerException;
    }
}

