/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.rpc.handler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.SOAPMessage;
import org.systinet.logging.Category;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.rpc.handler.ClientBookmark;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Processing;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.wasp.webservice.ServiceInstanceContext;

public abstract class Bookmark
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 526249573112499033L;
    protected CurrentState currentState;
    public static final String CONNECTION_TO = "connection.to";
    public static final int CONNECTION_TO_FROM = 1;
    public static final int CONNECTION_TO_REPLAYTO = 2;
    public static final int CONNECTION_TO_FAULTTO = 3;
    static /* synthetic */ Class class$org$systinet$wasp$handler$HandlerRepository$DirectionPositionEntry;

    protected Bookmark() {
    }

    protected Bookmark(Bookmark bookmark) {
        this.currentState = bookmark.currentState;
    }

    public abstract InvocationState handleInput(InvocationState var1);

    public abstract InvocationState handleOutput(InvocationState var1) throws RemoteException;

    public abstract InvocationState handleShortOutput(InvocationState var1);

    public abstract InvocationState handleShortInput(InvocationState var1);

    public abstract void oneWayAck(String var1);

    public abstract Object clone();

    public synchronized void init(Processing processing) {
        this.currentState.init(processing);
    }

    public static Bookmark createBookmark(HandlerRepository.DirectionPositionEntry position, Map messageContextProperies) {
        Bookmark ret = null;
        try {
            Serializable bookmarkClass;
            if (Current.getProcessingType() == 1) {
                bookmarkClass = Class.forName("com.systinet.wasp.webservice.ClientBookmarkImpl");
                Constructor<?> constructor = bookmarkClass.getConstructor(class$org$systinet$wasp$handler$HandlerRepository$DirectionPositionEntry == null ? (class$org$systinet$wasp$handler$HandlerRepository$DirectionPositionEntry = Bookmark.class$("org.systinet.wasp.handler.HandlerRepository$DirectionPositionEntry")) : class$org$systinet$wasp$handler$HandlerRepository$DirectionPositionEntry);
                ret = (Bookmark)constructor.newInstance(position);
                ((ClientBookmark)ret).setServiceClient(Current.getServiceClientContext().getServiceClient());
            } else {
                bookmarkClass = Class.forName("com.systinet.wasp.webservice.ServerBookmarkImpl");
                Constructor<?> constructor = bookmarkClass.getConstructor(class$org$systinet$wasp$handler$HandlerRepository$DirectionPositionEntry == null ? (class$org$systinet$wasp$handler$HandlerRepository$DirectionPositionEntry = Bookmark.class$("org.systinet.wasp.handler.HandlerRepository$DirectionPositionEntry")) : class$org$systinet$wasp$handler$HandlerRepository$DirectionPositionEntry);
                ret = (Bookmark)constructor.newInstance(position);
            }
            bookmarkClass = ret;
            synchronized (bookmarkClass) {
                ret.currentState = CurrentState.takeSnapshot(messageContextProperies);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public synchronized CurrentState getCurrentState() {
        return this.currentState;
    }

    public synchronized void setCurrentState(InvocationState invocationState) {
        this.currentState = this.currentState.copyCurrentState(invocationState.getCallContext(), invocationState.getMessageProperties());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static abstract class CurrentState
    extends InheritableThreadLocal
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 516249573112499033L;
        protected int processingType;
        protected CallContext callContext;
        protected ServiceClientContext serviceClientContext;
        protected ServiceEndpointContext serviceEndpointContext;
        protected ServiceInstanceContext serviceInstanceContext;
        protected Map messageContextProperties;
        protected Map callContextData;
        private static final int CALL_CONTEXT_STAGE = 1;
        private static final int MESSAGE_PROPERTIES_STAGE = 2;
        private static final int END_STAGE = 3;
        static /* synthetic */ Class class$java$util$Map;
        static /* synthetic */ Class class$java$io$Serializable;
        static /* synthetic */ Class array$Ljava$lang$Object;
        static /* synthetic */ Class array$Ljava$io$Serializable;

        private static CurrentState takeSnapshot(Map messageContextProperies) {
            try {
                Class<?> currentStateClass = Class.forName("com.systinet.wasp.webservice.CurrentStateImpl");
                Constructor<?> constructor = currentStateClass.getConstructor(class$java$util$Map == null ? (class$java$util$Map = CurrentState.class$("java.util.Map")) : class$java$util$Map);
                return (CurrentState)constructor.newInstance(messageContextProperies);
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected abstract CurrentState copyCurrentState(CallContext var1, Map var2);

        public abstract void applyCallContext(CallContext var1);

        public abstract void applyToCurrentThread(CallContext var1, Map var2);

        public abstract void restoreCurrentThread();

        public abstract void init(Processing var1);

        public abstract Object clone();

        public int getProcessingType() {
            return this.processingType;
        }

        public CallContext getCallContext() {
            return this.callContext;
        }

        public ServiceClientContext getServiceClientContext() {
            return this.serviceClientContext;
        }

        public ServiceEndpointContext getServiceEndpointContext() {
            return this.serviceEndpointContext;
        }

        public ServiceInstanceContext getServiceInstanceContext() {
            return this.serviceInstanceContext;
        }

        public Map getMessageContextProperties() {
            return this.messageContextProperties;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            CurrentState currentState;
            s.writeInt(this.processingType);
            if (this.callContext != null) {
                s.writeInt(1);
                currentState = this;
                synchronized (currentState) {
                    s.writeObject(CurrentState.createSerializableMap(this.callContext.getContextData()));
                }
            }
            if (this.messageContextProperties != null) {
                s.writeInt(2);
                currentState = this;
                synchronized (currentState) {
                    s.writeObject(CurrentState.createSerializableMap(this.messageContextProperties));
                }
            }
            s.writeInt(3);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            this.processingType = s.readInt();
            int stage = s.readInt();
            while (stage != 3) {
                switch (stage) {
                    case 1: {
                        this.callContextData = (Map)s.readObject();
                        break;
                    }
                    case 2: {
                        this.messageContextProperties = (Map)s.readObject();
                    }
                }
                stage = s.readInt();
            }
        }

        protected static final HashMap createSerializableMap(Map source) {
            HashMap ret = new HashMap();
            Iterator i = source.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null || !(class$java$io$Serializable == null ? CurrentState.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(key.getClass()) || !(class$java$io$Serializable == null ? CurrentState.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(value.getClass()) || (array$Ljava$lang$Object == null ? CurrentState.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object).isAssignableFrom(value.getClass()) && (!(array$Ljava$lang$Object == null ? CurrentState.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object).isAssignableFrom(value.getClass()) || !(array$Ljava$io$Serializable == null ? CurrentState.class$("[Ljava.io.Serializable;") : array$Ljava$io$Serializable).isAssignableFrom(value.getClass())) || Proxy.isProxyClass(value.getClass()) || (class$java$util$Map == null ? CurrentState.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(value.getClass())) continue;
                ret.put(key, entry.getValue());
            }
            return ret;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class InvocationState {
        private CallContext callContext;
        private Map messageProperties;
        private SOAPMessage message;
        private boolean fault;
        private ISequence outputSequence;
        private static final int CALL_CONTEXT = 1;
        private static final int MESSAGE_PROPERTIES = 2;
        private static final int END = 3;
        private static final Category dbg = Category.getCategory("org.systinet.wasp.rpc.handler.Bookmark$InvocationState");

        public InvocationState(CallContext callContext, Map messageProperties, SOAPMessage response) {
            this.callContext = callContext;
            this.messageProperties = messageProperties;
            this.message = response;
        }

        public InvocationState(CallContext callContext, Map messageProperties, SOAPMessage message, boolean fault) {
            this.callContext = callContext;
            this.messageProperties = messageProperties;
            this.message = message;
            this.fault = fault;
        }

        public CallContext getCallContext() {
            return this.callContext;
        }

        public Map getMessageProperties() {
            return this.messageProperties;
        }

        public SOAPMessage getMessage() {
            return this.message;
        }

        public void setMessage(SOAPMessage message) {
            this.message = message;
        }

        public boolean isFault() {
            return this.fault;
        }

        public void setFault(boolean fault) {
            this.fault = fault;
        }

        public ISequence getOutputSequence() {
            return this.outputSequence;
        }

        public void setOutputSequence(ISequence outputSequence) {
            this.outputSequence = outputSequence;
        }
    }
}

