/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.policy.assertion;

import com.idoox.util.ElementHelper;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.idoox.wasp.serialization.xsdbuiltin.DateTime;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.systinet.wasp.policy.PolicyAssertion;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.wasp.policy.PolicyUsage;
import org.systinet.xml.XMLSourceHelper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExpirationAssertion
extends PolicyAssertion {
    private static final QName ELEMENT_QNAME = new QName("http://schemas.xmlsoap.org/ws/2002/07/utility", "Expires");
    private static final String ELEMENT_TAGNAME = "wsu:" + ELEMENT_QNAME.getLocalPart();
    private Date expires;

    public ExpirationAssertion(Source content) throws PolicyException {
        this.load(content);
    }

    public ExpirationAssertion(Date expires, PolicyUsage usage) {
        this.setUsage(usage);
        this.expires = expires;
    }

    public Date getExpires() {
        return this.expires;
    }

    private void load(Source content) throws PolicyException {
        try {
            DOMSource domSource = XMLSourceHelper.transformToDOMSource(content);
            Element element = (Element)domSource.getNode();
            if (element == null || !ElementHelper.getTagName(element).equals(ELEMENT_QNAME)) {
                throw new PolicyException("There is no " + ELEMENT_QNAME + " element in " + content.getSystemId());
            }
            this.expires = new DateTime(element.getNodeValue()).toJavaUtilDate();
            this.readStandardAttributes(domSource);
        }
        catch (TransformerException e) {
            throw new PolicyException(e);
        }
        catch (DateTimeException e) {
            throw new PolicyException(e);
        }
        catch (DOMException e) {
            throw new PolicyException(e);
        }
    }

    public Source getContent() throws PolicyException {
        try {
            DOMSource domSource = XMLSourceHelper.createDOMSource(ELEMENT_QNAME.getNamespaceURI(), ELEMENT_TAGNAME);
            Element element = (Element)domSource.getNode();
            Document document = element.getOwnerDocument();
            element.appendChild(document.createTextNode(new DateTime(this.expires).toString()));
            this.writeStandardAttributes(domSource);
            return domSource;
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
        catch (DOMException e) {
            throw new PolicyException(e);
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ExpirationAssertion;
    }
}

