/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.policy;

import com.idoox.util.ElementHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.wasp.policy.PolicyUsage;
import org.w3c.dom.Element;

public abstract class PolicyElement {
    private PolicyUsage usage = null;
    private int preference = 0;
    private PolicyElement parentElement;

    protected PolicyElement() {
        this.setPreference(100);
    }

    public PolicyUsage getUsage() {
        if (this.usage != null) {
            return this.usage;
        }
        if (this.parentElement != null) {
            return this.parentElement.getUsage();
        }
        return PolicyUsage.OBSERVED;
    }

    public void setUsage(PolicyUsage usage) {
        this.usage = usage;
    }

    public int getPreference() {
        return this.preference;
    }

    public void setPreference(int preference) {
        this.preference = preference;
    }

    public PolicyElement getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(PolicyElement parentElement) throws PolicyException {
        if (parentElement != null && this.parentElement != null && this.parentElement != parentElement) {
            throw new PolicyException("Parent element was already set.");
        }
        this.parentElement = parentElement;
    }

    protected void readStandardAttributes(DOMSource domSource) {
        if (domSource != null) {
            String preference;
            Element element = (Element)domSource.getNode();
            String usage = ElementHelper.getAttributeNS(element, "http://schemas.xmlsoap.org/ws/2002/12/policy", "Usage");
            if (usage != null) {
                QName qName = ElementHelper.getQName(element, usage);
                this.setUsage(PolicyUsage.fromValue(qName));
            }
            if ((preference = ElementHelper.getAttributeNS(element, "http://schemas.xmlsoap.org/ws/2002/12/policy", "Preference")) != null) {
                this.setPreference(Integer.parseInt(preference));
            } else {
                this.setPreference(0);
            }
        }
    }

    protected void writeStandardAttributes(DOMSource domSource) {
        if (domSource != null) {
            Element element = (Element)domSource.getNode();
            String prefix = "wsp";
            Map map = ElementHelper.getDeclaredNamespaces(element, new HashMap());
            Set entries = map.entrySet();
            boolean found = false;
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!"http://schemas.xmlsoap.org/ws/2002/12/policy".equals(entry.getValue())) continue;
                prefix = (String)entry.getKey();
                found = true;
                break;
            }
            if (!found) {
                element.setAttribute("xmlns:wsp", "http://schemas.xmlsoap.org/ws/2002/12/policy");
            }
            if (this.usage != null) {
                element.setAttributeNS("http://schemas.xmlsoap.org/ws/2002/12/policy", prefix + ":Usage", prefix + ":" + this.usage.toString());
            }
            element.setAttributeNS("http://schemas.xmlsoap.org/ws/2002/12/policy", prefix + ":Preference", String.valueOf(this.preference));
        }
    }

    public abstract Source getContent() throws PolicyException;
}

