/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.addressing;

import com.idoox.util.ElementHelper;
import java.io.Serializable;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.systinet.wasp.policy.DomainExpression;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.xml.XMLSourceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EndpointReference
implements DomainExpression,
Serializable {
    public static final String ANONYMOUS = "http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous";
    private static final String LOCAL_NAME = "EndpointReference";
    private static final String NS_URI = "http://schemas.xmlsoap.org/ws/2003/03/addressing";
    private static final QName ELEMENT_QNAME = new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "EndpointReference");
    private String address;
    private QName portType;
    private QName serviceName;
    private String portName;

    public EndpointReference() {
        this((String)null);
    }

    public EndpointReference(String address) {
        this(address, null, null, null);
    }

    public EndpointReference(String address, QName portType, QName serviceName, String portName) {
        this.address = address == null ? ANONYMOUS : address;
        this.portType = portType;
        this.serviceName = serviceName;
        this.portName = portName;
    }

    public EndpointReference(ServiceClient client) throws LookupException {
        this(client.getServiceURL(), null, client.getWSDLServiceName(), client.getWSDLPortName());
    }

    public EndpointReference(Source source) throws PolicyException {
        this.load(source);
    }

    public String getAddress() {
        return this.address;
    }

    public QName getPortType() {
        return this.portType;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public boolean isAnonymous() {
        return ANONYMOUS.equals(this.address);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (!(obj instanceof EndpointReference)) {
            return false;
        }
        EndpointReference o = (EndpointReference)obj;
        if (o == this) return true;
        if (this.address == null) {
            if (o.address != null) return false;
            bl3 = true;
        } else {
            bl3 = this.address.equals(o.address);
        }
        if (!bl3) return false;
        if (this.portType == null) {
            if (o.portType != null) return false;
            bl2 = true;
        } else {
            bl2 = this.portType.equals(o.portType);
        }
        if (!bl2) return false;
        if (this.serviceName == null) {
            if (o.serviceName != null) return false;
            bl = true;
        } else {
            bl = this.serviceName.equals(o.serviceName);
        }
        if (!bl) return false;
        if (this.portName == null) {
            if (o.portName != null) return false;
            return true;
        }
        boolean bl4 = this.portName.equals(o.portName);
        if (!bl4) return false;
        return true;
    }

    public int hashCode() {
        return (this.address == null ? 0 : this.address.hashCode()) ^ (this.portType == null ? 0 : this.portType.hashCode()) ^ (this.serviceName == null ? 0 : this.serviceName.hashCode()) ^ (this.portName == null ? 0 : this.portName.hashCode());
    }

    public boolean includes(DomainExpression domainExpression) {
        if (domainExpression == null) {
            return false;
        }
        if (domainExpression instanceof EndpointReference) {
            boolean portNameInclude;
            EndpointReference o = (EndpointReference)domainExpression;
            if (this.equals(o)) {
                return true;
            }
            boolean addressInclude = this.address == null ? true : this.address.equals(o.address);
            boolean portTypeInclude = this.portType == null ? true : this.portType.equals(o.portType);
            boolean serviceNameInclude = this.serviceName == null ? true : this.serviceName.equals(o.serviceName);
            boolean bl = portNameInclude = this.portName == null ? true : this.portName.equals(o.portName);
            if (addressInclude && portTypeInclude && serviceNameInclude && portNameInclude) {
                return true;
            }
        }
        return false;
    }

    private void load(Source source) throws PolicyException {
        try {
            DOMSource domSource = XMLSourceHelper.transformToDOMSource(source);
            if (domSource != null) {
                Node node;
                Element element = (Element)domSource.getNode();
                if (element == null || !ElementHelper.getTagName(element).equals(ELEMENT_QNAME)) {
                    throw new PolicyException("There is no " + ELEMENT_QNAME + " element in " + source.getSystemId());
                }
                Element e = ElementHelper.getChildElementByTagName(element, NS_URI, "Address");
                if (e != null && (node = e.getFirstChild()) != null && node.getNodeType() == 3) {
                    this.address = node.getNodeValue();
                }
                if ((e = ElementHelper.getChildElementByTagName(element, NS_URI, "PortType")) != null && (node = e.getFirstChild()) != null && node.getNodeType() == 3) {
                    this.portType = ElementHelper.getQName(e, node.getNodeValue());
                }
                if ((e = ElementHelper.getChildElementByTagName(element, NS_URI, "ServiceName")) != null) {
                    String portName;
                    node = e.getFirstChild();
                    if (node != null && node.getNodeType() == 3) {
                        this.serviceName = ElementHelper.getQName(e, node.getNodeValue());
                    }
                    if ((portName = ElementHelper.getAttributeNS(e, NS_URI, "portName")) != null) {
                        this.portName = portName;
                    }
                }
            }
        }
        catch (TransformerException e) {
            throw new PolicyException(e);
        }
    }

    public Source getContent() throws PolicyException {
        try {
            DOMSource domSource = XMLSourceHelper.createDOMSource(NS_URI, "wsa:EndpointReference");
            Element element = (Element)domSource.getNode();
            Document document = element.getOwnerDocument();
            Element path = document.createElementNS(NS_URI, "wsa:Address");
            path.appendChild(document.createTextNode(this.address));
            element.appendChild(path);
            if (this.portType != null) {
                Element portType = document.createElementNS(NS_URI, "wsa:PortType");
                portType.appendChild(document.createTextNode(this.portType.getNamespaceURI() + ":" + this.portType.getLocalPart()));
                element.appendChild(portType);
            }
            if (this.serviceName != null) {
                Element serviceName = document.createElementNS(NS_URI, "wsa:ServiceName");
                serviceName.appendChild(document.createTextNode(this.serviceName.getNamespaceURI() + ":" + this.serviceName.getLocalPart()));
                if (this.portName != null) {
                    serviceName.setAttribute("PortName", this.portName);
                }
                element.appendChild(serviceName);
            }
            return domSource;
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
    }

    public String toString() {
        return this.address + ':' + (this.portType == null ? "" : this.portType.toString()) + ':' + (this.serviceName == null ? "" : this.serviceName.toString()) + (this.portName == null ? "" : this.portName);
    }
}

