/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.addressing;

import com.idoox.util.UUID;
import java.io.Serializable;
import javax.xml.namespace.QName;
import org.systinet.wasp.addressing.EndpointReference;

public class AddressingHeaders
implements Serializable {
    public EndpointReference to;
    public EndpointReference from;
    public EndpointReference replyTo;
    public EndpointReference faultTo;
    public String messageID;
    public Relationship[] relatesTo = new Relationship[0];

    public void setRelatedMessageID(String messageID, QName relationshipType) {
        this.relatesTo = new Relationship[1];
        this.relatesTo[0] = new Relationship(messageID, relationshipType);
    }

    public String getRelatedMessageID(QName relationshipType) {
        int i = 0;
        while (i < this.relatesTo.length) {
            if (this.relatesTo[i].type == null || Relationship.RESPONSE.equals(this.relatesTo[i].type)) {
                return this.relatesTo[i].messageID;
            }
            ++i;
        }
        return null;
    }

    public AddressingHeaders(EndpointReference to) {
        this.to = to;
    }

    public AddressingHeaders(EndpointReference to, String messageID) {
        this(to);
        this.messageID = messageID;
        this.to = to;
    }

    public static String generateUniqueMessageID() {
        return "uuid:" + UUID.uuidgen();
    }

    public AddressingHeaders(EndpointReference to, AddressingHeaders request) {
        this.messageID = AddressingHeaders.generateUniqueMessageID();
        this.to = to;
        this.setRelatedMessageID(request.messageID, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        if (!(obj instanceof AddressingHeaders)) {
            return false;
        }
        AddressingHeaders o = (AddressingHeaders)obj;
        if (o == this) return true;
        if (this.messageID == null) {
            if (o.messageID != null) return false;
            bl5 = true;
        } else {
            bl5 = this.messageID.equals(o.messageID);
        }
        if (!bl5) return false;
        if (this.to == null) {
            if (o.to != null) return false;
            bl4 = true;
        } else {
            bl4 = this.to.equals(o.to);
        }
        if (!bl4) return false;
        if (this.from == null) {
            if (o.from != null) return false;
            bl3 = true;
        } else {
            bl3 = this.from.equals(o.from);
        }
        if (!bl3) return false;
        if (this.replyTo == null) {
            if (o.replyTo != null) return false;
            bl2 = true;
        } else {
            bl2 = this.replyTo.equals(o.replyTo);
        }
        if (!bl2) return false;
        if (this.faultTo == null) {
            if (o.faultTo != null) return false;
            bl = true;
        } else {
            bl = this.faultTo.equals(o.faultTo);
        }
        if (!bl) return false;
        if (this.relatesTo == null) {
            if (o.relatesTo != null) return false;
            return true;
        }
        boolean bl6 = AddressingHeaders.equals(this.relatesTo, o.relatesTo);
        if (!bl6) return false;
        return true;
    }

    private static boolean equals(Relationship[] a, Relationship[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            block8: {
                block9: {
                    block7: {
                        if (a[i] != null && b[i] != null) break block7;
                        if (a[i] != b[i]) {
                            return false;
                        }
                        break block8;
                    }
                    boolean bl = a[i].messageID == null ? b[i].messageID == null : a[i].messageID.equals(b[i].messageID);
                    if (!bl) break block9;
                    if (a[i].type == null ? b[i].type == null : a[i].type.equals(b[i].type)) break block8;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return (this.messageID == null ? 0 : this.messageID.hashCode()) ^ (this.to == null ? 0 : this.to.hashCode()) ^ (this.from == null ? 0 : this.from.hashCode()) ^ (this.replyTo == null ? 0 : this.replyTo.hashCode()) ^ (this.faultTo == null ? 0 : this.faultTo.hashCode()) ^ (this.relatesTo == null ? 0 : this.relatesTo.hashCode());
    }

    public static class Relationship
    implements Serializable {
        public static final String ID_UNSPECIFIED = "http://schemas.xmlsoap.org/ws/2003/03/addressing/id/unspecified";
        public static final QName RESPONSE = new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Response");
        public String messageID;
        public QName type;

        public Relationship(String messageID, QName type) {
            this.messageID = messageID;
            this.type = type;
        }
    }
}

