/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.monitoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.systinet.monitoring.Event;
import org.systinet.monitoring.EventListener;
import org.systinet.monitoring.LogLog;

public class EventManager {
    private static Map eventListeners = new HashMap();
    private static int eventListenerReaders = 0;
    static /* synthetic */ Class class$org$systinet$monitoring$EventManager;

    public static void fireEvent(Event event) {
        EventManager.processEvent(event);
    }

    private static void processEvent(Event event) {
        try {
            EventManager.callEventListeners(event);
        }
        catch (Exception e) {
            LogLog.error((class$org$systinet$monitoring$EventManager == null ? (class$org$systinet$monitoring$EventManager = EventManager.class$("org.systinet.monitoring.EventManager")) : class$org$systinet$monitoring$EventManager).getName(), e);
        }
    }

    private static void callEventListeners(Event event) {
        EventListener[] eventListeners;
        if (event.getType() != null && (eventListeners = EventManager.getListeners(event.getType())) != null) {
            int i = 0;
            while (i < eventListeners.length) {
                EventListener eventListener = eventListeners[i];
                try {
                    eventListener.handle(event);
                }
                catch (Exception e) {
                    LogLog.error("Exception in LogEvent handler " + eventListener.getClass().getName() + " occured.", e);
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addListener(String eventType, EventListener listener) {
        Map map = eventListeners;
        synchronized (map) {
            while (eventListenerReaders > 0) {
                try {
                    eventListeners.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ArrayList<EventListener> arrayList = (ArrayList<EventListener>)eventListeners.get(eventType);
            if (arrayList == null) {
                arrayList = new ArrayList<EventListener>();
                eventListeners.put(eventType, arrayList);
            }
            if (arrayList.contains(listener)) return;
            arrayList.add(listener);
            return;
        }
    }

    public static EventListener[] getListeners(String eventType) {
        Map map;
        EventListener[] eventListenerArray;
        try {
            Map map2 = eventListeners;
            synchronized (map2) {
                ++eventListenerReaders;
            }
            List arrayList = (List)eventListeners.get(eventType);
            EventListener[] out = null;
            if (arrayList != null) {
                out = arrayList.toArray(new EventListener[0]);
            }
            eventListenerArray = out;
            Object var6_6 = null;
            map = eventListeners;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Map map3 = eventListeners;
            synchronized (map3) {
                --eventListenerReaders;
                eventListeners.notifyAll();
            }
            throw throwable;
        }
        synchronized (map) {
            --eventListenerReaders;
            eventListeners.notifyAll();
        }
        return eventListenerArray;
    }

    public static EventListener[] getListeners() {
        Map map;
        EventListener[] eventListenerArray;
        try {
            Map map2 = eventListeners;
            synchronized (map2) {
                ++eventListenerReaders;
            }
            ArrayList<EventListener> tmp = new ArrayList<EventListener>();
            Collection collection = eventListeners.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                int i = 0;
                while (i < list.size()) {
                    EventListener l = (EventListener)list.get(i);
                    if (!tmp.contains(l)) {
                        tmp.add(l);
                    }
                    ++i;
                }
            }
            EventListener[] out = null;
            if (tmp.size() > 0) {
                out = tmp.toArray(new EventListener[0]);
            }
            eventListenerArray = out;
            Object var8_9 = null;
            map = eventListeners;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Map map3 = eventListeners;
            synchronized (map3) {
                --eventListenerReaders;
                eventListeners.notifyAll();
            }
            throw throwable;
        }
        synchronized (map) {
            --eventListenerReaders;
            eventListeners.notifyAll();
        }
        return eventListenerArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeListener(String eventType, EventListener listener) {
        Map map = eventListeners;
        synchronized (map) {
            while (eventListenerReaders > 0) {
                try {
                    eventListeners.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            List arrayList = (List)eventListeners.get(eventType);
            if (arrayList == null) {
                return;
            }
            int i = 0;
            while (i < arrayList.size()) {
                EventListener eventListener = (EventListener)arrayList.get(i);
                if (listener.equals(eventListener)) {
                    arrayList.remove(listener);
                    return;
                }
                ++i;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeListeners(String eventType) {
        Map map = eventListeners;
        synchronized (map) {
            while (eventListenerReaders > 0) {
                try {
                    eventListeners.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            List arrayList = (List)eventListeners.get(eventType);
            if (arrayList == null) {
                return;
            }
            arrayList.clear();
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

