/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml.schema;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.xml.schema.SchemaException;
import org.w3c.dom.Element;

public class SchemaConstruct
implements Serializable {
    protected QName name;
    private String javaName;
    protected SchemaConstruct reference;
    private ConstructType constructType = ConstructType.UNKNOWN;
    private Map facets;
    private Map prefixNamespaceMap;
    SchemaConstruct parent;
    protected Element appInfo;

    protected SchemaConstruct(ConstructType constructType) {
        this.constructType = constructType;
    }

    protected SchemaConstruct(ConstructType constructType, QName name) {
        this.name = name;
        this.constructType = constructType;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public SchemaConstruct getReferencedConstruct() {
        return this.reference;
    }

    public void setReferencedConstruct(SchemaConstruct referenced) {
        this.reference = referenced;
    }

    public Element getAppInfo() {
        return this.appInfo;
    }

    public void setAppInfo(Element appInfo) {
        this.appInfo = appInfo;
    }

    public Map getFacets() {
        return this.facets;
    }

    public void setFacets(Map facets) {
        this.facets = facets;
    }

    public String toIndentedString(int level, Set alreadyProcessed) {
        return "";
    }

    public String toIndentedString() {
        return this.toIndentedString(0, new HashSet());
    }

    public QName parseQName(String qname) throws SchemaException {
        String localPart;
        String prefix;
        int p = qname.indexOf(58);
        if (p < 0) {
            prefix = "";
            localPart = qname;
        } else {
            prefix = qname.substring(0, p);
            localPart = qname.substring(p + 1);
        }
        return this.getQName(prefix, localPart);
    }

    private QName getQName(String prefix, String localPart) throws SchemaException {
        String fromHash;
        if (this.prefixNamespaceMap != null && (fromHash = (String)this.prefixNamespaceMap.get(prefix)) != null) {
            return new QName(fromHash, localPart);
        }
        if (this.parent != null) {
            try {
                return this.parent.getQName(prefix, localPart);
            }
            catch (SchemaException e) {
                throw new SchemaException(e.getMessage() + "/" + this.getName() + "[" + this.prefixNamespaceMap + "]");
            }
        }
        throw new SchemaException("Prefix " + prefix + " has not been found in " + this.getName() + "[" + this.prefixNamespaceMap + "]");
    }

    public SchemaConstruct getParent() {
        return this.parent;
    }

    public void setParent(SchemaConstruct parent) {
        this.parent = parent;
    }

    public Map getPrefixNamespaceMapping() {
        return this.prefixNamespaceMap;
    }

    public void setPrefixNamespaceMapping(Map prefixNamespaceMap) {
        this.prefixNamespaceMap = prefixNamespaceMap;
    }

    public ConstructType getConstructType() {
        return this.constructType;
    }

    public void setConstructType(ConstructType constructType) {
        this.constructType = constructType;
    }

    public Object clone() {
        SchemaConstruct ret = new SchemaConstruct(ConstructType.UNKNOWN);
        ret.copyFrom(this);
        return ret;
    }

    public void copyFrom(SchemaConstruct anotherConstruct) {
        this.name = anotherConstruct.name;
        this.reference = anotherConstruct.reference;
        this.appInfo = anotherConstruct.appInfo;
        this.constructType = anotherConstruct.constructType;
        this.javaName = anotherConstruct.javaName;
        this.parent = anotherConstruct.parent;
        this.facets = this.copyMap(anotherConstruct.facets, this.facets);
        this.prefixNamespaceMap = this.copyMap(anotherConstruct.prefixNamespaceMap, this.prefixNamespaceMap);
    }

    private Map copyMap(Map mapFrom, Map mapTo) {
        if (mapFrom != null) {
            if (mapTo == null) {
                mapTo = new HashMap();
                mapTo.putAll(mapFrom);
            } else {
                Iterator facetIter = mapFrom.entrySet().iterator();
                while (facetIter.hasNext()) {
                    Map.Entry entry = facetIter.next();
                    if (mapTo.containsKey(entry.getKey())) continue;
                    mapTo.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return mapTo;
    }

    public boolean containsInFirst(String localName) {
        return false;
    }

    public static final class ConstructType {
        public static final ConstructType UNKNOWN = new ConstructType();
        public static final ConstructType TYPE = new ConstructType();
        public static final ConstructType MEMBER = new ConstructType();
        public static final ConstructType ATTRIBUTE = new ConstructType();
        public static final ConstructType ATTRGROUP = new ConstructType();

        private ConstructType() {
        }
    }
}

