/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml.schema;

import java.io.IOException;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.SchemaException;

public abstract class Facet {
    protected final String name;
    protected final String value;

    protected Facet(String name, String value) throws SchemaException {
        if (value == null) {
            throw new SchemaException("value must be specified when using facet " + name);
        }
        if (name == null) {
            throw new SchemaException("name must be specified when creating facet");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "facet " + this.name + ", value: " + this.value;
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }

    public boolean equals(Object obj) {
        Facet f = (Facet)obj;
        return this.name.equals(f.name) && this.value.equals(f.value);
    }

    public final void writeAsXML(TokenWriter writer) throws IOException {
        writer.enter("http://www.w3.org/2001/XMLSchema", this.name);
        writer.writeAttribute(null, "value", this.value);
        this.writeInnerXMLContent(writer);
        writer.leave();
    }

    protected void writeInnerXMLContent(TokenWriter writer) throws IOException {
    }

    public static class Pattern
    extends Facet {
        public static final String NAME = "pattern";

        public Pattern(String value) throws SchemaException {
            super(NAME, value);
        }
    }

    public static class WhiteSpace
    extends FixableFacet {
        public static final String NAME = "whiteSpace";

        public WhiteSpace(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static class Enumeration
    extends Facet {
        public static final String NAME = "enumeration";
        private String javaName;

        public Enumeration(String value, String javaName) throws SchemaException {
            super(NAME, value);
            this.javaName = javaName;
        }

        protected void writeInnerXMLContent(TokenWriter writer) throws IOException {
            if (!this.value.equals(this.javaName)) {
                writer.writeAttribute("http://systinet.com/mapping/", "java-field", this.javaName);
            }
        }

        public String getJavaName() {
            return this.javaName;
        }

        public String toString() {
            return "facet enumeration, value: " + this.value + ", javaName: " + this.javaName;
        }

        public void setJavaName(String javaName) {
            this.javaName = javaName;
        }
    }

    public static class MaxLength
    extends FixableFacet {
        public static final String NAME = "maxLength";

        public MaxLength(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static class MinLength
    extends FixableFacet {
        public static final String NAME = "minLength";

        public MinLength(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static class Length
    extends FixableFacet {
        public static final String NAME = "length";

        public Length(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static class FractionDigits
    extends FixableFacet {
        public static final String NAME = "fractionDigits";

        public FractionDigits(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static class TotalDigits
    extends FixableFacet {
        public static final String NAME = "totalDigits";

        public TotalDigits(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static class MaxInclusive
    extends FixableFacet {
        public static final String NAME = "maxInclusive";

        public MaxInclusive(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static class MaxExclusive
    extends FixableFacet {
        public static final String NAME = "maxExclusive";

        public MaxExclusive(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static class MinInclusive
    extends FixableFacet {
        public static final String NAME = "minInclusive";

        public MinInclusive(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static class MinExclusive
    extends FixableFacet {
        public static final String NAME = "minExclusive";

        public MinExclusive(String value, boolean fixed) throws SchemaException {
            super(NAME, value, fixed);
        }
    }

    public static abstract class FixableFacet
    extends Facet {
        protected final boolean fixed;

        protected FixableFacet(String name, String value, boolean fixed) throws SchemaException {
            super(name, value);
            this.fixed = fixed;
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public String toString() {
            return super.toString() + ", fixed: " + this.fixed;
        }

        protected final void writeInnerXMLContent(TokenWriter writer) throws IOException {
            if (this.fixed) {
                writer.writeAttribute(null, "fixed", "true");
            }
        }

        protected void writeInnerXMLContent2(TokenWriter writer) throws IOException {
        }
    }
}

