/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.IntArray;
import org.idoox.xml.StartElementArray;
import org.idoox.xml.StartElementHolder;
import org.idoox.xml.StringArray;
import org.idoox.xml.Token;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLWriterReader
implements Tokenizer,
TokenWriter {
    private static final int INITIAL_NSR_STACK_SIZE = 8;
    private static final int NSR_STACK_INCREMENT = 8;
    private StringArray contentArray = new StringArray();
    private StartElementArray elements = new StartElementArray();
    private IntArray states = new IntArray();
    int nextPrefix;
    boolean inElement;
    int currentElementPos = -1;
    String[] localNamespaces;
    int localNamespacesPos;
    String[] overwrittenNamespaces;
    int overwrittenNamespacesPos;
    public Map namespaceMap = new HashMap();
    public Map prefixMap = new HashMap();
    private byte rCurrentState;
    private int rCurrentStatePos;
    private int rCurrentElementPos = -1;
    private int rCurrentContentPos = -1;
    private int rNextElementPos;
    private boolean reportedEnd;
    private String[] rLocalNamespaces;
    int rLocalNamespacesPos;
    private String[] rOverwrittenNamespaces;
    int rOverwrittenNamespacesPos;
    private Map rPrefixMap = new HashMap();
    private String rEndElementName;
    private String rEndElementNamespace;

    public XMLWriterReader() {
        this.localNamespaces = new String[16];
        this.overwrittenNamespaces = new String[16];
        this.rLocalNamespaces = new String[16];
        this.rOverwrittenNamespaces = new String[16];
    }

    public void flush() {
    }

    public void enter(String namespace, String name) {
        if (this.currentElementPos == -2) {
            throw new IllegalStateException("Cannot create new element, top level element is already closed");
        }
        this.inElement = true;
        StartElementHolder el = new StartElementHolder(name, namespace);
        el.parentElementPos = this.currentElementPos;
        el.parentNSStackPos[0] = this.localNamespacesPos;
        el.parentNSStackPos[1] = this.overwrittenNamespacesPos;
        this.elements.add(el);
        this.currentElementPos = this.elements.getLength() - 1;
        this.states.add(2);
    }

    public void writeAttribute(String namespace, String name, String value) throws IllegalStateException {
        if (!this.inElement) {
            throw new IllegalStateException("Not in element");
        }
        String prefix = namespace != null && namespace.length() > 0 ? this.getPrefixForNamespace(namespace) : null;
        StartElementHolder el = this.elements.get(this.currentElementPos);
        el.addAttribute(name, namespace, prefix, value);
    }

    public void writeXmlAttribute(String name, String value) throws IllegalStateException {
        if (!this.inElement) {
            throw new IllegalStateException("Not in element");
        }
        StartElementHolder el = this.elements.get(this.currentElementPos);
        el.addAttribute(name, null, "xml", value);
    }

    public void writeContent(String content) throws IOException, IllegalStateException {
        if (this.currentElementPos < 0) {
            throw new IllegalStateException("Not in element");
        }
        this.inElement = false;
        this.contentArray.add(content);
        this.states.add(4);
    }

    public void leave() throws IOException, IllegalStateException {
        if (this.currentElementPos == -2) {
            throw new IllegalStateException("Already left top level element");
        }
        this.states.add(3);
        this.inElement = true;
        StartElementHolder el = this.elements.get(this.currentElementPos);
        if (el.namespace != null && el.namespace.length() > 0) {
            this.getPrefixForNamespace(el.namespace);
        }
        this.currentElementPos = el.parentElementPos;
        if (this.currentElementPos == -1) {
            this.currentElementPos = -2;
        }
        int i = el.parentNSStackPos[0];
        while (i < this.localNamespacesPos) {
            this.prefixMap.remove(this.localNamespaces[i]);
            this.namespaceMap.remove(this.localNamespaces[i + 1]);
            i += 2;
        }
        this.localNamespacesPos = el.parentNSStackPos[0];
        int i2 = el.parentNSStackPos[1];
        while (i2 < this.overwrittenNamespacesPos) {
            this.prefixMap.put(this.overwrittenNamespaces[i2], this.overwrittenNamespaces[i2 + 1]);
            this.namespaceMap.put(this.overwrittenNamespaces[i2 + 1], this.overwrittenNamespaces[i2]);
            i2 += 2;
        }
        this.overwrittenNamespacesPos = el.parentNSStackPos[1];
        this.inElement = false;
        if (el.parentElementPos == -1) {
            this.states.add(1);
            if (this.localNamespacesPos != 0 || this.overwrittenNamespacesPos != 0) {
                return;
            }
        }
    }

    public String getPrefixForNamespace(String namespace) throws IllegalStateException {
        String prefix = (String)this.namespaceMap.get(namespace);
        if (prefix != null) {
            return prefix;
        }
        prefix = "ns" + this.nextPrefix++;
        this.setPrefixForNamespace(prefix, namespace);
        return prefix;
    }

    public void setPrefixForNamespace(String prefix, String namespace) throws IllegalStateException {
        if (!this.inElement) {
            throw new IllegalStateException("Not in element");
        }
        if (prefix == null) {
            prefix = "";
        }
        if (this.localNamespacesPos >= this.localNamespaces.length) {
            this.localNamespaces = this.resizeStringArray(this.localNamespaces, this.localNamespaces.length + 16);
        }
        if (this.overwrittenNamespacesPos >= this.overwrittenNamespaces.length) {
            this.overwrittenNamespaces = this.resizeStringArray(this.overwrittenNamespaces, this.overwrittenNamespaces.length + 16);
        }
        this.localNamespaces[this.localNamespacesPos++] = prefix;
        this.localNamespaces[this.localNamespacesPos++] = namespace;
        if (this.prefixMap.containsKey(prefix)) {
            this.overwrittenNamespaces[this.overwrittenNamespacesPos++] = prefix;
            this.overwrittenNamespaces[this.overwrittenNamespacesPos++] = (String)this.prefixMap.get(prefix);
            this.namespaceMap.remove(this.prefixMap.get(prefix));
        }
        this.prefixMap.put(prefix, namespace);
        this.namespaceMap.put(namespace, prefix);
        StartElementHolder el = this.elements.get(this.currentElementPos);
        el.addNamespace(prefix, namespace);
    }

    public String getLocalName() throws TokenizerException {
        if (this.rCurrentState != 2 && this.rCurrentState != 3) {
            throw new TokenizerException("Must be in START_TOKEN or END_TOKEN state");
        }
        return this.elements.get((int)this.rCurrentElementPos).localname;
    }

    public String getNamespace() throws TokenizerException {
        if (this.rCurrentState != 2 && this.rCurrentState != 3) {
            throw new TokenizerException("Must be in START_TOKEN or END_TOKEN state");
        }
        return this.elements.get((int)this.rCurrentElementPos).namespace;
    }

    public String getNamespaceForPrefix(String prefix) {
        return (String)this.rPrefixMap.get(prefix);
    }

    public QName parseQName(String qName) {
        QName retval;
        if (qName == null || "".equals(qName)) {
            return null;
        }
        if (qName.charAt(0) == '{') {
            return QName.valueOf(qName);
        }
        int index = qName.indexOf(":");
        if (index != -1) {
            String localName = qName.substring(index + 1, qName.length());
            String prefix = qName.substring(0, index);
            String uri = (String)this.rPrefixMap.get(prefix);
            if (uri == null) {
                throw new RuntimeException("Unknown prefix " + prefix);
            }
            retval = new QName(uri, localName);
        } else {
            String uri = (String)this.rPrefixMap.get("");
            retval = new QName(uri, qName);
        }
        return retval;
    }

    public byte next() throws TokenizerException, IOException {
        if (this.reportedEnd) {
            throw new TokenizerException("Already at the end of document");
        }
        if (this.states.getLength() == this.rCurrentStatePos) {
            if (this.rCurrentStatePos == 0) {
                return 1;
            }
            StartElementHolder el = this.elements.get(this.currentElementPos);
            throw new TokenizerException("Missing end of [" + el.namespace + ":" + el.localname + "] element");
        }
        this.rCurrentState = (byte)this.states.get(this.rCurrentStatePos++);
        switch (this.rCurrentState) {
            case 2: {
                StartElementHolder el = this.elements.get(this.rNextElementPos);
                el.rParentElementPos = this.rCurrentElementPos;
                this.rCurrentElementPos = this.rNextElementPos++;
                el.rParentNSStackPos[0] = this.rLocalNamespacesPos;
                el.rParentNSStackPos[1] = this.rOverwrittenNamespacesPos;
                if (this.rLocalNamespaces.length < this.rLocalNamespacesPos + el.namespacesCount) {
                    int max = el.namespacesCount > 16 ? el.namespacesCount : 16;
                    this.rLocalNamespaces = this.resizeStringArray(this.rLocalNamespaces, this.rLocalNamespaces.length + max);
                }
                int i = 0;
                while (i < el.namespacesCount) {
                    String prefix = el.definedNamespaces[i];
                    if (this.rPrefixMap.containsKey(prefix)) {
                        if (this.rOverwrittenNamespacesPos >= this.rOverwrittenNamespaces.length) {
                            this.rOverwrittenNamespaces = this.resizeStringArray(this.rOverwrittenNamespaces, this.rOverwrittenNamespaces.length + 16);
                        }
                        String uri = (String)this.rPrefixMap.get(prefix);
                        this.rOverwrittenNamespaces[this.rOverwrittenNamespacesPos++] = prefix;
                        this.rOverwrittenNamespaces[this.rOverwrittenNamespacesPos++] = uri;
                    }
                    this.rLocalNamespaces[this.rLocalNamespacesPos++] = prefix;
                    this.rLocalNamespaces[this.rLocalNamespacesPos++] = el.definedNamespaces[i + 1];
                    this.rPrefixMap.put(prefix, el.definedNamespaces[i + 1]);
                    i += 2;
                }
                break;
            }
            case 3: {
                StartElementHolder el = this.elements.get(this.rCurrentElementPos);
                this.rCurrentElementPos = el.rParentElementPos;
                int i = el.rParentNSStackPos[0];
                while (i < this.rLocalNamespacesPos) {
                    this.rPrefixMap.remove(this.rLocalNamespaces[i]);
                    i += 2;
                }
                this.rLocalNamespacesPos = el.rParentNSStackPos[0];
                int i2 = el.rParentNSStackPos[1];
                while (i2 < this.rOverwrittenNamespacesPos) {
                    this.prefixMap.put(this.rOverwrittenNamespaces[i2], this.rOverwrittenNamespaces[i2 + 1]);
                    i2 += 2;
                }
                this.rOverwrittenNamespacesPos = el.rParentNSStackPos[1];
                this.rEndElementName = el.localname;
                this.rEndElementNamespace = el.namespace;
                break;
            }
            case 1: {
                this.reportedEnd = true;
                break;
            }
            case 4: {
                ++this.rCurrentContentPos;
            }
        }
        return this.rCurrentState;
    }

    public byte currentState() {
        return this.rCurrentState;
    }

    public String readContent() throws TokenizerException {
        if (this.rCurrentState != 4) {
            throw new TokenizerException("Not in CONTENT state");
        }
        return this.contentArray.get(this.rCurrentContentPos);
    }

    public void readToken(Token token) throws TokenizerException {
        if (this.rCurrentState == 2) {
            StartElementHolder el = this.elements.get(this.rCurrentElementPos);
            token.localName = el.localname;
            token.uri = el.namespace;
            token.type = (byte)2;
            token.ensureCapacity(el.attributesCount);
            token.attEnd = el.attributesCount;
            int i = 0;
            while (i < el.attributesCount) {
                Attribute att = token.attArr[i];
                Attribute attS = el.attributes[i];
                att.localName = attS.localName;
                att.prefix = attS.prefix;
                att.qName = attS.qName;
                att.uri = attS.uri;
                att.value = attS.value;
                ++i;
            }
        } else if (this.rCurrentState == 3) {
            token.type = (byte)3;
            token.localName = this.rEndElementName;
            token.uri = this.rEndElementNamespace;
        } else {
            throw new TokenizerException("Invalid state");
        }
    }

    public boolean whitespaceContent() throws TokenizerException {
        if (this.rCurrentState != 4) {
            throw new TokenizerException("Not in CONTENT state");
        }
        char[] content = this.contentArray.get(this.rCurrentContentPos).toCharArray();
        int i = 0;
        while (i < content.length) {
            if (!this.isS(content[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Map getCurrentPrefixMap() {
        return Collections.unmodifiableMap(this.rPrefixMap);
    }

    public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
        if (prefixes == null) {
            return 0;
        }
        int added = 0;
        StartElementHolder el = this.elements.get(this.rCurrentElementPos);
        added = el.namespacesCount / 2;
        prefixes.enlarge(prefixes.used + added);
        int aux = prefixes.used + added;
        int j = 0;
        int i = prefixes.used;
        while (i < aux) {
            prefixes.prefixes[i] = el.definedNamespaces[j * 2];
            prefixes.prefixValues[i] = el.definedNamespaces[j * 2 + 1];
            ++j;
            ++i;
        }
        prefixes.used = aux;
        return added;
    }

    public Element getDOMRepresentation(Document doc) throws TokenizerException {
        throw new UnsupportedOperationException("not supported");
    }

    private String[] resizeStringArray(String[] array, int newSize) {
        String[] newArr = new String[newSize];
        int oldSize = array.length;
        if (newSize < oldSize) {
            System.arraycopy(array, 0, newArr, 0, newSize);
        } else {
            System.arraycopy(array, 0, newArr, 0, oldSize);
        }
        return newArr;
    }

    private boolean isS(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
    }
}

