/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml;

import org.idoox.xml.Attribute;

public final class Token {
    public byte type;
    public String uri;
    public String localName;
    public int attEnd;
    public Attribute[] attArr;
    public String prefix = null;

    public byte getType() {
        return this.type;
    }

    public void clear() {
        this.type = 0;
        this.uri = "";
        this.localName = null;
        this.attEnd = 0;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespace() {
        return this.uri;
    }

    public int getAttributeCount() {
        return this.attEnd;
    }

    public String getAttributeLocalName(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].localName;
        }
        return null;
    }

    public String getAttributeNamespace(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].uri;
        }
        return null;
    }

    public String getAttributeValue(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].value;
        }
        return null;
    }

    public String getAttributeValue(String uri, String localName) {
        int i = 0;
        while (i < this.attEnd) {
            if (localName.equals(this.attArr[i].localName) && !(uri == null || uri.length() == 0 ? this.attArr[i].uri != null && this.attArr[i].uri.length() > 0 : !uri.equals(this.attArr[i].uri))) {
                return this.attArr[i].value;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.localName);
        b.append("(");
        b.append(this.uri);
        b.append(")");
        b.append(this.type == 2 ? "S" : (this.type == 3 ? "E" : "U"));
        b.append("[");
        int i = 0;
        while (i < this.attEnd) {
            if (i != 0) {
                b.append(",");
            }
            b.append(this.getAttributeLocalName(i));
            b.append("(");
            b.append(this.getAttributeNamespace(i));
            b.append(")");
            b.append("{");
            b.append(this.getAttributeValue(i));
            b.append("}");
            ++i;
        }
        b.append("]");
        return b.toString();
    }

    public Attribute getAttribute(int idx) {
        return this.attArr[idx];
    }

    public void ensureCapacity(int size) {
        int newSize = 2 * size;
        if (newSize == 0) {
            newSize = 10;
        }
        if (this.attArr == null || this.attArr.length < newSize) {
            Attribute[] newAttArr = new Attribute[newSize];
            if (this.attArr != null) {
                System.arraycopy(this.attArr, 0, newAttArr, 0, this.attEnd);
            }
            int i = this.attEnd;
            while (i < newSize) {
                newAttArr[i] = new Attribute();
                ++i;
            }
            this.attArr = newAttArr;
        }
    }

    public void writeTo(Token token) {
        token.prefix = this.prefix;
        token.localName = this.localName;
        token.type = this.type;
        token.uri = this.uri;
        if (this.attArr != null) {
            token.ensureCapacity(this.attEnd);
            int i = 0;
            while (i < this.attEnd) {
                this.attArr[i].writeTo(token.attArr[i]);
                ++i;
            }
        }
        token.attEnd = this.attEnd;
    }
}

