/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml;

import org.idoox.xml.Attribute;

class StartElementHolder {
    private static final int INITIAL_ATTR_ARRAY_SIZE = 8;
    private static final int ATTR_ARRAY_INCREMENT = 4;
    private static final int INITIAL_NSR_ARRAY_SIZE = 8;
    private static final int NSR_ARRAY_INCREMENT = 8;
    public String localname;
    public String namespace;
    public Attribute[] attributes;
    public int attributesCount;
    public String[] definedNamespaces;
    public int namespacesCount;
    public int[] parentNSStackPos = new int[2];
    public int[] rParentNSStackPos = new int[2];
    public int parentElementPos;
    public int rParentElementPos;

    public StartElementHolder(String localname, String namespace) {
        this.localname = localname;
        this.namespace = namespace;
        this.attributes = new Attribute[8];
        this.definedNamespaces = new String[16];
    }

    public void addAttribute(String name, String namespace, String prefix, String value) {
        if (this.attributesCount == this.attributes.length) {
            Attribute[] newArr = new Attribute[this.attributes.length + 4];
            System.arraycopy(this.attributes, 0, newArr, 0, this.attributes.length);
            this.attributes = newArr;
        }
        Attribute newAttr = new Attribute();
        newAttr.localName = name;
        newAttr.uri = namespace;
        newAttr.prefix = prefix;
        newAttr.qName = prefix == null || prefix.equals("") ? name : prefix + ":" + name;
        newAttr.value = value;
        this.attributes[this.attributesCount++] = newAttr;
    }

    public void addNamespace(String prefix, String namespace) {
        if (this.namespacesCount == this.definedNamespaces.length) {
            String[] newArr = new String[this.definedNamespaces.length + 16];
            System.arraycopy(this.definedNamespaces, 0, newArr, 0, this.definedNamespaces.length);
            this.definedNamespaces = newArr;
        }
        this.definedNamespaces[this.namespacesCount++] = prefix;
        this.definedNamespaces[this.namespacesCount++] = namespace;
    }
}

