/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml;

import org.idoox.xml.StartElementHolder;

class StartElementArray {
    private static final int INITIAL_ROW_SIZE = 100;
    private static final int INITIAL_ROW_COUNT = 5;
    private StartElementHolder[][] content;
    private int currentRow;
    private int currentPos;
    private int elementCount;

    public StartElementArray() {
        this(5, 100);
    }

    public StartElementArray(int initialRowCount, int initialRowSize) {
        this.content = new StartElementHolder[initialRowCount][];
        this.content[0] = new StartElementHolder[initialRowSize];
    }

    public StartElementHolder get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index < this.content[0].length) {
            return this.content[0][index];
        }
        int row = 0;
        while (row <= this.currentRow) {
            if (index < this.content[row].length) break;
            index -= this.content[row].length;
            ++row;
        }
        return this.content[row][index];
    }

    public void add(StartElementHolder element) {
        if (this.currentPos == this.content[this.currentRow].length) {
            if (this.currentRow == this.content.length - 1) {
                StartElementHolder[][] newArr = new StartElementHolder[this.content.length * 2][];
                System.arraycopy(this.content, 0, newArr, 0, this.content.length);
                this.content = newArr;
            }
            ++this.currentRow;
            this.content[this.currentRow] = new StartElementHolder[this.content[0].length << this.currentRow];
            this.currentPos = 0;
        }
        this.content[this.currentRow][this.currentPos++] = element;
        ++this.elementCount;
    }

    public int getLength() {
        return this.elementCount;
    }
}

