/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml;

import com.idoox.debug.Category;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerWrapper;

public class ElementFinalizingTokenizerWrapper
extends TokenizerWrapper {
    private static final Category dbg = Category.getCategory("org.idoox.xml.ElementFinalizingTokenizerWrapper");
    private byte state;
    private SOAPElement element;
    private static final byte START = 0;
    private static final byte END_REACHED = 1;
    private static final byte END_OF_DOCUMENT = 2;

    public ElementFinalizingTokenizerWrapper(Tokenizer tokenizer, SOAPElement element) {
        super(tokenizer);
        this.element = element;
        this.state = 0;
        this.setCurrentState(null);
    }

    public byte next() throws TokenizerException, IOException {
        switch (this.state) {
            case 0: {
                byte next = super.next();
                if (next == 1) {
                    this.state = 1;
                    TokenizerWrapper.TokenizerState tState = new TokenizerWrapper.TokenizerState(){
                        private Token t = null;
                        private Map prefixMap;

                        public Token getToken() {
                            if (this.t == null) {
                                this.t = new Token();
                                this.t.type = (byte)3;
                                Name elementName = ElementFinalizingTokenizerWrapper.this.element.getElementName();
                                this.t.localName = elementName.getLocalName();
                                this.t.uri = elementName.getURI();
                            }
                            return this.t;
                        }

                        public String getContent() {
                            return null;
                        }

                        public Map getNamespaceDeclarations() {
                            if (this.prefixMap == null) {
                                this.prefixMap = new HashMap(23);
                                Iterator it = ElementFinalizingTokenizerWrapper.this.element.getNamespacePrefixes();
                                while (it.hasNext()) {
                                    String prefix = (String)it.next();
                                    this.prefixMap.put(prefix, ElementFinalizingTokenizerWrapper.this.element.getNamespaceURI(prefix));
                                }
                            }
                            return this.prefixMap;
                        }

                        public Map getNewNamespaceDeclarations() {
                            return null;
                        }

                        public String[] getNewPrefixes() {
                            return null;
                        }
                    };
                    this.setCurrentState(tState);
                    return 3;
                }
                return next;
            }
            case 1: {
                this.state = (byte)2;
                this.setCurrentState(null);
                return 1;
            }
            case 2: {
                throw new TokenizerException("Already at the end of document");
            }
        }
        throw new RuntimeException("Never reached!");
    }
}

