/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeBase;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeParser;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeUtil;
import org.idoox.wasp.serialization.xsdbuiltin.TimeZone;

public class Time
extends DateTimeBase
implements Serializable {
    static final long serialVersionUID = 737388638875494052L;
    private int hour;
    private int min;
    private BigDecimal sec;

    public Time(int hour, int min, BigDecimal sec, TimeZone timeZone) throws DateTimeException {
        super(timeZone);
        this.hour = hour;
        this.min = min;
        this.sec = sec;
    }

    public Time(String time) throws DateTimeException {
        DateTimeParser.parseTime(time, this);
    }

    public Time(Date date) {
        this.setParams(date);
    }

    public void setParams(int hour, int min, BigDecimal sec, TimeZone timeZone) throws DateTimeException {
        super.setParams(timeZone);
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        if (!DateTimeUtil.isTimeValid(hour, min, sec.shortValue())) {
            throw new DateTimeException();
        }
    }

    public void setParams(Date date) {
        super.setDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(super.getTimeZone().toJavaUtilTimeZone());
        calendar.setTime(date);
        this.hour = calendar.get(11);
        this.min = calendar.get(12);
        int ls1000 = calendar.get(13) * 1000 + calendar.get(14);
        this.sec = new BigDecimal((double)ls1000).movePointLeft(3);
    }

    public Date toJavaUtilDate() {
        java.util.TimeZone juTimeZone = this.timeZone != null ? this.timeZone.toJavaUtilTimeZone() : java.util.TimeZone.getTimeZone("GMT+00:00");
        GregorianCalendar calendar = new GregorianCalendar(juTimeZone);
        calendar.set(0, 0, 0, this.hour, this.min, this.sec.intValue());
        int mSec = this.sec.movePointRight(3).intValue() % 1000;
        calendar.set(14, mSec);
        if (this.isNegative) {
            calendar.set(0, 0);
        } else {
            calendar.set(0, 1);
        }
        return calendar.getTime();
    }

    public int getHour() {
        return this.hour;
    }

    public int getMin() {
        return this.getMinute();
    }

    public int getMinute() {
        return this.min;
    }

    public BigDecimal getSec() {
        return this.getSecond();
    }

    public BigDecimal getSecond() {
        return this.sec;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinute(int min) {
        this.min = min;
    }

    public void setSecond(BigDecimal sec) {
        this.sec = sec;
    }

    public String toString() {
        String hourStr = DateTimeUtil.toTwoDigitStr(this.hour);
        String minStr = DateTimeUtil.toTwoDigitStr(this.min);
        String secStr = DateTimeUtil.toTwoDigitStr(this.sec);
        String ret = hourStr + ":" + minStr + ":" + secStr;
        if (this.timeZone != null) {
            ret = ret + this.timeZone.toString();
        }
        return ret;
    }
}

