/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeBase;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeParser;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeUtil;
import org.idoox.wasp.serialization.xsdbuiltin.TimeZone;

public class GYearMonth
extends DateTimeBase
implements Serializable {
    static final long serialVersionUID = -704426397804719133L;
    private int month;
    private int year;

    public GYearMonth(int year, int month, TimeZone timeZone, boolean isNegative) throws DateTimeException {
        this.setParams(year, month, timeZone, isNegative);
    }

    public GYearMonth(String gYearMonth) throws Exception {
        DateTimeParser.parseGYearMonth(gYearMonth, this);
    }

    public void setParams(int year, int month, TimeZone timeZone, boolean isNegative) throws DateTimeException {
        super.setParams(timeZone);
        this.year = year;
        this.month = this.inputMonth(month);
        this.isNegative = isNegative;
        if (!DateTimeUtil.isDateValid(year, this.month, 1)) {
            throw new DateTimeException();
        }
    }

    public String toString() {
        String yearStr = DateTimeUtil.toFourDigitStr(this.year);
        String monthStr = DateTimeUtil.toTwoDigitStr(this.month);
        String ret = yearStr + "-" + monthStr;
        if (this.timeZone != null) {
            ret = ret + this.timeZone.toString();
        }
        if (this.isNegative) {
            ret = "-" + ret;
        }
        return ret;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.outputMonth(this.month);
    }
}

