/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeBase;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeParser;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeUtil;
import org.idoox.wasp.serialization.xsdbuiltin.TimeZone;

public class GMonthDay
extends DateTimeBase
implements Serializable {
    static final long serialVersionUID = 2421853665661296866L;
    private int month;
    private int day;

    public GMonthDay(int month, int day, TimeZone timeZone) throws DateTimeException {
        this.setParams(month, day, timeZone);
    }

    public GMonthDay(String gMonthDay) throws DateTimeException {
        DateTimeParser.parseGMonthDay(gMonthDay, this);
    }

    public void setParams(int month, int day, TimeZone timeZone) throws DateTimeException {
        super.setParams(timeZone);
        this.month = this.inputMonth(month);
        this.day = day;
        if (!DateTimeUtil.isDateValid(1, this.month, day)) {
            throw new DateTimeException();
        }
    }

    public int getMonth() {
        return this.outputMonth(this.month);
    }

    public int getDay() {
        return this.day;
    }

    public String toString() {
        String monthStr = DateTimeUtil.toTwoDigitStr(this.month);
        String dayStr = DateTimeUtil.toTwoDigitStr(this.day);
        String ret = "--" + monthStr + "-" + dayStr;
        if (this.timeZone != null) {
            ret = ret + this.timeZone.toString();
        }
        return ret;
    }
}

