/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeBase;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeParser;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeUtil;
import org.idoox.wasp.serialization.xsdbuiltin.TimeZone;

public class GDay
extends DateTimeBase
implements Serializable {
    static final long serialVersionUID = 3689133316997652887L;
    private int day;

    public GDay(int day, TimeZone timeZone) throws DateTimeException {
        this.setParams(day, timeZone);
    }

    public GDay(String gDay) throws DateTimeException {
        DateTimeParser.parseGDay(gDay, this);
    }

    public void setParams(int day, TimeZone timeZone) throws DateTimeException {
        super.setParams(timeZone);
        this.day = day;
        if (!DateTimeUtil.isDayValid(day)) {
            throw new DateTimeException();
        }
    }

    public String toString() {
        String dayStr = DateTimeUtil.toTwoDigitStr(this.day);
        String ret = "---" + dayStr;
        if (this.timeZone != null) {
            ret = ret + this.timeZone.toString();
        }
        return ret;
    }

    public int getDay() {
        return this.day;
    }
}

