/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;
import java.math.BigDecimal;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeParser;

public class Duration
implements Serializable {
    static final long serialVersionUID = -5634002100116608555L;
    private int day;
    private int month;
    private int year;
    private int hour;
    private int min;
    private BigDecimal sec;
    private boolean isNegative = false;

    public Duration(int year, int month, int day, int hour, int min, BigDecimal sec, boolean isNegative) {
        this.setParams(year, month, day, hour, min, sec, isNegative);
    }

    public Duration(String duration) throws DateTimeException {
        DateTimeParser.parseDuration(duration, this);
    }

    public void setParams(int year, int month, int day, int hour, int min, BigDecimal sec, boolean isNegative) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.isNegative = isNegative;
    }

    public String toString() {
        String ret = "P";
        if (this.year != 0) {
            String yearStr = String.valueOf(this.year);
            ret = ret + yearStr + "Y";
        }
        if (this.month != 0) {
            String monthStr = String.valueOf(this.month);
            ret = ret + monthStr + "M";
        }
        if (this.day != 0) {
            String dayStr = String.valueOf(this.day);
            ret = ret + dayStr + "D";
        }
        if (this.hour != 0 || this.min != 0 || this.sec.doubleValue() != 0.0) {
            ret = ret + "T";
        }
        if (this.hour != 0) {
            String hourStr = String.valueOf(this.hour);
            ret = ret + hourStr + "H";
        }
        if (this.min != 0) {
            String minStr = String.valueOf(this.min);
            ret = ret + minStr + "M";
        }
        if (this.sec.doubleValue() != 0.0) {
            String secStr = this.sec.toString();
            ret = ret + secStr + "S";
        }
        if (this.isNegative) {
            ret = "-" + ret;
        }
        return ret;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMin() {
        return this.getMinute();
    }

    public int getMinute() {
        return this.min;
    }

    public BigDecimal getSec() {
        return this.getSecond();
    }

    public BigDecimal getSecond() {
        return this.sec;
    }

    public boolean isNegative() {
        return this.isNegative;
    }
}

