/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.math.BigDecimal;

class DateTimeUtil {
    DateTimeUtil() {
    }

    public static String toTwoDigitStr(int hour) {
        if (hour >= 10) {
            return String.valueOf(hour);
        }
        return "0" + String.valueOf(hour);
    }

    public static String toFourDigitStr(int hour) {
        if (hour >= 1000) {
            return String.valueOf(hour);
        }
        if (hour >= 100) {
            return "0" + String.valueOf(hour);
        }
        if (hour >= 10) {
            return "00" + String.valueOf(hour);
        }
        return "000" + String.valueOf(hour);
    }

    public static String toTwoDigitStr(BigDecimal val) {
        if (val.intValue() >= 10) {
            return val.toString();
        }
        return "0" + val.toString();
    }

    public static boolean isMonthValid(int month) {
        return month <= 12 && month >= 1;
    }

    public static boolean isDayValid(int day) {
        return day <= 31 && day >= 1;
    }

    public static boolean isHourValid(int hour) {
        return hour <= 23;
    }

    public static boolean isMinValid(int min) {
        return min <= 59;
    }

    public static boolean isSecValid(int sec) {
        return sec <= 60;
    }

    public static boolean isDateValid(int year, int month, int day) {
        if (year == 0) {
            return false;
        }
        if (month > 12) {
            return false;
        }
        if (day > 31) {
            return false;
        }
        if (year % 4 == 0 && month == 2 && day > 29) {
            return false;
        }
        if (year % 4 != 0 && month == 2 && day > 28) {
            return false;
        }
        return month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12 || day <= 30;
    }

    public static boolean isTimeValid(int hour, int min, int sec) {
        return DateTimeUtil.isHourValid(hour) && DateTimeUtil.isMinValid(min) && DateTimeUtil.isSecValid(sec);
    }
}

