/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.Serializable;

class DateTimeTokenType
implements Serializable {
    static final long serialVersionUID = -4063597722312841230L;
    public static final DateTimeTokenType MINUS_SIGN = new DateTimeTokenType(1, 1, "-");
    public static final DateTimeTokenType YEAR = new DateTimeTokenType(4, Integer.MAX_VALUE, "0123456789");
    public static final DateTimeTokenType MONTH = new DateTimeTokenType(2, 2, "0123456789");
    public static final DateTimeTokenType DAY = new DateTimeTokenType(2, 2, "0123456789");
    public static final DateTimeTokenType PLUSMINUS_SIGN = new DateTimeTokenType(1, 1, "+-");
    public static final DateTimeTokenType HOUR = new DateTimeTokenType(2, 2, "0123456789");
    public static final DateTimeTokenType MIN = new DateTimeTokenType(2, 2, "0123456789");
    public static final DateTimeTokenType COLON = new DateTimeTokenType(1, 1, ":");
    public static final DateTimeTokenType SEC = new DateTimeTokenType(2, Integer.MAX_VALUE, "0123456789.,");
    public static final DateTimeTokenType TIME_SEPARATOR = new DateTimeTokenType(1, 1, "T");
    public static final DateTimeTokenType DURATION_DESIGN = new DateTimeTokenType(1, 1, "P");
    public static final DateTimeTokenType DURATION_YEAR = new DateTimeTokenType(2, Integer.MAX_VALUE, "0123456789Y", 89, 89);
    public static final DateTimeTokenType DURATION_MONTH = new DateTimeTokenType(2, Integer.MAX_VALUE, "0123456789M", 77, 77);
    public static final DateTimeTokenType DURATION_DAY = new DateTimeTokenType(2, Integer.MAX_VALUE, "0123456789D", 68, 68);
    public static final DateTimeTokenType DURATION_HOUR = new DateTimeTokenType(2, Integer.MAX_VALUE, "0123456789H", 72, 72);
    public static final DateTimeTokenType DURATION_MIN = new DateTimeTokenType(2, Integer.MAX_VALUE, "0123456789M", 77, 77);
    public static final DateTimeTokenType DURATION_SEC = new DateTimeTokenType(2, Integer.MAX_VALUE, "0123456789.,S", 83, 83);
    public static final DateTimeTokenType UTC_TIMEZONE = new DateTimeTokenType(1, 1, "Z");
    int minLength;
    int maxLength;
    String chars = "";
    int endChar = -1;
    int mandatoryChar = -1;

    public DateTimeTokenType(int minLength, int maxLength, String chars) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.chars = chars;
        this.endChar = -1;
        this.mandatoryChar = -1;
    }

    public DateTimeTokenType(int minLength, int maxLength, String chars, int endChar) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.chars = chars;
        this.endChar = endChar;
        this.mandatoryChar = -1;
    }

    public DateTimeTokenType(int minLength, int maxLength, String chars, int endChar, int mandatoryChar) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.chars = chars;
        this.endChar = endChar;
        this.mandatoryChar = mandatoryChar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateTimeTokenType)) {
            return false;
        }
        DateTimeTokenType other = (DateTimeTokenType)o;
        return other.minLength == this.minLength && other.maxLength == this.maxLength && other.chars.equals(this.chars) && other.endChar == this.endChar && other.mandatoryChar == this.mandatoryChar;
    }

    public int hashCode() {
        return this.chars.hashCode();
    }

    public boolean isValidChar(int c) {
        return this.chars.indexOf(c) != -1;
    }

    public boolean isTerminatingChar(int c) {
        return this.endChar == c;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }
}

