/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp.serialization.xsdbuiltin;

import java.io.StringReader;
import java.math.BigDecimal;
import org.idoox.wasp.serialization.xsdbuiltin.Date;
import org.idoox.wasp.serialization.xsdbuiltin.DateTime;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeToken;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeTokenType;
import org.idoox.wasp.serialization.xsdbuiltin.Duration;
import org.idoox.wasp.serialization.xsdbuiltin.GDay;
import org.idoox.wasp.serialization.xsdbuiltin.GMonth;
import org.idoox.wasp.serialization.xsdbuiltin.GMonthDay;
import org.idoox.wasp.serialization.xsdbuiltin.GYear;
import org.idoox.wasp.serialization.xsdbuiltin.GYearMonth;
import org.idoox.wasp.serialization.xsdbuiltin.Time;
import org.idoox.wasp.serialization.xsdbuiltin.TimeZone;
import org.idoox.wasp.serialization.xsdbuiltin.TokenManager;

class DateTimeParser {
    DateTimeParser() {
    }

    public static void parseDate(String date, Date dateObj) throws DateTimeException {
        try {
            TokenManager tokenManager = new TokenManager(new StringReader(date));
            boolean minusSign = false;
            if (tokenManager.checkNextToken(DateTimeTokenType.MINUS_SIGN)) {
                tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
                minusSign = true;
            }
            int year = tokenManager.getNextToken(DateTimeTokenType.YEAR).toInt();
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            int month = tokenManager.getNextToken(DateTimeTokenType.MONTH).toInt();
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            int day = tokenManager.getNextToken(DateTimeTokenType.DAY).toInt();
            TimeZone timeZone = DateTimeParser.getTimeZone(tokenManager);
            dateObj.setParams(year, month - 1, day, timeZone, minusSign);
        }
        catch (Exception e) {
            throw new DateTimeException("incorrect format");
        }
    }

    public static void parseTime(String time, Time timeObj) throws DateTimeException {
        try {
            TokenManager tokenManager = new TokenManager(new StringReader(time));
            int hour = tokenManager.getNextToken(DateTimeTokenType.HOUR).toInt();
            tokenManager.getNextToken(DateTimeTokenType.COLON);
            int min = tokenManager.getNextToken(DateTimeTokenType.MIN).toInt();
            tokenManager.getNextToken(DateTimeTokenType.COLON);
            BigDecimal sec = tokenManager.getNextToken(DateTimeTokenType.SEC).toBigDecimal();
            TimeZone timeZone = DateTimeParser.getTimeZone(tokenManager);
            timeObj.setParams(hour, min, sec, timeZone);
        }
        catch (Exception e) {
            throw new DateTimeException("incorrect format");
        }
    }

    public static void parseDateTime(String dateTime, DateTime dateTimeObj) throws DateTimeException {
        try {
            TokenManager tokenManager = new TokenManager(new StringReader(dateTime));
            boolean minusSign = false;
            if (tokenManager.checkNextToken(DateTimeTokenType.MINUS_SIGN)) {
                tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
                minusSign = true;
            }
            int year = tokenManager.getNextToken(DateTimeTokenType.YEAR).toInt();
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            int month = tokenManager.getNextToken(DateTimeTokenType.MONTH).toInt();
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            int day = tokenManager.getNextToken(DateTimeTokenType.DAY).toInt();
            tokenManager.getNextToken(DateTimeTokenType.TIME_SEPARATOR);
            int hour = tokenManager.getNextToken(DateTimeTokenType.HOUR).toInt();
            tokenManager.getNextToken(DateTimeTokenType.COLON);
            int min = tokenManager.getNextToken(DateTimeTokenType.MIN).toInt();
            tokenManager.getNextToken(DateTimeTokenType.COLON);
            BigDecimal sec = tokenManager.getNextToken(DateTimeTokenType.SEC).toBigDecimal();
            TimeZone timeZone = DateTimeParser.getTimeZone(tokenManager);
            dateTimeObj.setParams(year, month - 1, day, hour, min, sec, timeZone, minusSign);
        }
        catch (Exception e) {
            throw new DateTimeException("incorrect format");
        }
    }

    public static void parseGMonth(String gMonth, GMonth gMonthObj) throws DateTimeException {
        try {
            TokenManager tokenManager = new TokenManager(new StringReader(gMonth));
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            int month = tokenManager.getNextToken(DateTimeTokenType.MONTH).toInt();
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            TimeZone timeZone = DateTimeParser.getTimeZone(tokenManager);
            gMonthObj.setParams(month - 1, timeZone);
        }
        catch (Exception e) {
            throw new DateTimeException("incorrect format");
        }
    }

    public static void parseGYear(String gYear, GYear gYearObj) throws DateTimeException {
        try {
            TokenManager tokenManager = new TokenManager(new StringReader(gYear));
            boolean minusSign = false;
            if (tokenManager.checkNextToken(DateTimeTokenType.MINUS_SIGN)) {
                tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
                minusSign = true;
            }
            int year = tokenManager.getNextToken(DateTimeTokenType.YEAR).toInt();
            TimeZone timeZone = DateTimeParser.getTimeZone(tokenManager);
            gYearObj.setParams(year, timeZone, minusSign);
        }
        catch (Exception e) {
            throw new DateTimeException("incorrect format");
        }
    }

    public static void parseGYearMonth(String gYearMonth, GYearMonth gYearMonthObj) throws DateTimeException {
        try {
            TokenManager tokenManager = new TokenManager(new StringReader(gYearMonth));
            boolean minusSign = false;
            if (tokenManager.checkNextToken(DateTimeTokenType.MINUS_SIGN)) {
                tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
                minusSign = true;
            }
            int year = tokenManager.getNextToken(DateTimeTokenType.YEAR).toInt();
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            int month = tokenManager.getNextToken(DateTimeTokenType.MONTH).toInt();
            TimeZone timeZone = DateTimeParser.getTimeZone(tokenManager);
            gYearMonthObj.setParams(year, month - 1, timeZone, minusSign);
        }
        catch (Exception e) {
            throw new DateTimeException("incorrect format");
        }
    }

    public static void parseGDay(String gDay, GDay gDayObj) throws DateTimeException {
        try {
            TokenManager tokenManager = new TokenManager(new StringReader(gDay));
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            int day = tokenManager.getNextToken(DateTimeTokenType.DAY).toInt();
            TimeZone timeZone = DateTimeParser.getTimeZone(tokenManager);
            gDayObj.setParams(day, timeZone);
        }
        catch (Exception e) {
            throw new DateTimeException("incorrect format");
        }
    }

    public static void parseGMonthDay(String gMonthDay, GMonthDay gMonthDayObj) throws DateTimeException {
        try {
            TokenManager tokenManager = new TokenManager(new StringReader(gMonthDay));
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            int month = tokenManager.getNextToken(DateTimeTokenType.MONTH).toInt();
            tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
            int day = tokenManager.getNextToken(DateTimeTokenType.DAY).toInt();
            TimeZone timeZone = DateTimeParser.getTimeZone(tokenManager);
            gMonthDayObj.setParams(month - 1, day, timeZone);
        }
        catch (Exception e) {
            throw new DateTimeException("incorrect format");
        }
    }

    public static void parseDuration(String duration, Duration durationObj) throws DateTimeException {
        try {
            TokenManager tokenManager = new TokenManager(new StringReader(duration));
            boolean minusSign = false;
            if (tokenManager.checkNextToken(DateTimeTokenType.MINUS_SIGN)) {
                tokenManager.getNextToken(DateTimeTokenType.MINUS_SIGN);
                minusSign = true;
            }
            tokenManager.getNextToken(DateTimeTokenType.DURATION_DESIGN);
            int year = 0;
            if (tokenManager.checkNextToken(DateTimeTokenType.DURATION_YEAR)) {
                year = tokenManager.getNextToken(DateTimeTokenType.DURATION_YEAR).toInt();
            }
            int month = 0;
            if (tokenManager.checkNextToken(DateTimeTokenType.DURATION_MONTH)) {
                month = tokenManager.getNextToken(DateTimeTokenType.DURATION_MONTH).toInt();
            }
            int day = 0;
            if (tokenManager.checkNextToken(DateTimeTokenType.DURATION_DAY)) {
                day = tokenManager.getNextToken(DateTimeTokenType.DURATION_DAY).toInt();
            }
            int hour = 0;
            int min = 0;
            BigDecimal sec = new BigDecimal("0");
            if (tokenManager.checkNextToken(DateTimeTokenType.TIME_SEPARATOR)) {
                tokenManager.getNextToken(DateTimeTokenType.TIME_SEPARATOR);
                if (tokenManager.checkNextToken(DateTimeTokenType.DURATION_HOUR)) {
                    hour = tokenManager.getNextToken(DateTimeTokenType.DURATION_HOUR).toInt();
                }
                if (tokenManager.checkNextToken(DateTimeTokenType.DURATION_MIN)) {
                    min = tokenManager.getNextToken(DateTimeTokenType.DURATION_MIN).toInt();
                }
                if (tokenManager.checkNextToken(DateTimeTokenType.DURATION_SEC)) {
                    sec = tokenManager.getNextToken(DateTimeTokenType.DURATION_SEC).toBigDecimal();
                }
            }
            durationObj.setParams(year, month, day, hour, min, sec, minusSign);
        }
        catch (Exception e) {
            throw new DateTimeException("incorrect format");
        }
    }

    private static TimeZone getTimeZone(TokenManager tokenManager) throws Exception {
        if (!tokenManager.hasNextToken()) {
            return null;
        }
        if (tokenManager.checkNextToken(DateTimeTokenType.UTC_TIMEZONE)) {
            return new TimeZone(0, 0);
        }
        if (!tokenManager.checkNextToken(DateTimeTokenType.PLUSMINUS_SIGN)) {
            return null;
        }
        DateTimeToken sign = tokenManager.getNextToken(DateTimeTokenType.PLUSMINUS_SIGN);
        if (!tokenManager.checkNextToken(DateTimeTokenType.HOUR)) {
            return null;
        }
        DateTimeToken hour = tokenManager.getNextToken(DateTimeTokenType.HOUR);
        if (!tokenManager.checkNextToken(DateTimeTokenType.COLON)) {
            return null;
        }
        tokenManager.getNextToken(DateTimeTokenType.COLON);
        if (!tokenManager.checkNextToken(DateTimeTokenType.MIN)) {
            return null;
        }
        DateTimeToken min = tokenManager.getNextToken(DateTimeTokenType.MIN);
        int h = hour.toInt();
        int m = min.toInt();
        if (sign.toString().equals("-")) {
            h = -h;
            m = -m;
        }
        return new TimeZone(h, m);
    }
}

