/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.wasp;

import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import org.idoox.security.Credentials;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.WaspInternalException;
import org.idoox.wasp.WaspSecurity;
import org.idoox.webservice.client.WebServiceLookupException;
import org.systinet.wasp.Wasp;
import org.systinet.wasp.webservice.IRegistry;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public final class SecurityHelper {
    public static final String HttpBasic = "HttpBasic";
    public static final String HttpDigest = "HttpDigest";
    public static final String SSL = "SSL";
    public static final String SPKM = "SPKM";
    public static final String SoapDSig = "SoapDSig";
    public static final String Kerberos = "Kerberos";
    private static boolean notBooted = true;
    private static final Map EMPTY_MAP = new HashMap(1);

    public static boolean authenticateClient(String userName, String password, String authenticationMechanism) throws NoSuchProviderException {
        if (notBooted) {
            SecurityHelper.bootWasp();
        }
        Credentials creds = null;
        try {
            creds = WaspSecurity.acquireClientCredentials(userName, password, authenticationMechanism);
            if (creds == null) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        WaspSecurity.setCredentials((ServiceClient)null, new Credentials[]{creds});
        if (authenticationMechanism != null) {
            WaspSecurity.setInitiatingProvider((ServiceClient)null, authenticationMechanism);
        }
        return true;
    }

    public static Credentials createCredentials(String userName, String password, String authenticationMechanism) throws NoSuchProviderException {
        if (notBooted) {
            SecurityHelper.bootWasp();
        }
        return WaspSecurity.acquireClientCredentials(userName, password, authenticationMechanism);
    }

    public static void authenticateClient(Object stub, Credentials[] creds) throws NoSuchProviderException {
        if (notBooted) {
            SecurityHelper.bootWasp();
        }
        IRegistry registry = (IRegistry)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
        ServiceClient sc = registry.getServiceClient(stub);
        WaspSecurity.setCredentials(sc, creds);
        if (creds != null && creds.length != 0 && creds[0] != null) {
            WaspSecurity.setInitiatingProvider(sc, creds[0].getProviderName());
        } else {
            WaspSecurity.setInitiatingProvider(sc, null);
        }
    }

    public static boolean authenticateServer(String userName, String password, String authenticationMechanism) throws NoSuchProviderException {
        Credentials creds = null;
        try {
            creds = WaspSecurity.acquireServerCredentials(userName, password, authenticationMechanism);
            if (creds == null) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        WaspSecurity.setCredentials((ServiceEndpointContext)null, new Credentials[]{creds});
        return true;
    }

    public static void setAuthenticationSecurity(Object stub) {
        if (notBooted) {
            SecurityHelper.bootWasp();
        }
        IRegistry registry = (IRegistry)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
        ServiceClient sc = registry.getServiceClient(stub);
        Credentials[] creds = WaspSecurity.getCredentials(null);
        WaspSecurity.setCredentials(sc, creds);
        String provider = null;
        try {
            provider = WaspSecurity.getInitiatingProvider((ServiceClient)null);
        }
        catch (RuntimeException e) {
            provider = null;
        }
        try {
            WaspSecurity.setInitiatingProvider(sc, provider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setAuthenticationSecurity(Object stub, String authenticationMechanism) throws NoSuchProviderException {
        if (notBooted) {
            SecurityHelper.bootWasp();
        }
        IRegistry registry = (IRegistry)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
        ServiceClient sc = registry.getServiceClient(stub);
        Credentials[] creds = WaspSecurity.getCredentials(null);
        WaspSecurity.setCredentials(sc, creds);
        WaspSecurity.setInitiatingProvider(sc, authenticationMechanism);
    }

    public static void resetAuthentication() {
        if (notBooted) {
            SecurityHelper.bootWasp();
        }
        WaspSecurity.resetCredentials();
    }

    public static String[] getAnRequirementsForEndpoint(String serverURL, String serviceEndpointPath) throws WebServiceLookupException {
        if (notBooted) {
            SecurityHelper.bootWasp();
        }
        if (serverURL.endsWith("/admin/DefaultSecurityInfo")) {
            serverURL = serverURL.substring(0, serverURL.length() - 26);
        }
        if (serverURL.endsWith("/admin/SecurityInfo")) {
            serverURL = serverURL.substring(0, serverURL.length() - 19);
        }
        return WaspSecurity.getAnRequirementsForEndpoint(serverURL, serviceEndpointPath);
    }

    private static void bootWasp() {
        try {
            Wasp.init(EMPTY_MAP);
            notBooted = false;
        }
        catch (WaspInternalException e) {
            throw new RuntimeWrappedException(e);
        }
    }
}

