/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.idoox.util.WrappedException;

public class RuntimeWrappedException
extends RuntimeException {
    private Throwable reason;

    public RuntimeWrappedException() {
        this.reason = null;
    }

    public RuntimeWrappedException(String message) {
        super(message);
        this.reason = null;
    }

    public RuntimeWrappedException(String message, Throwable reason) {
        super(message);
        this.reason = reason;
    }

    public RuntimeWrappedException(Throwable reason) {
        super(reason.getMessage());
        this.reason = reason;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream p) {
        WrappedException.StackTraceHelper.printStackTrace((Throwable)this, p);
    }

    public void printStackTrace(PrintWriter p) {
        WrappedException.StackTraceHelper.printStackTrace((Throwable)this, p);
    }

    public Throwable getException() {
        return this.reason;
    }

    public Throwable getRootException() {
        Throwable ret = this.reason;
        if (this.reason instanceof RuntimeWrappedException) {
            ret = ((RuntimeWrappedException)this.reason).getRootException();
        }
        if (this.reason instanceof WrappedException) {
            ret = ((WrappedException)this.reason).getRootException();
        }
        if (ret == null) {
            ret = this;
        }
        return ret;
    }

    public Throwable getCause() {
        return this.reason;
    }

    void printOneStackTrace(PrintWriter printer) {
        super.printStackTrace(printer);
    }

    void printOneStackTrace(PrintStream printer) {
        super.printStackTrace(printer);
    }
}

