/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.util;

import com.idoox.debug.Category;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class LongSet
implements Serializable {
    private static final long serialVersionUID = 477748573112499033L;
    protected static final Category log = Category.getCategory((class$org$idoox$util$LongSet == null ? (class$org$idoox$util$LongSet = LongSet.class$("org.idoox.util.LongSet")) : class$org$idoox$util$LongSet).getName());
    TreeSet points;
    static /* synthetic */ Class class$org$idoox$util$LongSet;

    public LongSet() {
        this.points = new TreeSet();
    }

    public LongSet(LongSet src) {
        this.points = new TreeSet(src.points);
    }

    public boolean contains(long value) {
        LongPointImpl x = new LongPointImpl(value, 0);
        if (this.points.contains(x)) {
            return true;
        }
        LongPointImpl previous = this.previousPoint(x);
        return previous != null && previous.getType() == 1;
    }

    public void add(long value) {
        LongPointImpl next;
        LongPointImpl x = new LongPointImpl(value, 0);
        if (this.points.contains(x)) {
            return;
        }
        LongPointImpl previous = this.previousPoint(x);
        if (previous != null) {
            if (previous.getType() == 1) {
                return;
            }
            if (previous.getValue() + 1L == value) {
                if (previous.getType() == 0) {
                    previous.setType((byte)1);
                    x.setType((byte)2);
                } else {
                    this.points.remove(previous);
                    x.setType((byte)2);
                }
            }
        }
        if ((next = this.nextPoint(x)) != null && value + 1L == next.getValue()) {
            if (next.getType() == 0) {
                if (x.getType() == 2) {
                    x = null;
                    next.setType((byte)2);
                } else {
                    x.setType((byte)1);
                    next.setType((byte)2);
                }
            } else if (x.getType() == 2) {
                this.points.remove(next);
                x = null;
            } else {
                next.setValue(x.getValue());
                x = null;
            }
        }
        if (x != null) {
            this.points.add(x);
        }
    }

    public void add(long from, long to) {
        if (from == to) {
            this.add(from);
        } else {
            LongPointImpl x = new LongPointImpl(from, 1);
            LongPointImpl y = new LongPointImpl(to, 2);
            LongPointImpl previous = this.previousPoint(x);
            LongPointImpl next = this.nextPoint(y);
            SortedSet<LongPointImpl> toRemove = null;
            if (previous != null) {
                toRemove = this.points.tailSet(x);
                if (next != null) {
                    toRemove = toRemove.headSet(next);
                }
            } else if (next != null) {
                toRemove = this.points.headSet(next);
            } else {
                this.points.clear();
            }
            if (toRemove != null && toRemove.size() > 0) {
                Object[] toRemoveCopy = toRemove.toArray();
                int i = 0;
                while (i < toRemoveCopy.length) {
                    this.points.remove(toRemoveCopy[i]);
                    ++i;
                }
            }
            if (previous != null) {
                if (previous.getType() == 1) {
                    x = null;
                } else if (previous.getValue() + 1L == from) {
                    if (previous.getType() == 0) {
                        previous.setType((byte)1);
                    } else {
                        this.points.remove(previous);
                    }
                    x = null;
                }
            }
            if (x != null) {
                this.points.add(x);
            }
            if (next != null) {
                if (next.getType() == 2) {
                    y = null;
                } else if (to + 1L == next.getValue()) {
                    if (next.getType() == 0) {
                        next.setType((byte)2);
                    } else {
                        this.points.remove(next);
                    }
                    y = null;
                }
            }
            if (y != null) {
                this.points.add(y);
            }
        }
    }

    public Iterator getPoints() {
        return this.points.iterator();
    }

    private LongPointImpl previousPoint(LongPoint x) {
        SortedSet<LongPoint> headSet = this.points.subSet(LongPointImpl.MIN_VALUE, x);
        LongPointImpl result = null;
        if (headSet.size() > 0) {
            result = (LongPointImpl)headSet.last();
        }
        return result;
    }

    private LongPointImpl nextPoint(LongPoint x) {
        Iterator i = this.points.tailSet(x).iterator();
        LongPointImpl result = null;
        if (i.hasNext() && (result = (LongPointImpl)i.next()).getValue() == x.getValue()) {
            result = i.hasNext() ? (LongPointImpl)i.next() : null;
        }
        return result;
    }

    public String toString() {
        if (this.points.isEmpty()) {
            return "<empty>";
        }
        StringBuffer sb = new StringBuffer(this.points.size() * 5);
        boolean first = true;
        Iterator i = this.points.iterator();
        while (i.hasNext()) {
            LongPointImpl point = (LongPointImpl)i.next();
            switch (point.type) {
                case 0: {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append('[');
                    sb.append(point.value);
                    sb.append(']');
                    break;
                }
                case 1: {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append('[');
                    sb.append(point.value);
                    sb.append('-');
                    break;
                }
                case 2: {
                    sb.append(point.value);
                    sb.append(']');
                }
            }
            if (!first) continue;
            first = false;
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.points.size());
        Iterator i = this.points.iterator();
        while (i.hasNext()) {
            LongPointImpl point = (LongPointImpl)i.next();
            out.writeLong(point.value);
            out.writeByte(point.type);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.points = new TreeSet();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            long value = in.readLong();
            byte type = in.readByte();
            this.points.add(new LongPointImpl(value, type));
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LongPointImpl
    implements LongPoint {
        private long value;
        private byte type;
        private static final LongPoint MIN_VALUE = new LongPointImpl(Long.MIN_VALUE, 0);

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public byte getType() {
            return this.type;
        }

        public void setType(byte type) {
            this.type = type;
        }

        LongPointImpl(long value, byte type) {
            this.value = value;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LongPoint) {
                return ((LongPointImpl)obj).value == this.value;
            }
            return false;
        }

        public int compareTo(Object object) {
            LongPointImpl src = (LongPointImpl)object;
            if (this.value == src.value) {
                return 0;
            }
            if (this.value > src.value) {
                return 1;
            }
            return -1;
        }
    }

    public static interface LongPoint
    extends Comparable {
        public static final byte SINGLE = 0;
        public static final byte LOWER = 1;
        public static final byte UPPER = 2;

        public long getValue();

        public byte getType();
    }
}

