/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.transport.client;

import com.idoox.transport.URIPathNormalizer;
import com.idoox.transport.util.URLDecoder;
import com.idoox.transport.util.URLEncoder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.idoox.transport.Transport;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.TransportRepository;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;
import org.idoox.wasp.Context;

public class Endpoint
implements URI {
    private static final String DEFAULT_CLIENT_SCHEME = "default";
    private URI context;
    private String endpoint;
    private String scheme;
    private String userinfo;
    private String host;
    private int port = -1;
    private String context_path;
    private String location;
    private String path;
    private String query;
    private Map paramMap;
    private String fragment;
    private boolean dirty = false;
    private boolean dirtyQuery = false;
    private boolean dirtyLocation = false;

    public Endpoint(String endpoint) throws MalformedURLException {
        this.parse(endpoint);
        this.endpoint = endpoint;
    }

    public Endpoint(String scheme, String userinfo, String host, int port, String context_path, String location) {
        this.scheme = scheme;
        this.userinfo = userinfo;
        this.host = host;
        this.port = port;
        this.context_path = context_path;
        this.location = location;
        this.parseLocation(this.location);
        this.dirty = true;
    }

    public Endpoint(String scheme, String userinfo, String host, int port, String context_path, String path, String fragment, String query) {
        this.scheme = scheme;
        this.userinfo = userinfo;
        this.host = host;
        this.port = port;
        this.context_path = context_path;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
        this.parseQuery(this.query);
        this.dirty = true;
        this.dirtyLocation = true;
    }

    public Endpoint(String scheme, String userinfo, String host, int port, String context_path, String path, String fragment, Map paramMap) {
        this.scheme = scheme;
        this.userinfo = userinfo;
        this.host = host;
        this.port = port;
        this.context_path = context_path;
        this.path = path;
        this.paramMap = paramMap;
        this.fragment = fragment;
        this.dirty = true;
        this.dirtyQuery = true;
        this.dirtyLocation = true;
    }

    public Endpoint(URI uri) {
        this.context = uri;
    }

    public Endpoint(URI context, String location) throws MalformedURLException {
        this.context = context;
        if (location != null && location.length() > 0) {
            int colon = location.indexOf(58);
            int contextColon = -1;
            if (context.getPath() != null) {
                contextColon = context.getPath().indexOf(58);
            }
            if (colon != -1 && colon > 1) {
                this.context = new Endpoint(location);
                return;
            }
            if (location.charAt(0) == '/' || colon == 1 && (location.length() > 2 && (location.charAt(2) == '\\' || location.charAt(2) == '/') || contextColon == 1 && context.getPath().charAt(0) != location.charAt(0))) {
                this.location = location;
            } else {
                int contextDelim = context.getPath().lastIndexOf(47);
                int temp = context.getPath().lastIndexOf(92);
                if (contextDelim == -1 || temp != -1 && temp > contextDelim) {
                    contextDelim = temp;
                }
                if (contextDelim == -1) {
                    this.location = location;
                } else {
                    if (colon == 1) {
                        location = location.substring(2);
                    }
                    this.location = contextDelim + 1 == context.getPath().length() ? context.getPath() + location : context.getPath().substring(0, contextDelim + 1) + location;
                }
            }
            this.parseLocation(this.location);
            this.dirty = true;
            this.dirtyLocation = true;
        }
    }

    private void parse(String endpoint) throws MalformedURLException {
        this.scheme = null;
        this.userinfo = null;
        this.host = null;
        this.port = -1;
        this.location = null;
        int index = 0;
        try {
            int temp = endpoint.indexOf(58, index);
            if (temp == -1) {
                throw new MalformedURLException("No scheme is specified.");
            }
            if (temp == index) {
                throw new MalformedURLException("Scheme can't be empty string.");
            }
            this.scheme = endpoint.substring(index, temp);
            index = temp + 1;
            boolean net_path = false;
            if (endpoint.charAt(index) == '/' && endpoint.charAt(index + 1) == '/') {
                net_path = true;
                index += 2;
            }
            if (net_path) {
                int pathIndex = endpoint.indexOf(47, index);
                if (pathIndex == -1 && endpoint.charAt(index + 1) == ':') {
                    pathIndex = index;
                }
                if ((temp = endpoint.indexOf(64, index)) != -1 && (pathIndex == -1 || temp < pathIndex)) {
                    this.userinfo = URLDecoder.decode(endpoint.substring(index, temp));
                    index = temp + 1;
                }
                if (pathIndex != -1) {
                    this.host = endpoint.substring(index, pathIndex);
                    index = pathIndex;
                } else {
                    this.host = endpoint.substring(index);
                }
                temp = this.host.indexOf(58);
                if (temp != -1) {
                    try {
                        this.port = Integer.parseInt(this.host.substring(temp + 1));
                    }
                    catch (NumberFormatException e) {
                        this.port = 0;
                    }
                    this.host = this.host.substring(0, temp);
                    if (this.port <= 0) {
                        this.port = -1;
                    }
                }
                if (pathIndex == -1) {
                    return;
                }
            }
            this.location = endpoint.substring(index);
            this.parseLocation(this.location);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
    }

    private void parseLocation(String location) {
        this.path = null;
        this.query = null;
        this.fragment = null;
        try {
            if (location == null) {
                return;
            }
            int queryIndex = location.indexOf(63);
            int fragIndex = location.indexOf(35);
            if (queryIndex == -1 && fragIndex == -1) {
                this.path = location;
                return;
            }
            if (queryIndex != -1 && fragIndex != -1) {
                if (queryIndex < fragIndex) {
                    this.path = location.substring(0, queryIndex);
                    this.query = location.substring(queryIndex + 1, fragIndex);
                    this.fragment = location.substring(fragIndex + 1);
                } else {
                    this.path = location.substring(0, fragIndex);
                    this.fragment = location.substring(fragIndex + 1, queryIndex);
                    this.query = location.substring(queryIndex + 1);
                }
                this.parseQuery(this.query);
                return;
            }
            if (queryIndex != -1) {
                this.path = location.substring(0, queryIndex);
                this.query = location.substring(queryIndex + 1);
                this.parseQuery(this.query);
                return;
            }
            if (fragIndex != -1) {
                this.path = location.substring(0, fragIndex);
                this.fragment = location.substring(fragIndex + 1);
                return;
            }
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
    }

    private void parseQuery(String query) {
        if (this.paramMap == null) {
            this.paramMap = new HashMap(13);
        } else {
            this.paramMap.clear();
        }
        if (query == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        while (tokenizer.hasMoreTokens()) {
            String name = null;
            String value = null;
            String token = tokenizer.nextToken();
            int equal = token.indexOf(61);
            if (equal != -1) {
                name = URLDecoder.decode(token.substring(0, equal));
                value = URLDecoder.decode(token.substring(equal + 1));
            } else {
                name = URLDecoder.decode(token);
            }
            ArrayList<String> values = (ArrayList<String>)this.paramMap.get(name);
            if (values == null) {
                values = new ArrayList<String>(1);
            }
            values.add(value);
            this.paramMap.put(name, values);
        }
    }

    private void create() {
        StringBuffer buffer = new StringBuffer(255);
        buffer.append(this.getScheme());
        if (this.getHost() != null) {
            buffer.append("://");
            if (this.getUserinfo() != null) {
                buffer.append(URLEncoder.encode(this.getUserinfo()));
                buffer.append('@');
            }
            buffer.append(this.getHost());
            if (this.getPort() > 0) {
                buffer.append(':');
                buffer.append(this.getPort());
            }
        } else {
            buffer.append(':');
        }
        if (this.getContextPath() != null) {
            buffer.append(this.getContextPath());
        }
        if (this.getLocation() != null) {
            buffer.append(this.getLocation());
        }
        this.endpoint = new String(buffer);
        this.dirty = false;
    }

    private void createLocation() {
        StringBuffer buffer = new StringBuffer(255);
        if (this.getPath() != null) {
            buffer.append(this.getPath());
        }
        if (this.getQuery() != null) {
            buffer.append('?');
            buffer.append(this.getQuery());
        }
        if (this.getFragment() != null) {
            buffer.append('#');
            buffer.append(this.getFragment());
        }
        this.location = new String(buffer);
        this.dirtyLocation = false;
    }

    private void createQuery() {
        StringBuffer buffer = new StringBuffer(255);
        if (this.paramMap != null) {
            boolean first = true;
            Iterator i = this.paramMap.entrySet().iterator();
            while (i.hasNext()) {
                if (!first) {
                    buffer.append('&');
                } else {
                    first = false;
                }
                Map.Entry entry = i.next();
                String name = (String)entry.getKey();
                ArrayList values = (ArrayList)entry.getValue();
                int j = 0;
                while (j < values.size()) {
                    if (j > 0) {
                        buffer.append('&');
                    }
                    buffer.append(URLEncoder.encode(name));
                    buffer.append('=');
                    buffer.append(URLEncoder.encode((String)values.get(j)));
                    ++j;
                }
            }
        }
        this.query = new String(buffer);
        this.dirtyQuery = false;
    }

    public String getScheme() {
        if (this.scheme != null) {
            return this.scheme;
        }
        if (this.context != null) {
            return this.context.getScheme();
        }
        return null;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
        this.dirty = true;
    }

    public String getUserinfo() {
        if (this.userinfo != null) {
            return this.userinfo;
        }
        if (this.context != null) {
            return this.context.getUserinfo();
        }
        return null;
    }

    public void setUserinfo(String userinfo) {
        this.userinfo = userinfo;
        this.dirty = true;
    }

    public String getHost() {
        if (this.host != null) {
            return this.host;
        }
        if (this.context != null) {
            return this.context.getHost();
        }
        return null;
    }

    public void setHost(String host) {
        this.host = host;
        this.dirty = true;
    }

    public int getPort() {
        if (this.port != -1) {
            return this.port;
        }
        if (this.context != null) {
            return this.context.getPort();
        }
        return -1;
    }

    public void setPort(int port) {
        this.port = port;
        this.dirty = true;
    }

    public String getContextPath() {
        if (this.context_path != null) {
            return this.context_path;
        }
        if (this.context != null) {
            return this.context.getContextPath();
        }
        return null;
    }

    public void setContextPath(String context_path) {
        this.context_path = context_path;
        this.dirty = true;
    }

    public String getLocation() {
        if (this.dirtyLocation) {
            this.createLocation();
        }
        if (this.location != null) {
            return this.location;
        }
        if (this.context != null) {
            return this.context.getLocation();
        }
        return null;
    }

    public void setLocation(String location) {
        this.location = location;
        this.parseLocation(this.location);
        this.dirty = true;
    }

    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.context != null) {
            return this.context.getPath();
        }
        return null;
    }

    public void setPath(String path) {
        this.path = path;
        this.dirty = true;
        this.dirtyLocation = true;
    }

    public String getQuery() {
        if (this.dirtyQuery) {
            this.createQuery();
        }
        if (this.query != null) {
            return this.query;
        }
        if (this.context != null) {
            return this.context.getQuery();
        }
        return null;
    }

    public void setQuery(String query) {
        this.query = query;
        this.parseQuery(this.query);
        this.dirty = true;
        this.dirtyLocation = true;
    }

    public Set getParameterNames() {
        if (this.paramMap != null) {
            return this.paramMap.keySet();
        }
        if (this.context != null) {
            return this.context.getParameterNames();
        }
        return null;
    }

    public String getParameter(String name) {
        if (this.paramMap != null) {
            ArrayList values = (ArrayList)this.paramMap.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            return (String)values.get(0);
        }
        if (this.context != null) {
            return this.context.getParameter(name);
        }
        return null;
    }

    private void initParameters() {
        if (this.paramMap == null) {
            if (this.context != null) {
                Set keys = this.context.getParameterNames();
                if (keys == null) {
                    this.paramMap = new HashMap(13);
                } else {
                    this.paramMap = new HashMap(keys.size() + 10);
                    Iterator i = keys.iterator();
                    while (i.hasNext()) {
                        String tmpName = (String)i.next();
                        String[] tmpValues = this.context.getParameters(tmpName);
                        if (tmpValues == null) {
                            tmpValues = new String[]{};
                        }
                        ArrayList<String> tmpList = new ArrayList<String>(tmpValues.length);
                        int j = 0;
                        while (j < tmpValues.length) {
                            tmpList.add(tmpValues[j]);
                            ++j;
                        }
                        this.paramMap.put(tmpName, tmpList);
                    }
                }
            } else {
                this.paramMap = new HashMap(13);
            }
        }
    }

    public void setParameter(String name, String value) {
        this.initParameters();
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(value);
        this.paramMap.put(name, list);
        this.dirty = true;
        this.dirtyLocation = true;
        this.dirtyQuery = true;
    }

    public String[] getParameters(String name) {
        if (this.paramMap != null) {
            ArrayList values = (ArrayList)this.paramMap.get(name);
            if (values == null) {
                return null;
            }
            return values.toArray(new String[0]);
        }
        if (this.context != null) {
            return this.context.getParameters(name);
        }
        return null;
    }

    public void setParameters(String name, String[] values) {
        this.initParameters();
        if (values == null) {
            values = new String[]{};
        }
        ArrayList<String> list = new ArrayList<String>(values.length);
        int j = 0;
        while (j < values.length) {
            list.add(values[j]);
            ++j;
        }
        this.paramMap.put(name, list);
        this.dirty = true;
        this.dirtyLocation = true;
        this.dirtyQuery = true;
    }

    public String getFragment() {
        if (this.fragment != null) {
            return this.fragment;
        }
        if (this.context != null) {
            return this.context.getFragment();
        }
        return null;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
        this.dirty = true;
        this.dirtyLocation = true;
    }

    public String toExternalForm() {
        if (this.dirty) {
            this.create();
        }
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (this.context != null) {
            return this.context.toExternalForm();
        }
        return null;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean hasHandler() {
        try {
            if (Endpoint.getTransport(this.getScheme()) != null) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    public ClientConnection newConnection(TransportMethod method) throws MalformedURLException, IOException {
        return this.newConnection(method, null);
    }

    public ClientConnection newConnection(TransportMethod method, Map properties) throws MalformedURLException, IOException {
        Transport transport = Endpoint.getTransport(this.getScheme());
        if (!transport.getMethods().contains(method)) {
            throw new IOException("The transport for '" + this.getScheme() + "' scheme doesn't " + "support method '" + method + "'");
        }
        return transport.newConnection(this, method, properties);
    }

    private static Transport getTransport(String scheme) throws MalformedURLException {
        int i;
        TransportRepository repository = (TransportRepository)Context.getInstance("org.idoox.transport.TransportRepository");
        if (repository == null) {
            return null;
        }
        boolean schemeWasFound = false;
        Transport[] transports = repository.getTransportForScheme(scheme);
        if (transports != null && transports.length > 0) {
            schemeWasFound = true;
            i = 0;
            while (i < transports.length) {
                if ((transports[i].getType() & 2) != 0 && (transports[i].getType() & 1) != 0) {
                    return transports[i];
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < transports.length) {
                if ((transports[i2].getType() & 2) != 0) {
                    return transports[i2];
                }
                ++i2;
            }
        }
        if ((transports = repository.getTransportForScheme(DEFAULT_CLIENT_SCHEME)) != null && transports.length > 0) {
            i = 0;
            while (i < transports.length) {
                if ((transports[i].getType() & 2) != 0) {
                    return transports[i];
                }
                ++i;
            }
        }
        if (!schemeWasFound) {
            throw new MalformedURLException("Transport for '" + scheme + "' scheme was not found in the transport repository");
        }
        throw new MalformedURLException("Transport for '" + scheme + "' scheme isn't " + "CLIENT transport (or it isn't configured as client)");
    }

    public int hashCode() {
        return this.toExternalForm().hashCode();
    }

    public boolean equals(Object other) {
        String path2;
        URI e2;
        block15: {
            if (other == null) {
                return false;
            }
            if (!(other instanceof URI)) {
                return false;
            }
            e2 = (URI)other;
            if (!(this.getScheme() == e2.getScheme() || this.getScheme() != null && this.getScheme().equalsIgnoreCase(e2.getScheme()))) {
                return false;
            }
            if (!(this.getUserinfo() == e2.getUserinfo() || this.getUserinfo() != null && this.getUserinfo().equalsIgnoreCase(e2.getUserinfo()))) {
                return false;
            }
            try {
                if (!(this.getHost() == e2.getHost() || this.getHost() != null && InetAddress.getByName(this.getHost()).equals(InetAddress.getByName(e2.getHost())))) {
                    return false;
                }
            }
            catch (UnknownHostException e) {
                if (this.getHost().equalsIgnoreCase(e2.getHost())) break block15;
                return false;
            }
        }
        if (this.getPort() != e2.getPort()) {
            return false;
        }
        String path1 = this.getContextPath();
        if (path1 == null) {
            path1 = "";
        }
        if ((path2 = e2.getContextPath()) == null) {
            path2 = "";
        }
        if (this.getPath() != null) {
            path1 = path1 + this.getPath();
        }
        if (e2.getPath() != null) {
            path2 = path2 + e2.getPath();
        }
        if (!path1.endsWith("/")) {
            path1 = path1 + "/";
        }
        if (!path2.endsWith("/")) {
            path2 = path2 + "/";
        }
        if (!path1.equalsIgnoreCase(path2)) {
            return false;
        }
        return this.getFragment() == e2.getFragment() || this.getFragment() != null && this.getFragment().equalsIgnoreCase(e2.getFragment());
    }

    public URI normalize() {
        String normalizedPath = URIPathNormalizer.normalize(this.path);
        if (normalizedPath == this.path) {
            return this;
        }
        Endpoint endpoint = new Endpoint(this);
        endpoint.setPath(normalizedPath);
        return endpoint;
    }
}

