/*
 * Decompiled with CFR 0.152.
 */
package javax.wsdl.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;

public abstract class WSDLFactory {
    private static final String PROPERTY_NAME = "javax.wsdl.factory.WSDLFactory";
    private static final String PROPERTY_FILE_NAME = "wsdl.properties";
    private static final String DEFAULT_FACTORY_IMPL_NAME = "com.idoox.wsdl.factory.WSDLFactoryImpl";
    private static String fullPropertyFileName = null;

    public static WSDLFactory newInstance() throws WSDLException {
        String factoryImplName = WSDLFactory.findFactoryImplName();
        return WSDLFactory.newInstance(factoryImplName);
    }

    public static WSDLFactory newInstance(String factoryImplName) throws WSDLException {
        if (factoryImplName != null) {
            Class<?> cl = null;
            ClassLoader cldr = null;
            try {
                cldr = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (cldr != null) {
                try {
                    cl = cldr.loadClass(factoryImplName);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            try {
                if (cl == null) {
                    cl = Class.forName(factoryImplName);
                }
                return (WSDLFactory)cl.newInstance();
            }
            catch (Exception e) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating factory implementation.", e);
            }
        }
        throw new WSDLException("CONFIGURATION_ERROR", "Unable to find name of factory implementation.");
    }

    public abstract Definition newDefinition();

    public abstract WSDLReader newWSDLReader();

    public abstract WSDLWriter newWSDLWriter();

    public abstract ExtensionRegistry newPopulatedExtensionRegistry();

    private static String findFactoryImplName() {
        String factoryImplName = null;
        try {
            factoryImplName = System.getProperty(PROPERTY_NAME);
            if (factoryImplName != null) {
                return factoryImplName;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String propFileName = WSDLFactory.getFullPropertyFileName();
        if (propFileName != null) {
            try {
                Properties properties = new Properties();
                File propFile = new File(propFileName);
                FileInputStream fis = new FileInputStream(propFile);
                properties.load(fis);
                fis.close();
                factoryImplName = properties.getProperty(PROPERTY_NAME);
                if (factoryImplName != null) {
                    return factoryImplName;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DEFAULT_FACTORY_IMPL_NAME;
    }

    private static String getFullPropertyFileName() {
        if (fullPropertyFileName == null) {
            try {
                String javaHome = System.getProperty("java.home");
                fullPropertyFileName = javaHome + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return fullPropertyFileName;
    }
}

