/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

public class Version
implements Comparable {
    public static final Version VERSION_1_0 = new Version("1.0");
    String version;
    int[] elements;
    int hash;

    public Version(String version) throws NumberFormatException {
        if (version == null) {
            version = "1.0";
        }
        this.version = version;
        int end = version.length();
        while (--end >= 0) {
            char c = version.charAt(end);
            if (c != '0' && c != '.') break;
        }
        int start = ++end;
        int element = 0;
        if (end > 0) {
            ++element;
            while (end > 0) {
                if (version.charAt(--end) != '.') continue;
                ++element;
            }
        }
        this.elements = new int[element];
        end = start;
        while (start >= 0) {
            if (start == 0 || version.charAt(start - 1) == '.') {
                try {
                    this.elements[--element] = Integer.parseInt(version.substring(start, end));
                }
                catch (NumberFormatException e) {
                    this.elements[element] = 0;
                }
                end = start - 1;
            }
            --start;
        }
    }

    public String toString() {
        return this.version;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int[] nArray = this.elements;
            synchronized (nArray) {
                int acc = 0;
                int i = 0;
                while (i < this.elements.length) {
                    acc = acc * 29 + this.elements[i];
                    ++i;
                }
                this.hash = acc;
            }
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object o) {
        Version v = (Version)o;
        int commonLength = Math.min(this.elements.length, v.elements.length);
        int src = 0;
        while (src < commonLength) {
            int el2;
            int el1 = this.elements[src];
            if (el1 > (el2 = v.elements[src++])) {
                return 1;
            }
            if (el1 >= el2) continue;
            return -1;
        }
        if (this.elements.length > commonLength) {
            return 1;
        }
        return 0;
    }
}

