/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import com.idoox.debug.Category;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.server.PortTypeHandlerClassMapper;
import com.idoox.wasp.server.ServiceRegistry;
import com.idoox.wasp.server.WebServiceContextImpl;
import com.idoox.wasp.server.adaptor.InstanceNumberLimitor;
import com.idoox.wasp.server.adaptor.InstanceNumberLimitorImpl;
import com.idoox.wasp.server.config.ServiceInstanceConfig;
import com.systinet.wasp.monitoring.events.LogEventServiceStart;
import com.systinet.wasp.monitoring.events.LogEventServiceStop;
import com.systinet.wasp.webservice.AttributesImpl;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.InstanceNameGenerator;
import com.systinet.wasp.webservice.RegistryImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import com.systinet.wasp.webservice.ServiceInstanceContextImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.server.InvalidStateTransitionException;
import org.idoox.wasp.server.TimeoutExpiredException;
import org.idoox.wasp.server.WSRegistry;
import org.idoox.webservice.server.Startable;
import org.systinet.monitoring.EventManager;
import org.systinet.wasp.webservice.Attributes;
import org.systinet.wasp.webservice.Initializable;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.wasp.webservice.ServiceInstance;
import org.systinet.wasp.webservice.ServiceInstanceContext;

public class ServiceInstanceImpl
extends ServiceInstance {
    private static final Category cat = Category.getCategory("com.systinet.wasp.webservice.ServiceInstanceImpl");
    private Object implementationObject;
    private String name;
    private Class implementationClass;
    private Category debugLog;
    private ServiceInstanceContext serviceInstanceCtx;
    private int instantiationMethod;
    private long ttl = -1L;
    private volatile int state = 2;
    private volatile boolean destroyed = false;
    private volatile boolean initialized = false;
    private Map activeRequests = new HashMap();
    private int activeRequestsCount;
    private Configurable configurable;
    private String implementationClassName;
    private ServiceRegistry serviceRegistry;
    private int maxInstances = -1;
    private InstanceNumberLimitorImpl inl;
    private boolean registered;
    private Attributes attributes;
    private Vector urls = new Vector();
    private PortTypeHandlerClassMapper handlerClassMapper;
    private ClassSpace classSpace;
    static /* synthetic */ Class class$com$systinet$wasp$ServiceManagerImpl;
    static /* synthetic */ Class class$com$systinet$wasp$webservice$ServiceInstanceImpl;
    static /* synthetic */ Class class$org$systinet$wasp$webservice$IRegistry;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceInstanceConfig;
    static /* synthetic */ Class class$org$systinet$wasp$webservice$ICurrent;

    public ServiceInstanceImpl(Object implementationObject) {
        this.init(implementationObject, null, null, null, null);
    }

    public ServiceInstanceImpl(Class implementationClass) {
        this.init(null, implementationClass, null, null, null);
    }

    public ServiceInstanceImpl(String implementationClassName) {
        this.init(null, null, implementationClassName, null, null);
    }

    public ServiceInstanceImpl(Object implementationObject, Configurable config, String name) {
        this.init(implementationObject, null, null, config, name);
    }

    private void init(Object implementationObject, Class implementationClass, String implementationClassName, Configurable config, String name) {
        this.implementationObject = implementationObject;
        this.implementationClass = implementationClass;
        this.implementationClassName = implementationClassName;
        this.configurable = config == null ? Configurator.newRuntimeConfigurable() : config;
        this.name = name == null ? this.constructName() : name;
        this.handlerClassMapper = new PortTypeHandlerClassMapper(this.classSpace, config);
        this.serviceRegistry = new ServiceRegistry(this.ttl);
        this.inl = new InstanceNumberLimitorImpl();
        this.inl.init(this.maxInstances);
        this.inl.registerAsLifecycleController(this.serviceRegistry);
        this.serviceRegistry.registerService(this, true);
        this.serviceInstanceCtx = new ServiceInstanceContextImpl(this);
    }

    private String constructName() {
        String ret = null;
        if (this.implementationObject != null) {
            ret = InstanceNameGenerator.generateName(this.implementationObject);
        } else if (this.implementationClass != null) {
            ret = InstanceNameGenerator.generateName(this.implementationClass);
        } else if (this.implementationClassName != null) {
            ret = InstanceNameGenerator.generateName(this.implementationClassName);
        }
        return ret;
    }

    public Category getDebugCategory() {
        if (this.debugLog == null) {
            this.debugLog = this.implementationObject == null ? Category.getCategory(this.implementationClass.getName()) : Category.getCategory(this.implementationObject.getClass().getName());
            this.debugLog.setInstanceDebugLevel(3);
            this.debugLog.setFireUserEvent(true);
        }
        return this.debugLog;
    }

    public synchronized Configurable getConfigurable() {
        return this.configurable;
    }

    public synchronized ServiceInstanceContext getContext() {
        return this.serviceInstanceCtx;
    }

    public synchronized Object getImplementationObject() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.implementationObject == null) {
            ClassLoader classLoader = this.classSpace != null ? this.classSpace.getClassLoader() : (class$com$systinet$wasp$ServiceManagerImpl == null ? (class$com$systinet$wasp$ServiceManagerImpl = ServiceInstanceImpl.class$("com.systinet.wasp.ServiceManagerImpl")) : class$com$systinet$wasp$ServiceManagerImpl).getClassLoader();
            this.implementationObject = ServiceInstanceImpl.getRegistry().invokeListenersOnObtainImplamentation(this.getImplementationClassName(), classLoader);
        }
        if (this.implementationObject != null && !this.isInitialized()) {
            this.initialize();
        }
        return this.implementationObject;
    }

    public synchronized Class getImplementationClass() throws ClassNotFoundException {
        if (this.implementationClass == null) {
            if (this.implementationObject != null) {
                this.implementationClass = this.implementationObject.getClass();
            } else if (this.implementationClassName != null) {
                ClassLoader classLoader = this.classSpace != null ? this.classSpace.getClassLoader() : (class$com$systinet$wasp$webservice$ServiceInstanceImpl == null ? (class$com$systinet$wasp$webservice$ServiceInstanceImpl = ServiceInstanceImpl.class$("com.systinet.wasp.webservice.ServiceInstanceImpl")) : class$com$systinet$wasp$webservice$ServiceInstanceImpl).getClassLoader();
                this.implementationClass = Class.forName(this.implementationClassName, false, classLoader);
            }
        }
        return this.implementationClass;
    }

    public synchronized Class getImplementationClassIfKnown() {
        return this.implementationClass;
    }

    public synchronized Object getImplementationObjectIfKnown() {
        return this.implementationObject;
    }

    public synchronized String getImplementationClassName() {
        if (this.implementationClassName == null) {
            if (this.implementationClass != null) {
                this.implementationClassName = this.implementationClass.getName();
            } else if (this.implementationObject != null) {
                this.implementationClassName = this.implementationObject.getClass().getName();
            }
        }
        return this.implementationClassName;
    }

    public synchronized void setImplementationClassName(String className) {
        this.implementationClassName = className;
    }

    private static RegistryImpl getRegistry() {
        return (RegistryImpl)Context.getInstance(class$org$systinet$wasp$webservice$IRegistry == null ? (class$org$systinet$wasp$webservice$IRegistry = ServiceInstanceImpl.class$("org.systinet.wasp.webservice.IRegistry")) : class$org$systinet$wasp$webservice$IRegistry);
    }

    public synchronized int getInstantiationMethod() {
        if (!this.isInitialized()) {
            return this.instantiationMethod;
        }
        ServiceEndpoint[] registrations = ServiceInstanceImpl.getRegistry().getServiceEndpoints(this);
        return ((ServiceEndpointImpl)registrations[0]).isAutomaticallyInstantiated() ? 1 : 0;
    }

    public synchronized void setInstantiationMethod(int instantiationMethod) throws IllegalStateException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Service instance is already initialized");
        }
        this.instantiationMethod = instantiationMethod;
    }

    public synchronized long getTTL() {
        return this.ttl;
    }

    public synchronized void setTTL(long seconds) {
        this.ttl = seconds;
        this.serviceRegistry.setTTLforAllInstances(seconds);
    }

    public synchronized int getMaxInstances() {
        return this.maxInstances;
    }

    public synchronized void setMaxInstances(int maxInstances) {
        this.maxInstances = maxInstances;
        this.inl.setMaxInstances(maxInstances);
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized void disable() throws InvalidStateTransitionException {
        if (!this.isRegistered()) {
            throw new IllegalStateException("Service instance is not registered yet.");
        }
        if (this.getState() == 1) {
            return;
        }
        if (this.getState() == 32) {
            return;
        }
        if (!ServiceInstanceImpl.serviceInstanceCanBeDisabled(this.getState())) {
            throw new InvalidStateTransitionException("Service must be offline, enabled or active to be disabled");
        }
        if (this.getState() != 2) {
            ServiceInstanceImpl serviceInstanceImpl = this;
            synchronized (serviceInstanceImpl) {
                this.setState(32);
                this.notifyAll();
            }
        }
        ServiceDestroyingThread sdThread = new ServiceDestroyingThread();
        sdThread.setName("DestroyerOf" + this.getImplementationClassName());
        Map map = ServiceInstanceImpl.getRegistry().serviceInstanceToDestroyingThread;
        synchronized (map) {
            ServiceInstanceImpl.getRegistry().serviceInstanceToDestroyingThread.put(this, sdThread);
        }
        sdThread.start();
    }

    public synchronized boolean isRegistered() {
        return this.registered;
    }

    public synchronized void setRegistered() {
        this.registered = true;
    }

    public synchronized void enable() throws InvalidStateTransitionException {
        if (!this.isRegistered()) {
            throw new IllegalStateException("Service instance is not registered yet.");
        }
        if (!ServiceInstanceImpl.serviceInstanceCanBeEnabled(this.getState())) {
            return;
        }
        String serviceName = this.getName();
        this.setState(64);
        this.notifyAll();
        ServiceInitializationThread siThread = new ServiceInitializationThread();
        siThread.setName("InitializerOf" + this.getImplementationClassName());
        ServiceInstanceImpl.getRegistry().serviceInstanceToInitializingThread.put(this, siThread);
        siThread.start();
    }

    public synchronized void kill() throws InvalidStateTransitionException {
        if (!this.isRegistered()) {
            throw new IllegalStateException("Service instance is not registered yet.");
        }
        int state = this.getState();
        switch (state) {
            case 32: {
                this.killAllRequests();
                Map map = ServiceInstanceImpl.getRegistry().serviceInstanceToDestroyingThread;
                synchronized (map) {
                    Thread destroyer = (Thread)ServiceInstanceImpl.getRegistry().serviceInstanceToDestroyingThread.get(this);
                    if (destroyer != null) {
                        destroyer.stop();
                        ServiceInstanceImpl.getRegistry().serviceInstanceToDestroyingThread.remove(this);
                    }
                }
                this.setState(1);
                this.notifyAll();
                break;
            }
            case 64: {
                Map map = ServiceInstanceImpl.getRegistry().serviceInstanceToInitializingThread;
                synchronized (map) {
                    Thread initializer = (Thread)ServiceInstanceImpl.getRegistry().serviceInstanceToInitializingThread.get(this);
                    if (initializer != null) {
                        initializer.stop();
                        ServiceInstanceImpl.getRegistry().serviceInstanceToInitializingThread.remove(this);
                    }
                }
                this.setState(1);
                this.notifyAll();
                break;
            }
            case 8: {
                this.killAllRequests();
                this.setState(1);
                this.notifyAll();
                break;
            }
            default: {
                this.setState(1);
                this.notifyAll();
            }
        }
    }

    public void waitForState(int states) throws InterruptedException {
        this.waitForState(states, -1L);
    }

    public boolean waitForState(int states, long timeout) throws InterruptedException {
        boolean res = false;
        try {
            ServiceInstanceImpl.getRegistry().waitForState(this, states, timeout);
            res = true;
        }
        catch (TimeoutExpiredException e) {
            res = false;
        }
        return res;
    }

    public synchronized String getResource(String path) {
        String ret = null;
        if (this.configurable != null && this.configurable.isPersistent()) {
            String rootPath = this.configurable.getReferenceLocation();
            if (rootPath != null) {
                ret = path.startsWith("/") ? rootPath + path : rootPath + "/" + path;
                try {
                    URL test = new URL(ret);
                    if (!new File(test.getFile()).exists()) {
                        return null;
                    }
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        } else {
            try {
                ClassLoader cl;
                URL res;
                if (!path.equals("/") && (res = (cl = this.getImplementationClass().getClassLoader()).getResource(path)) != null) {
                    ret = res.toExternalForm();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ret;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        String resource = this.getResource(path);
        if (resource == null) {
            return null;
        }
        URL url = new URL(resource);
        return new FileInputStream(url.getFile());
    }

    public void log(String message) {
        this.getDebugCategory().info(message);
    }

    public void log(String message, Throwable throwable) {
        this.getDebugCategory().error(message, throwable);
    }

    public synchronized void setImplementationClass(Class implementationClass) throws IllegalStateException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Service instance is already initialized");
        }
        this.implementationClass = implementationClass;
    }

    public synchronized void setImplementationObject(Object implementationObject) throws IllegalStateException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Service instance is already initialized");
        }
        this.implementationObject = implementationObject;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    private synchronized void setInitialized() {
        this.initialized = true;
        this.destroyed = false;
    }

    public void killAllRequests() {
        Iterator it = this.activeRequests.keySet().iterator();
        while (it.hasNext()) {
            ArrayList list = (ArrayList)this.activeRequests.get(it.next());
            Iterator it1 = ((AbstractList)list).iterator();
            while (it1.hasNext()) {
                Thread t = (Thread)it1.next();
                try {
                    t.stop();
                }
                catch (Throwable e) {
                    cat.debug(e);
                }
                --this.activeRequestsCount;
            }
            list.clear();
        }
        if (this.activeRequestsCount != 0) {
            // empty if block
        }
    }

    public synchronized int getRequestsCount() {
        return this.activeRequestsCount;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
        this.initialized = false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        return sb.toString();
    }

    public synchronized void setConfigurable(Configurable configurable) {
        this.configurable = configurable;
        this.handlerClassMapper = new PortTypeHandlerClassMapper(this.classSpace, configurable);
    }

    public void addURL(String url) {
        this.urls.add(url);
    }

    public Vector getURLs() {
        return this.urls;
    }

    public Object getInstanceForPortType(QName portType, WSRegistry registry) {
        return this.handlerClassMapper.getInstanceForPortType(portType, registry);
    }

    public Object createInstanceForPortType(QName portType, WSRegistry registry) {
        return this.handlerClassMapper.createInstanceForPortType(portType, registry);
    }

    public void setClassSpace(ClassSpace classSpace) {
        this.classSpace = classSpace;
        this.handlerClassMapper = new PortTypeHandlerClassMapper(classSpace, this.configurable);
    }

    public ClassSpace getClassSpace() {
        return this.classSpace;
    }

    public void addRequest(String url, Thread thread) {
        ArrayList<Thread> list = (ArrayList<Thread>)this.activeRequests.get(url);
        if (list == null) {
            list = new ArrayList<Thread>();
            this.activeRequests.put(url, list);
        }
        list.add(thread);
        ++this.activeRequestsCount;
    }

    public void removeRequest(String url, Thread thread) {
        Map map = this.activeRequests;
        synchronized (map) {
            ArrayList list = (ArrayList)this.activeRequests.get(url);
            if (list == null) {
                return;
            }
            if (!((AbstractCollection)list).remove(thread)) {
                return;
            }
            --this.activeRequestsCount;
            this.activeRequests.notifyAll();
        }
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public Configurable getInstanceConfig() {
        Configurable config = Configurator.newRuntimeConfigurable();
        ServiceInstanceConfig cfg = (ServiceInstanceConfig)config.narrow(class$com$idoox$wasp$server$config$ServiceInstanceConfig == null ? (class$com$idoox$wasp$server$config$ServiceInstanceConfig = ServiceInstanceImpl.class$("com.idoox.wasp.server.config.ServiceInstanceConfig")) : class$com$idoox$wasp$server$config$ServiceInstanceConfig);
        cfg.setClassName(this.implementationClassName);
        if (this.classSpace != null) {
            cfg.setClassSpace(this.classSpace.getName());
        }
        cfg.setName(this.name);
        return Configurator.getConfigurable(cfg);
    }

    private void initialize() {
        if (!this.isInitialized()) {
            CurrentImpl current = (CurrentImpl)Context.getInstance(class$org$systinet$wasp$webservice$ICurrent == null ? (class$org$systinet$wasp$webservice$ICurrent = ServiceInstanceImpl.class$("org.systinet.wasp.webservice.ICurrent")) : class$org$systinet$wasp$webservice$ICurrent);
            CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
            ServiceEndpointContext oldServiceEndpointContext = threadLocals.serviceEndpointContext;
            ServiceInstanceContext oldServiceInstanceContext = threadLocals.serviceInstanceContext;
            ServiceClientContext oldServiceClientContext = threadLocals.serviceClientContext;
            int oldProcessingType = threadLocals.processingType;
            threadLocals.serviceInstanceContext = this.serviceInstanceCtx;
            threadLocals.serviceEndpointContext = null;
            threadLocals.serviceClientContext = null;
            if (this.implementationObject instanceof Initializable) {
                ((Initializable)this.implementationObject).init(this);
            } else if (this.implementationObject instanceof org.idoox.webservice.server.Initializable) {
                ServiceInstance si = this.serviceInstanceCtx.getServiceInstance();
                WebServiceContextImpl oldContext = new WebServiceContextImpl(si.toString(), this.serviceInstanceCtx);
                ((org.idoox.webservice.server.Initializable)this.implementationObject).init(oldContext);
            }
            if (this.implementationObject instanceof Startable) {
                ((Startable)this.implementationObject).start();
            }
            this.setInitialized();
            threadLocals.serviceInstanceContext = oldServiceInstanceContext;
            threadLocals.serviceEndpointContext = oldServiceEndpointContext;
            threadLocals.serviceClientContext = oldServiceClientContext;
            threadLocals.processingType = oldProcessingType;
        }
    }

    private static boolean serviceInstanceCanBeEnabled(int serviceState) {
        return serviceState == 1 || serviceState == 2;
    }

    private static boolean serviceInstanceCanBeDisabled(int serviceState) {
        return serviceState == 4 || serviceState == 2 || serviceState == 8 || serviceState == 32;
    }

    public synchronized InstanceNumberLimitor getInstanceNumberLimitor() {
        return this.inl;
    }

    public synchronized ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public Attributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttributesImpl();
        }
        return this.attributes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ServiceDestroyingThread
    extends Thread {
        private ServiceDestroyingThread() {
        }

        public void run() {
            Map map = ServiceInstanceImpl.this.activeRequests;
            synchronized (map) {
                try {
                    while (ServiceInstanceImpl.this.activeRequestsCount > 0) {
                        ServiceInstanceImpl.this.activeRequests.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            EventManager.fireEvent(new LogEventServiceStop(ServiceInstanceImpl.this.getName()));
            ServiceInstanceImpl.this.serviceRegistry.destroy();
            Map map2 = ServiceInstanceImpl.getRegistry().serviceInstanceToDestroyingThread;
            synchronized (map2) {
                ServiceInstanceImpl.getRegistry().serviceInstanceToDestroyingThread.remove(ServiceInstanceImpl.this);
            }
            ServiceInstanceImpl serviceInstanceImpl = ServiceInstanceImpl.this;
            synchronized (serviceInstanceImpl) {
                ServiceInstanceImpl.this.setState(1);
                ServiceInstanceImpl.this.notifyAll();
            }
        }
    }

    private class ServiceInitializationThread
    extends Thread {
        private ServiceInitializationThread() {
        }

        public void run() {
            try {
                try {
                    ServiceInstanceImpl.this.getImplementationObject();
                    ServiceInstanceImpl serviceInstanceImpl = ServiceInstanceImpl.this;
                    synchronized (serviceInstanceImpl) {
                        ServiceInstanceImpl.this.setState(4);
                        ServiceInstanceImpl.this.notifyAll();
                        EventManager.fireEvent(new LogEventServiceStart(ServiceInstanceImpl.this.getName()));
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                        Object var5_3 = null;
                        this.releaseResources();
                        return;
                    }
                }
                catch (ClassNotFoundException ignore) {
                    this.setToDisabled();
                    throw new RuntimeWrappedException("Unable to initialize service instance", ignore);
                }
                catch (InstantiationException ignore) {
                    this.setToDisabled();
                    throw new RuntimeWrappedException("Unable to initialize service instance", ignore);
                }
                catch (IllegalAccessException ignore) {
                    this.setToDisabled();
                    throw new RuntimeWrappedException("Unable to initialize service instance", ignore);
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.releaseResources();
                throw throwable;
            }
        }

        private void setToDisabled() {
            ServiceInstanceImpl serviceInstanceImpl = ServiceInstanceImpl.this;
            synchronized (serviceInstanceImpl) {
                ServiceInstanceImpl.this.setState(1);
                this.releaseResources();
                ServiceInstanceImpl.this.notifyAll();
                EventManager.fireEvent(new LogEventServiceStop(ServiceInstanceImpl.this.getName()));
            }
        }

        private void releaseResources() {
            Map map;
            Map map2 = map = ServiceInstanceImpl.getRegistry().serviceInstanceToInitializingThread;
            synchronized (map2) {
                map.remove(ServiceInstanceImpl.this);
            }
        }
    }
}

