/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import com.systinet.wasp.ServiceManagerImpl;
import com.systinet.wasp.rpc.handler.SOAPMessageContextFactory;
import com.systinet.wasp.webservice.CallContextImpl;
import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import org.idoox.wasp.Context;
import org.systinet.logging.Category;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.rpc.handler.Bookmark;
import org.systinet.wasp.rpc.handler.ServerBookmark;
import org.systinet.wasp.rpc.handler.soap.WaspSOAPMessageContext;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;

public class ServerBookmarkImpl
extends ServerBookmark {
    private HandlerRepository.DirectionPositionEntry position;
    private String path;
    private static final ServiceManagerImpl registry = (ServiceManagerImpl)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
    private static final Category dbg = Category.getCategory("com.systinet.wasp.webservice.ServerBookmarkImpl");

    public ServerBookmarkImpl(HandlerRepository.DirectionPositionEntry position) {
        this.position = position;
        this.path = Current.getServiceEndpointContext().getServiceEndpoint().getPath();
    }

    private ServerBookmarkImpl(ServerBookmarkImpl serverBookmark) {
        super(serverBookmark);
        this.position = serverBookmark.position;
        this.path = serverBookmark.path;
    }

    public synchronized Bookmark.InvocationState handleInput(Bookmark.InvocationState invocationState) {
        Bookmark.InvocationState invocationState2;
        Map contextProperties = invocationState.getMessageProperties();
        if (contextProperties == null) {
            contextProperties = this.getCurrentState().getMessageContextProperties();
        }
        this.getCurrentState().applyToCurrentThread(invocationState.getCallContext(), contextProperties);
        try {
            SOAPMessageContext soapMessageContext = SOAPMessageContextFactory.newInstance();
            soapMessageContext.setMessage(invocationState.getMessage());
            ((WaspSOAPMessageContext)soapMessageContext).initProperties(contextProperties);
            WaspSOAPMessageContext responseMessageContext = (WaspSOAPMessageContext)registry.dispatch(soapMessageContext, this.path, this.position, true, false, invocationState.isFault());
            if (responseMessageContext != null) {
                boolean hasFault = false;
                try {
                    hasFault = ((WaspInternalSOAPMessage)soapMessageContext.getMessage()).hasFault();
                }
                catch (SOAPException e) {
                    dbg.error("Unexpected exception", e);
                }
                Bookmark.InvocationState invocationState3 = new Bookmark.InvocationState((CallContext)((CallContextImpl)Current.getCallContext()).clone(), responseMessageContext.getProperties(), responseMessageContext.getMessage(), hasFault);
                Object var8_9 = null;
                return invocationState3;
            }
            invocationState2 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            throw throwable;
        }
        Object var8_10 = null;
        return invocationState2;
    }

    public synchronized Bookmark.InvocationState handleOutput(Bookmark.InvocationState invocationState) throws RemoteException {
        return this.handleOutputInternal(invocationState, false);
    }

    public synchronized Bookmark.InvocationState handleShortOutput(Bookmark.InvocationState invocationState) {
        return this.handleOutputInternal(invocationState, true);
    }

    private final synchronized Bookmark.InvocationState handleOutputInternal(Bookmark.InvocationState invocationState, boolean isShort) {
        Bookmark.InvocationState invocationState2;
        Map contextProperties = invocationState.getMessageProperties();
        if (contextProperties == null) {
            contextProperties = this.getCurrentState().getMessageContextProperties();
        }
        this.getCurrentState().applyToCurrentThread(invocationState.getCallContext(), contextProperties);
        try {
            SOAPMessageContext soapMessageContext = SOAPMessageContextFactory.newInstance();
            soapMessageContext.setMessage(invocationState.getMessage());
            ((WaspSOAPMessageContext)soapMessageContext).initProperties(contextProperties);
            WaspSOAPMessageContext responseMessageContext = (WaspSOAPMessageContext)registry.dispatch(soapMessageContext, this.path, this.position, false, isShort, invocationState.isFault());
            if (isShort && responseMessageContext != null) {
                Bookmark.InvocationState invocationState3 = new Bookmark.InvocationState((CallContext)((CallContextImpl)Current.getCallContext()).clone(), responseMessageContext.getProperties(), responseMessageContext.getMessage());
                Object var9_7 = null;
                this.getCurrentState().restoreCurrentThread();
                return invocationState3;
            }
            invocationState2 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.getCurrentState().restoreCurrentThread();
            throw throwable;
        }
        Object var9_8 = null;
        this.getCurrentState().restoreCurrentThread();
        return invocationState2;
    }

    public Bookmark.InvocationState handleShortInput(Bookmark.InvocationState invocationState) {
        dbg.error("This methos should be never called: handleShortInput()");
        return null;
    }

    public void oneWayAck(String correlationId) {
        dbg.error("This methos should be never called: oneWayAck()");
    }

    public synchronized Object clone() {
        return new ServerBookmarkImpl(this);
    }
}

