/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.webservice;

import com.idoox.debug.Category;
import com.idoox.xmlrpc.header.HPInstance;
import com.idoox.xmlrpc.header.HeaderProcessorChain;
import com.idoox.xmlrpc.header.HeaderProcessorChainImpl;
import com.idoox.xmlrpc.header.HeaderProcessorRepositoryImpl;
import com.systinet.wasp.webservice.PostRegistrable;
import com.systinet.wasp.webservice.WASPConfigurationImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.Context;
import org.idoox.xmlrpc.header.Header;
import org.idoox.xmlrpc.header.HeaderProcessor;
import org.idoox.xmlrpc.header.Schema;
import org.systinet.wasp.webservice.HeaderProcessors;

public abstract class HeaderProcessorsImpl
implements HeaderProcessors,
PostRegistrable,
Cloneable {
    private static final Category log = Category.getCategory("com.systinet.wasp.webservice.HeaderProcessorsImpl");
    protected static final short INITIAL_SIZE = 5;
    protected List dirtyHeaderProcessors;
    protected ArrayList order = new ArrayList(0);
    protected HeaderProcessorRepositoryImpl hpRepo;
    protected WASPConfigurationImpl waspConfiguration;
    private static final HPInstance.Schema[] EMPTY_SCHEMATA = new HPInstance.Schema[0];
    private static final HPInstance.Header[] EMPTY_HEADERS = new HPInstance.Header[0];
    protected static final HeaderProcessorEntry[] EMPTY_HPE_ARRAY = new HeaderProcessorEntry[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final List EMPTY_LIST = new ArrayList(0);
    protected String headersID;
    protected boolean registrated = false;
    static /* synthetic */ Class class$com$systinet$wasp$webservice$HeaderProcessorsImpl;

    public HeaderProcessorsImpl() {
        try {
            this.waspConfiguration = (WASPConfigurationImpl)Context.getInstance("com.systinet.wasp.WASPConfigurationImpl");
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unsupported repository implementation! (" + e.getMessage() + ")");
        }
        try {
            this.hpRepo = (HeaderProcessorRepositoryImpl)Context.getInstance("com.idoox.xmlrpc.header.HeaderProcessorRepository");
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unsupported repository implementation! (" + e.getMessage() + ")");
        }
        this.dirtyHeaderProcessors = new ArrayList(5);
        if (this.isRegistered()) {
            this.order = this.getDDOrder();
        }
    }

    public HeaderProcessor get(int position) throws IndexOutOfBoundsException {
        if (this.isRegistered()) {
            String[] confNames = this.viewAsOneChain();
            this.checkSize(position, confNames.length);
            String confName = confNames[position];
            return this.hpRepo.getHPInstance(confName);
        }
        this.checkSize(position, this.dirtyHeaderProcessors.size());
        HeaderProcessorEntry entry = (HeaderProcessorEntry)this.dirtyHeaderProcessors.get(position);
        return entry.headerProcessor;
    }

    public int getDirection(int position) throws IndexOutOfBoundsException {
        if (this.isRegistered()) {
            String[] confNames = this.viewAsOneChain();
            this.checkSize(position, confNames.length);
            String confName = confNames[position];
            int retval = 0;
            if (this.getInHeaderProcessorsNamesList().contains(confName)) {
                retval |= 1;
            }
            if (this.getInFaultHeaderProcessorsNamesList().contains(confName)) {
                retval |= 4;
            }
            if (this.getOutHeaderProcessorsNamesList().contains(confName)) {
                retval |= 2;
            }
            if (this.getOutFaultHeaderProcessorsNamesList().contains(confName)) {
                retval |= 8;
            }
            return retval;
        }
        this.checkSize(position, this.dirtyHeaderProcessors.size());
        HeaderProcessorEntry entry = (HeaderProcessorEntry)this.dirtyHeaderProcessors.get(position);
        return entry.directions;
    }

    public boolean needsBody(int position) {
        if (this.isRegistered()) {
            String[] confNames = this.viewAsOneChain();
            this.checkSize(position, confNames.length);
            String confName = confNames[position];
            HeaderProcessorEntry entry = null;
            entry = this.getHeaderProcessorEntry(confName, 1);
            if (entry != null) {
                return entry.needsBody;
            }
            entry = this.getHeaderProcessorEntry(confName, 2);
            if (entry != null) {
                return entry.needsBody;
            }
            entry = this.getHeaderProcessorEntry(confName, 4);
            if (entry != null) {
                return entry.needsBody;
            }
            entry = this.getHeaderProcessorEntry(confName, 8);
            if (entry != null) {
                return entry.needsBody;
            }
            return false;
        }
        HeaderProcessorEntry entry = (HeaderProcessorEntry)this.dirtyHeaderProcessors.get(position);
        return entry.needsBody;
    }

    public void insert(int index, HeaderProcessor instance, int directions, QName[] understoodHeaders, boolean needsBody) throws IndexOutOfBoundsException {
        if (this.isRegistered()) {
            int position;
            int length = this.viewAsOneChain().length;
            if (index < 0 || index > length && index != Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("index: " + index + ", size: " + length);
            }
            String confName = this.waspConfiguration.registerHeaderProcessor(instance);
            ArrayList arrayList = this.order;
            synchronized (arrayList) {
                if (index > this.order.size() || index == Integer.MAX_VALUE) {
                    this.order.add(confName);
                } else {
                    this.order.add(index, confName);
                }
            }
            if ((directions & 1) != 0) {
                position = this.findSuitableIndex(confName, this.order, this.getInHeaderProcessors());
                this.addInHeaderProcessor(confName, understoodHeaders, position, needsBody);
            }
            if ((directions & 2) != 0) {
                position = this.findSuitableIndex(confName, this.order, this.getOutHeaderProcessors());
                this.addOutHeaderProcessor(confName, understoodHeaders, position, needsBody);
            }
            if ((directions & 4) != 0) {
                position = this.findSuitableIndex(confName, this.order, this.getInFaultHeaderProcessors());
                this.addInFaultHeaderProcessor(confName, understoodHeaders, position, needsBody);
            }
            if ((directions & 8) != 0) {
                position = this.findSuitableIndex(confName, this.order, this.getOutFaultHeaderProcessors());
                this.addOutFaultHeaderProcessor(confName, understoodHeaders, position, needsBody);
            }
        } else {
            HeaderProcessorEntry entry = new HeaderProcessorEntry(null, index, directions, understoodHeaders, instance, needsBody, null, null, -1);
            int position = index;
            if (position == Integer.MAX_VALUE) {
                position = this.dirtyHeaderProcessors.size();
            }
            if (position < 0 || position > this.dirtyHeaderProcessors.size()) {
                throw new IndexOutOfBoundsException("index: " + position + ", size: " + this.dirtyHeaderProcessors.size());
            }
            List list = this.dirtyHeaderProcessors;
            synchronized (list) {
                this.dirtyHeaderProcessors.add(position, entry);
            }
        }
    }

    public void insert(int index, HeaderProcessor instance, int directions, boolean needsBody, Header[] headers, Schema[] schemata) throws IndexOutOfBoundsException {
        if (this.isRegistered()) {
            int position;
            int length = this.viewAsOneChain().length;
            if (index < 0 || index > length && index != Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("index: " + index + ", size: " + length);
            }
            String confName = this.waspConfiguration.registerHeaderProcessor(instance);
            ArrayList arrayList = this.order;
            synchronized (arrayList) {
                if (index > this.order.size() || index == Integer.MAX_VALUE) {
                    this.order.add(confName);
                } else {
                    this.order.add(index, confName);
                }
            }
            if ((directions & 1) != 0) {
                position = this.findSuitableIndex(confName, this.order, this.getInHeaderProcessors());
                this.addInHeaderProcessor(confName, headers, schemata, position, needsBody);
            }
            if ((directions & 2) != 0) {
                position = this.findSuitableIndex(confName, this.order, this.getOutHeaderProcessors());
                this.addOutHeaderProcessor(confName, headers, schemata, position, needsBody);
            }
        } else {
            HeaderProcessorEntry entry = new HeaderProcessorEntry(null, index, directions, null, instance, needsBody, headers, schemata, -1);
            int position = index;
            if (position == Integer.MAX_VALUE) {
                position = this.dirtyHeaderProcessors.size();
            }
            if (position < 0 || position > this.dirtyHeaderProcessors.size()) {
                throw new IndexOutOfBoundsException("index: " + position + ", size: " + this.dirtyHeaderProcessors.size());
            }
            List list = this.dirtyHeaderProcessors;
            synchronized (list) {
                this.dirtyHeaderProcessors.add(position, entry);
            }
        }
    }

    public void insert(HeaderProcessor instance, int directions, QName[] understoodHeaders, boolean needsBody) {
        try {
            this.insert(Integer.MAX_VALUE, instance, directions, understoodHeaders, needsBody);
        }
        catch (IndexOutOfBoundsException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void insert(HeaderProcessor instance, int directions, boolean needsBody, Header[] headers, Schema[] schemata) {
        try {
            this.insert(Integer.MAX_VALUE, instance, directions, needsBody, headers, schemata);
        }
        catch (IndexOutOfBoundsException e) {
            log.error(e.getMessage(), e);
        }
    }

    public void remove(int position) throws IndexOutOfBoundsException {
        if (this.isRegistered()) {
            String[] confNames = this.viewAsOneChain();
            this.checkSize(position, confNames.length);
            String confName = confNames[position];
            if (this.getInHeaderProcessorsNamesList().contains(confName)) {
                this.removeInHeaderProcessor(confName);
            }
            if (this.getInFaultHeaderProcessorsNamesList().contains(confName)) {
                this.removeInFaultHeaderProcessor(confName);
            }
            if (this.getOutHeaderProcessorsNamesList().contains(confName)) {
                this.removeOutHeaderProcessor(confName);
            }
            if (this.getOutFaultHeaderProcessorsNamesList().contains(confName)) {
                this.removeOutFaultHeaderProcessor(confName);
            }
            ArrayList arrayList = this.order;
            synchronized (arrayList) {
                if (this.order.contains(confName)) {
                    this.order.remove(this.order.indexOf(confName));
                }
            }
        }
        this.checkSize(position, this.dirtyHeaderProcessors.size());
        List list = this.dirtyHeaderProcessors;
        synchronized (list) {
            this.dirtyHeaderProcessors.remove(position);
        }
    }

    public void setDirection(int position, int newDirections) throws IndexOutOfBoundsException {
        if (this.isRegistered()) {
            int index;
            String[] confNames = this.viewAsOneChain();
            this.checkSize(position, confNames.length);
            String confName = confNames[position];
            int actualDirections = this.getDirection(position);
            HeaderProcessorEntry entry2Clone = null;
            if (entry2Clone == null && (actualDirections & 1) != 0) {
                entry2Clone = this.getHeaderProcessorEntry(confName, 1);
            }
            if (entry2Clone == null && (actualDirections & 4) != 0) {
                entry2Clone = this.getHeaderProcessorEntry(confName, 4);
            }
            if (entry2Clone == null && (actualDirections & 2) != 0) {
                entry2Clone = this.getHeaderProcessorEntry(confName, 2);
            }
            if (entry2Clone == null && (actualDirections & 8) != 0) {
                entry2Clone = this.getHeaderProcessorEntry(confName, 8);
            }
            if (entry2Clone == null) {
                log.error("Cannot find header processor to set its direction.");
                return;
            }
            int directions2Change = newDirections ^ actualDirections;
            if ((directions2Change & 1) != 0) {
                if ((newDirections & 1) != 0) {
                    if (!this.getInHeaderProcessorsNamesList().contains(confName)) {
                        index = this.findSuitableIndex(confName, this.order, this.getInHeaderProcessors());
                        if (entry2Clone.headers != null || entry2Clone.schemata != null) {
                            this.addInHeaderProcessor(confName, entry2Clone.headers, entry2Clone.schemata, index, entry2Clone.needsBody);
                        } else {
                            this.addInHeaderProcessor(confName, entry2Clone.understoodHeaders, index, entry2Clone.needsBody);
                        }
                    }
                } else if (this.getInHeaderProcessorsNamesList().contains(confName)) {
                    this.removeInHeaderProcessor(confName);
                }
            }
            if ((directions2Change & 2) != 0) {
                if ((newDirections & 2) != 0) {
                    if (!this.getOutHeaderProcessorsNamesList().contains(confName)) {
                        index = this.findSuitableIndex(confName, this.order, this.getOutHeaderProcessors());
                        if (entry2Clone.headers != null || entry2Clone.schemata != null) {
                            this.addOutHeaderProcessor(confName, entry2Clone.headers, entry2Clone.schemata, index, entry2Clone.needsBody);
                        } else {
                            this.addOutHeaderProcessor(confName, entry2Clone.understoodHeaders, index, entry2Clone.needsBody);
                        }
                    }
                } else if (this.getOutHeaderProcessorsNamesList().contains(confName)) {
                    this.removeOutHeaderProcessor(confName);
                }
            }
            if ((directions2Change & 4) != 0) {
                if ((newDirections & 4) != 0) {
                    if (!this.getInFaultHeaderProcessorsNamesList().contains(confName)) {
                        index = this.findSuitableIndex(confName, this.order, this.getInFaultHeaderProcessors());
                        this.addInFaultHeaderProcessor(confName, entry2Clone.understoodHeaders, index, entry2Clone.needsBody);
                    }
                } else if (this.getInFaultHeaderProcessorsNamesList().contains(confName)) {
                    this.removeInFaultHeaderProcessor(confName);
                }
            }
            if ((directions2Change & 8) != 0) {
                if ((newDirections & 8) != 0) {
                    if (!this.getOutFaultHeaderProcessorsNamesList().contains(confName)) {
                        index = this.findSuitableIndex(confName, this.order, this.getOutFaultHeaderProcessors());
                        this.addOutFaultHeaderProcessor(confName, entry2Clone.understoodHeaders, index, entry2Clone.needsBody);
                    }
                } else if (this.getOutFaultHeaderProcessorsNamesList().contains(confName)) {
                    this.removeOutFaultHeaderProcessor(confName);
                }
            }
        } else {
            this.checkSize(position, this.dirtyHeaderProcessors.size());
            ((HeaderProcessorEntry)this.dirtyHeaderProcessors.get((int)position)).directions = newDirections;
        }
    }

    public synchronized boolean remove(HeaderProcessor instance) {
        boolean wasModified = false;
        if (this.isRegistered()) {
            String confName;
            HeaderProcessorEntry[] entries = this.getInHeaderProcessors();
            int i = 0;
            while (i < entries.length) {
                if (instance == entries[i].headerProcessor) {
                    confName = entries[i].name;
                    this.removeInHeaderProcessor(confName);
                    wasModified = true;
                }
                ++i;
            }
            entries = this.getOutHeaderProcessors();
            int i2 = 0;
            while (i2 < entries.length) {
                if (instance == entries[i2].headerProcessor) {
                    confName = entries[i2].name;
                    this.removeOutHeaderProcessor(confName);
                    wasModified = true;
                }
                ++i2;
            }
            entries = this.getInFaultHeaderProcessors();
            int i3 = 0;
            while (i3 < entries.length) {
                if (instance == entries[i3].headerProcessor) {
                    confName = entries[i3].name;
                    this.removeInFaultHeaderProcessor(confName);
                    wasModified = true;
                }
                ++i3;
            }
            entries = this.getOutFaultHeaderProcessors();
            int i4 = 0;
            while (i4 < entries.length) {
                if (instance == entries[i4].headerProcessor) {
                    confName = entries[i4].name;
                    this.removeOutFaultHeaderProcessor(confName);
                    wasModified = true;
                }
                ++i4;
            }
        } else {
            List list = this.dirtyHeaderProcessors;
            synchronized (list) {
                Iterator it = this.dirtyHeaderProcessors.iterator();
                while (it.hasNext()) {
                    HeaderProcessorEntry entry = (HeaderProcessorEntry)it.next();
                    if (instance != entry.headerProcessor) continue;
                    it.remove();
                    wasModified = true;
                }
            }
        }
        return wasModified;
    }

    public synchronized int size() {
        if (this.isRegistered()) {
            return this.viewAsOneChain().length;
        }
        return this.dirtyHeaderProcessors.size();
    }

    private ArrayList getDDOrder() {
        HeaderProcessorEntry[] in = this.getInHeaderProcessors();
        HeaderProcessorEntry[] out = this.getOutHeaderProcessors();
        HeaderProcessorEntry[] inFault = this.getInFaultHeaderProcessors();
        HeaderProcessorEntry[] outFault = this.getOutFaultHeaderProcessors();
        ArrayList<String> order = new ArrayList<String>(in.length + out.length + inFault.length + outFault.length);
        int i = 0;
        while (i < in.length) {
            if (in[i] != null && in[i].ddOrder != -1 && !order.contains(in[i].name)) {
                order.add(in[i].ddOrder, in[i].name);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < out.length) {
            if (out[i2] != null && out[i2].ddOrder != -1 && !order.contains(out[i2].name)) {
                order.add(out[i2].ddOrder, out[i2].name);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < inFault.length) {
            if (inFault[i3] != null && inFault[i3].ddOrder != -1 && !order.contains(inFault[i3].name)) {
                order.add(inFault[i3].ddOrder, inFault[i3].name);
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < outFault.length) {
            if (outFault[i4] != null && outFault[i4].ddOrder != -1 && !order.contains(outFault[i4].name)) {
                order.add(outFault[i4].ddOrder, outFault[i4].name);
            }
            ++i4;
        }
        return order;
    }

    private int findSuitableIndex(String confName, ArrayList order, HeaderProcessorEntry[] chain) {
        if (chain.length == 0) {
            return 0;
        }
        int orderIndex = order.indexOf(confName);
        if (orderIndex == 0) {
            return 0;
        }
        int chainIndex = 0;
        while (chainIndex < chain.length && order.indexOf(chain[chainIndex].name) < orderIndex) {
            ++chainIndex;
        }
        return chainIndex;
    }

    protected String[] viewAsOneChain() {
        if (this.isRegistered()) {
            ArrayList<String> retval = new ArrayList<String>(this.order.size());
            int i = 0;
            while (i < this.order.size()) {
                retval.add(null);
                ++i;
            }
            ArrayList<String> unknownOrder = new ArrayList<String>();
            String[] in = this.getInHeaderProcessorsNames();
            int i2 = 0;
            while (i2 < in.length) {
                if (!this.order.contains(in[i2])) {
                    if (!unknownOrder.contains(in[i2])) {
                        unknownOrder.add(in[i2]);
                    }
                } else if (!retval.contains(in[i2])) {
                    retval.add(this.order.indexOf(in[i2]), in[i2]);
                }
                ++i2;
            }
            String[] out = this.getOutHeaderProcessorsNames();
            i2 = 0;
            while (i2 < out.length) {
                if (!this.order.contains(out[i2])) {
                    if (!unknownOrder.contains(out[i2])) {
                        unknownOrder.add(out[i2]);
                    }
                } else if (!retval.contains(out[i2])) {
                    retval.add(this.order.indexOf(out[i2]), out[i2]);
                }
                ++i2;
            }
            String[] inFault = this.getInFaultHeaderProcessorsNames();
            i2 = 0;
            while (i2 < inFault.length) {
                if (!this.order.contains(inFault[i2])) {
                    if (!unknownOrder.contains(inFault[i2])) {
                        unknownOrder.add(inFault[i2]);
                    }
                } else if (!retval.contains(inFault[i2])) {
                    retval.add(this.order.indexOf(inFault[i2]), inFault[i2]);
                }
                ++i2;
            }
            String[] outFault = this.getOutFaultHeaderProcessorsNames();
            i2 = 0;
            while (i2 < outFault.length) {
                if (!this.order.contains(outFault[i2])) {
                    if (!unknownOrder.contains(outFault[i2])) {
                        unknownOrder.add(outFault[i2]);
                    }
                } else if (!retval.contains(outFault[i2])) {
                    retval.add(this.order.indexOf(outFault[i2]), outFault[i2]);
                }
                ++i2;
            }
            retval.addAll(unknownOrder);
            Iterator it = ((AbstractList)retval).iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return retval.toArray(new String[0]);
        }
        String[] retval = new String[this.dirtyHeaderProcessors.size()];
        int i = 0;
        while (i < this.dirtyHeaderProcessors.size()) {
            retval[i] = ((HeaderProcessorEntry)this.dirtyHeaderProcessors.get((int)i)).name;
            ++i;
        }
        return retval;
    }

    public void postRegistrate(String headersID) {
        if (this.registrated) {
            throw new IllegalStateException("Already registrated (postRegistrate() can be run only once..)");
        }
        this.registrated = true;
        this.headersID = headersID;
        this.registerDirtyHeaderProcessors();
    }

    protected boolean isRegistered() {
        return this.headersID != null;
    }

    protected void checkSize(int position, int length) throws IndexOutOfBoundsException {
        if (position < 0 || position >= length) {
            throw new IndexOutOfBoundsException("index: " + position + ", size: " + length);
        }
    }

    protected synchronized void registerDirtyHeaderProcessors() {
        if (this.order == null) {
            this.order = new ArrayList(5);
        }
        int i = 0;
        while (i < this.dirtyHeaderProcessors.size()) {
            HeaderProcessorEntry entry = (HeaderProcessorEntry)this.dirtyHeaderProcessors.get(i);
            String confName = this.waspConfiguration.registerHeaderProcessor(entry.headerProcessor);
            this.order.add(confName);
            if ((entry.directions & 1) != 0) {
                if (entry.headers != null || entry.schemata != null) {
                    this.addInHeaderProcessor(confName, entry.headers, entry.schemata, entry.needsBody);
                } else {
                    this.addInHeaderProcessor(confName, entry.understoodHeaders, entry.needsBody);
                }
            }
            if ((entry.directions & 2) != 0) {
                if (entry.headers != null || entry.schemata != null) {
                    this.addOutHeaderProcessor(confName, entry.headers, entry.schemata, entry.needsBody);
                } else {
                    this.addOutHeaderProcessor(confName, entry.understoodHeaders, entry.needsBody);
                }
            }
            if ((entry.directions & 4) != 0) {
                this.addInFaultHeaderProcessor(confName, entry.understoodHeaders, entry.needsBody);
            }
            if ((entry.directions & 8) != 0) {
                this.addOutFaultHeaderProcessor(confName, entry.understoodHeaders, entry.needsBody);
            }
            ++i;
        }
        this.dirtyHeaderProcessors.clear();
        this.dirtyHeaderProcessors = null;
    }

    public abstract String getHeadersID(boolean var1);

    public void addInHeaderProcessor(String name, Header[] headers, Schema[] schemata, boolean needsBody) {
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain inHpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        Vector<HPInstance.Header> inInstanceHeaders = new Vector<HPInstance.Header>();
        Vector<HPInstance.Schema> instancesSchemata = new Vector<HPInstance.Schema>();
        String locationURL = null;
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                Header header = headers[i];
                if (header.getDirection() == 1 || header.getDirection() == 3) {
                    inInstanceHeaders.add(new HPInstance.Header(header.getName(), header.getType(), header.getClazz(), header.getDirection()));
                }
                ++i;
            }
        }
        if (schemata != null) {
            int i = 0;
            while (i < schemata.length) {
                Schema schema = schemata[i];
                locationURL = schema.getLocation();
                Endpoint endpoint = null;
                URL url = null;
                try {
                    endpoint = new Endpoint(locationURL);
                }
                catch (MalformedURLException e) {
                    break;
                }
                if ("resource".equals(endpoint.getScheme())) {
                    String path = endpoint.getPath();
                    while (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    url = (class$com$systinet$wasp$webservice$HeaderProcessorsImpl == null ? HeaderProcessorsImpl.class$("com.systinet.wasp.webservice.HeaderProcessorsImpl") : class$com$systinet$wasp$webservice$HeaderProcessorsImpl).getClassLoader().getResource(path);
                    if (url == null) {
                        HeaderProcessor headerProcessor = this.hpRepo.getHPInstance(name);
                        if (headerProcessor != null) {
                            url = headerProcessor.getClass().getClassLoader().getResource(path);
                        } else {
                            log.warn("Cannot get instance of header processor " + name);
                        }
                    }
                }
                instancesSchemata.add(new HPInstance.Schema(url.toExternalForm(), schema.getNamespace()));
                ++i;
            }
        }
        HeaderProcessorChain headerProcessorChain = inHpChain;
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(inHpChain, name, inInstanceHeaders.toArray(new HPInstance.Header[0]), instancesSchemata.toArray(new HPInstance.Schema[0]), needsBody);
        }
    }

    public void addOutHeaderProcessor(String name, Header[] headers, Schema[] schemata, boolean needsBody) {
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain outHpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        Vector<HPInstance.Header> outInstanceHeaders = new Vector<HPInstance.Header>();
        Vector<HPInstance.Schema> instancesSchemata = new Vector<HPInstance.Schema>();
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                Header header = headers[i];
                if (header.getDirection() == 2 || header.getDirection() == 3) {
                    outInstanceHeaders.add(new HPInstance.Header(header.getName(), header.getType(), header.getClazz(), header.getDirection()));
                }
                ++i;
            }
        }
        if (schemata != null) {
            int i = 0;
            while (i < schemata.length) {
                Schema schema = schemata[i];
                String locationURL = schema.getLocation();
                Endpoint endpoint = null;
                URL url = null;
                try {
                    endpoint = new Endpoint(locationURL);
                }
                catch (MalformedURLException e) {
                    break;
                }
                if ("resource".equals(endpoint.getScheme())) {
                    String path = endpoint.getPath();
                    while (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    url = (class$com$systinet$wasp$webservice$HeaderProcessorsImpl == null ? HeaderProcessorsImpl.class$("com.systinet.wasp.webservice.HeaderProcessorsImpl") : class$com$systinet$wasp$webservice$HeaderProcessorsImpl).getClassLoader().getResource(path);
                    if (url == null) {
                        HeaderProcessor headerProcessor = this.hpRepo.getHPInstance(name);
                        if (headerProcessor != null) {
                            url = headerProcessor.getClass().getClassLoader().getResource(path);
                        } else {
                            log.warn("Cannot get instance of header processor " + name);
                        }
                    }
                }
                instancesSchemata.add(new HPInstance.Schema(url.toExternalForm(), schema.getNamespace()));
                ++i;
            }
        }
        HeaderProcessorChain headerProcessorChain = outHpChain;
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(outHpChain, name, outInstanceHeaders.toArray(new HPInstance.Header[0]), instancesSchemata.toArray(new HPInstance.Schema[0]), needsBody);
        }
    }

    public void addInHeaderProcessor(String name, Header[] headers, Schema[] schemata, int position, boolean needsBody) {
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain inHpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        Vector<HPInstance.Header> inInstanceHeaders = new Vector<HPInstance.Header>();
        Vector<HPInstance.Schema> instancesSchemata = new Vector<HPInstance.Schema>();
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                Header header = headers[i];
                if (header.getDirection() == 1 || header.getDirection() == 3) {
                    inInstanceHeaders.add(new HPInstance.Header(header.getName(), header.getType(), header.getClazz(), header.getDirection()));
                }
                ++i;
            }
        }
        if (schemata != null) {
            int i = 0;
            while (i < schemata.length) {
                Schema schema = schemata[i];
                String locationURL = schema.getLocation();
                Endpoint endpoint = null;
                URL url = null;
                try {
                    endpoint = new Endpoint(locationURL);
                }
                catch (MalformedURLException e) {
                    break;
                }
                if ("resource".equals(endpoint.getScheme())) {
                    String path = endpoint.getPath();
                    while (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    url = (class$com$systinet$wasp$webservice$HeaderProcessorsImpl == null ? HeaderProcessorsImpl.class$("com.systinet.wasp.webservice.HeaderProcessorsImpl") : class$com$systinet$wasp$webservice$HeaderProcessorsImpl).getClassLoader().getResource(path);
                    if (url == null) {
                        HeaderProcessor headerProcessor = this.hpRepo.getHPInstance(name);
                        if (headerProcessor != null) {
                            url = headerProcessor.getClass().getClassLoader().getResource(path);
                        } else {
                            log.warn("Cannot get instance of header processor " + name);
                        }
                    }
                }
                instancesSchemata.add(new HPInstance.Schema(url.toExternalForm(), schema.getNamespace()));
                ++i;
            }
        }
        HeaderProcessorChain headerProcessorChain = inHpChain;
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(inHpChain, name, inInstanceHeaders.toArray(new HPInstance.Header[0]), instancesSchemata.toArray(new HPInstance.Schema[0]), position, needsBody);
        }
    }

    public void addOutHeaderProcessor(String name, Header[] headers, Schema[] schemata, int position, boolean needsBody) {
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain outHpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        Vector<HPInstance.Header> outInstanceHeaders = new Vector<HPInstance.Header>();
        Vector<HPInstance.Schema> instancesSchemata = new Vector<HPInstance.Schema>();
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                Header header = headers[i];
                if (header.getDirection() == 2 || header.getDirection() == 3) {
                    outInstanceHeaders.add(new HPInstance.Header(header.getName(), header.getType(), header.getClazz(), header.getDirection()));
                }
                ++i;
            }
        }
        if (schemata != null) {
            int i = 0;
            while (i < schemata.length) {
                Schema schema = schemata[i];
                String locationURL = schema.getLocation();
                Endpoint endpoint = null;
                URL url = null;
                try {
                    endpoint = new Endpoint(locationURL);
                }
                catch (MalformedURLException e) {
                    break;
                }
                if ("resource".equals(endpoint.getScheme())) {
                    String path = endpoint.getPath();
                    while (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    url = (class$com$systinet$wasp$webservice$HeaderProcessorsImpl == null ? HeaderProcessorsImpl.class$("com.systinet.wasp.webservice.HeaderProcessorsImpl") : class$com$systinet$wasp$webservice$HeaderProcessorsImpl).getClassLoader().getResource(path);
                    if (url == null) {
                        HeaderProcessor headerProcessor = this.hpRepo.getHPInstance(name);
                        if (headerProcessor != null) {
                            url = headerProcessor.getClass().getClassLoader().getResource(path);
                        } else {
                            log.warn("Cannot get instance of header processor " + name);
                        }
                    }
                }
                instancesSchemata.add(new HPInstance.Schema(url.toExternalForm(), schema.getNamespace()));
                ++i;
            }
        }
        HeaderProcessorChain headerProcessorChain = outHpChain;
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(outHpChain, name, outInstanceHeaders.toArray(new HPInstance.Header[0]), instancesSchemata.toArray(new HPInstance.Schema[0]), position, needsBody);
        }
    }

    public void addInHeaderProcessor(String name, QName[] understoodHeaders, boolean needsBody) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, needsBody);
        }
    }

    public void addInHeaderProcessor(String name, QName[] understoodHeaders, int position, boolean needsBody) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, position, needsBody);
        }
    }

    public void removeInHeaderProcessor(String name) {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return;
        }
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            HeaderProcessorRepositoryImpl.removeHeaderProcessor(hpChain, name);
        }
    }

    HeaderProcessorEntry[] getInHeaderProcessors() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_HPE_ARRAY;
        }
        return this.getHeaderEntries(hpChain);
    }

    private String[] getInHeaderProcessorsNames() {
        List names = this.getInHeaderProcessorsNamesList();
        return names.toArray(EMPTY_STRING_ARRAY);
    }

    private List getInHeaderProcessorsNamesList() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_LIST;
        }
        return hpChain.getHeaderProcessorNames();
    }

    public void addOutHeaderProcessor(String name, QName[] understoodHeaders, boolean needsBody) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, needsBody);
        }
    }

    public void addOutHeaderProcessor(String name, QName[] understoodHeaders, int position, boolean needsBody) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, position, needsBody);
        }
    }

    public void removeOutHeaderProcessor(String name) {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return;
        }
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            HeaderProcessorRepositoryImpl.removeHeaderProcessor(hpChain, name);
        }
    }

    HeaderProcessorEntry[] getOutHeaderProcessors() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_HPE_ARRAY;
        }
        return this.getHeaderEntries(hpChain);
    }

    private String[] getOutHeaderProcessorsNames() {
        List names = this.getOutHeaderProcessorsNamesList();
        return names.toArray(EMPTY_STRING_ARRAY);
    }

    private List getOutHeaderProcessorsNamesList() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_LIST;
        }
        return hpChain.getHeaderProcessorNames();
    }

    public void addInFaultHeaderProcessor(String name, QName[] understoodHeaders, boolean needsBody) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, needsBody);
        }
    }

    public void addInFaultHeaderProcessor(String name, QName[] understoodHeaders, int position, boolean needsBody) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, position, needsBody);
        }
    }

    public void removeInFaultHeaderProcessor(String name) {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return;
        }
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            HeaderProcessorRepositoryImpl.removeHeaderProcessor(hpChain, name);
        }
    }

    private HeaderProcessorEntry getHeaderProcessorEntry(String name, int direction) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = null;
        switch (direction) {
            case 1: {
                hpChain = this.hpRepo.getIncomingHeaderProcessors(headersName);
                break;
            }
            case 4: {
                hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
                break;
            }
            case 2: {
                hpChain = this.hpRepo.getOutgoingHeaderProcessors(headersName);
                break;
            }
            case 8: {
                hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction");
            }
        }
        HeaderProcessorEntry[] entries = this.getHeaderEntries(hpChain);
        int i = 0;
        while (i < entries.length) {
            if (name.equals(entries[i].name)) {
                return entries[i];
            }
            ++i;
        }
        return null;
    }

    private HeaderProcessorEntry getHeaderProcessorEntry(String confName) {
        HeaderProcessorEntry entry = this.getHeaderProcessorEntry(confName, 1);
        if (entry != null) {
            return entry;
        }
        entry = this.getHeaderProcessorEntry(confName, 2);
        if (entry != null) {
            return entry;
        }
        entry = this.getHeaderProcessorEntry(confName, 4);
        if (entry != null) {
            return entry;
        }
        entry = this.getHeaderProcessorEntry(confName, 8);
        if (entry != null) {
            return entry;
        }
        return null;
    }

    HeaderProcessorEntry[] getInFaultHeaderProcessors() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_HPE_ARRAY;
        }
        return this.getHeaderEntries(hpChain);
    }

    private String[] getInFaultHeaderProcessorsNames() {
        List names = this.getInFaultHeaderProcessorsNamesList();
        return names.toArray(EMPTY_STRING_ARRAY);
    }

    private List getInFaultHeaderProcessorsNamesList() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getInputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_LIST;
        }
        return hpChain.getHeaderProcessorNames();
    }

    public void addOutFaultHeaderProcessor(String name, QName[] understoodHeaders, boolean needsBody) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, needsBody);
        }
    }

    public void addOutFaultHeaderProcessor(String name, QName[] understoodHeaders, int position, boolean needsBody) {
        HeaderProcessorChain hpChain;
        String headersName = this.getHeadersID(true);
        HeaderProcessorChain headerProcessorChain = hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
        synchronized (headerProcessorChain) {
            this.hpRepo.addHeaderProcessor(hpChain, name, understoodHeaders, position, needsBody);
        }
    }

    public void removeOutFaultHeaderProcessor(String name) {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return;
        }
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            HeaderProcessorRepositoryImpl.removeHeaderProcessor(hpChain, name);
        }
    }

    HeaderProcessorEntry[] getOutFaultHeaderProcessors() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_HPE_ARRAY;
        }
        return this.getHeaderEntries(hpChain);
    }

    private String[] getOutFaultHeaderProcessorsNames() {
        List names = this.getOutFaultHeaderProcessorsNamesList();
        return names.toArray(EMPTY_STRING_ARRAY);
    }

    private List getOutFaultHeaderProcessorsNamesList() {
        String headersName = this.getHeadersID(false);
        HeaderProcessorChain hpChain = this.hpRepo.getOutputFaultHeaderProcessors(headersName);
        if (headersName == null || hpChain == null) {
            return EMPTY_LIST;
        }
        return hpChain.getHeaderProcessorNames();
    }

    HeaderProcessorEntry[] getHeaderEntries(HeaderProcessorChain hpChain) {
        HeaderProcessorChain headerProcessorChain = hpChain;
        synchronized (headerProcessorChain) {
            String[] names = HeaderProcessorRepositoryImpl.getHeaderProcessors(hpChain);
            HeaderProcessorEntry[] retval = new HeaderProcessorEntry[names.length];
            int i = 0;
            while (i < names.length) {
                retval[i] = new HeaderProcessorEntry();
                retval[i].name = names[i];
                retval[i].understoodHeaders = hpChain.getUnderstandHeaders(i);
                retval[i].headerProcessor = hpChain.getHeaderProcessor(i);
                retval[i].needsBody = ((HeaderProcessorChainImpl)hpChain).needsBody(i);
                retval[i].position = i;
                if (hpChain.getHPInstance(i).getHeaders() != null) {
                    retval[i].headers = hpChain.getHPInstance(i).getHeaders().toArray(EMPTY_HEADERS);
                }
                if (hpChain.getHPInstance(i).getSchemas() != null) {
                    retval[i].schemata = hpChain.getHPInstance(i).getSchemas().toArray(EMPTY_SCHEMATA);
                }
                retval[i].ddOrder = hpChain.getHPInstance(i).getDdOrder();
                ++i;
            }
            HeaderProcessorEntry[] headerProcessorEntryArray = retval;
            return headerProcessorEntryArray;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        String[] hps = this.viewAsOneChain();
        sb.append("HeaderProcessors\n");
        int i = 0;
        while (i < hps.length) {
            sb.append("\t" + hps[i] + "\n");
            ++i;
        }
        sb.append("order: " + this.order.toString());
        if (this.isRegistered()) {
            sb.append("\nrepository chains");
            sb.append("\n in      : " + this.getInHeaderProcessorsNamesList().toString());
            sb.append("\n out     : " + this.getOutHeaderProcessorsNamesList().toString());
            sb.append("\n infault : " + this.getInFaultHeaderProcessorsNamesList().toString());
            sb.append("\n outfault: " + this.getOutFaultHeaderProcessorsNamesList().toString());
        } else {
            sb.append("\nprocessing not registered yet");
        }
        return sb.toString();
    }

    public Object clone() {
        HeaderProcessorsImpl clone = this.createClone();
        if (!this.isRegistered()) {
            HeaderProcessorEntry[] entries = this.dirtyHeaderProcessors.toArray(EMPTY_HPE_ARRAY);
            int j = 0;
            while (j < entries.length) {
                HeaderProcessorEntry entry = entries[j];
                if (entry.headers != null || entry.schemata != null) {
                    clone.insert(entry.position, entry.headerProcessor, entry.directions, entry.needsBody, entry.headers, entry.schemata);
                } else {
                    clone.insert(entry.position, entry.headerProcessor, entry.directions, entry.understoodHeaders, entry.needsBody);
                }
                ++j;
            }
        } else {
            String[] confNames = this.viewAsOneChain();
            int i = 0;
            while (i < confNames.length) {
                HeaderProcessorEntry entry = this.getHeaderProcessorEntry(confNames[i]);
                if (entry != null) {
                    entry.directions = this.getDirection(i);
                    if (entry.headers != null || entry.schemata != null) {
                        clone.insert(entry.headerProcessor, entry.directions, entry.needsBody, entry.headers, entry.schemata);
                    } else {
                        clone.insert(entry.headerProcessor, entry.directions, entry.understoodHeaders, entry.needsBody);
                    }
                }
                ++i;
            }
        }
        return clone;
    }

    protected abstract HeaderProcessorsImpl createClone();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class HeaderProcessorEntry {
        public String name;
        public int position;
        public int directions;
        public QName[] understoodHeaders;
        public HeaderProcessor headerProcessor;
        public boolean needsBody;
        public Header[] headers;
        public Schema[] schemata;
        public int ddOrder;

        public HeaderProcessorEntry() {
        }

        public HeaderProcessorEntry(String name, int position, int directions, QName[] understoodHeaders, HeaderProcessor headerProcessor, boolean needsBody, Header[] headers, Schema[] schemata, int ddOrder) {
            this.name = name;
            this.position = position;
            this.directions = directions;
            this.understoodHeaders = understoodHeaders;
            this.headerProcessor = headerProcessor;
            this.needsBody = needsBody;
            this.headers = headers;
            this.schemata = schemata;
            this.ddOrder = ddOrder;
        }
    }
}

